/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.gmavenplus.model.GroovyCompileConfiguration;
import org.codehaus.gmavenplus.model.GroovyDocConfiguration;
import org.codehaus.gmavenplus.model.GroovyStubConfiguration;
import org.codehaus.gmavenplus.model.IncludeClasspath;
import org.codehaus.gmavenplus.util.ClassWrangler;
import org.codehaus.gmavenplus.util.GroovyCompiler;

public class ForkedGroovyCompiler {
    public static void main(String[] args) {
        block20: {
            if (args.length != 1) {
                System.err.println("Usage: java " + ForkedGroovyCompiler.class.getName() + " <configuration-file>");
                System.exit(1);
            }
            String configFilePath = args[0];
            try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(Paths.get(configFilePath, new String[0]), new OpenOption[0]));){
                List<Object> finalClasspath;
                Object configuration = ois.readObject();
                SystemStreamLog log = new SystemStreamLog();
                List<Object> classpath = Collections.emptyList();
                IncludeClasspath includeClasspath = null;
                if (configuration instanceof GroovyCompileConfiguration) {
                    classpath = ((GroovyCompileConfiguration)configuration).getClasspath();
                    includeClasspath = ((GroovyCompileConfiguration)configuration).getIncludeClasspath();
                } else if (configuration instanceof GroovyStubConfiguration) {
                    classpath = ((GroovyStubConfiguration)configuration).getClasspath();
                    includeClasspath = ((GroovyStubConfiguration)configuration).getIncludeClasspath();
                } else if (configuration instanceof GroovyDocConfiguration) {
                    classpath = ((GroovyDocConfiguration)configuration).getClasspath();
                    includeClasspath = ((GroovyDocConfiguration)configuration).getIncludeClasspath();
                }
                ClassLoader parent = ClassLoader.getSystemClassLoader();
                if (includeClasspath != null && includeClasspath.name().equals("PROJECT_ONLY")) {
                    try {
                        Method getPlatformClassLoader = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]);
                        parent = (ClassLoader)getPlatformClassLoader.invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        parent = null;
                    }
                }
                List<Object> list = finalClasspath = classpath != null ? classpath : Collections.emptyList();
                if (includeClasspath != null && includeClasspath.name().equals("PLUGIN_ONLY")) {
                    finalClasspath = Collections.emptyList();
                }
                ClassWrangler classWrangler = new ClassWrangler(finalClasspath, parent, (Log)log);
                GroovyCompiler compiler = new GroovyCompiler(classWrangler, (Log)log);
                if (configuration instanceof GroovyCompileConfiguration) {
                    compiler.compile((GroovyCompileConfiguration)configuration);
                    break block20;
                }
                if (configuration instanceof GroovyStubConfiguration) {
                    compiler.generateStubs((GroovyStubConfiguration)configuration);
                    break block20;
                }
                if (configuration instanceof GroovyDocConfiguration) {
                    compiler.generateGroovyDoc((GroovyDocConfiguration)configuration);
                    break block20;
                }
                throw new IllegalArgumentException("Unknown configuration type: " + configuration.getClass().getName());
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

