/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.gmavenplus.model.GroovyStubConfiguration;
import org.codehaus.gmavenplus.model.IncludeClasspath;
import org.codehaus.gmavenplus.model.internal.Version;
import org.codehaus.gmavenplus.mojo.AbstractGroovyStubSourcesMojo;
import org.codehaus.gmavenplus.util.GroovyCompiler;

public abstract class AbstractGenerateStubsMojo
extends AbstractGroovyStubSourcesMojo {
    protected static final Version GROOVY_1_8_2 = new Version(1, 8, 2);
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;
    @Parameter(property="maven.compiler.target", defaultValue="1.8")
    protected String targetBytecode;
    @Parameter(property="skipBytecodeCheck", defaultValue="false")
    protected boolean skipBytecodeCheck;
    @Parameter(defaultValue="false")
    protected boolean debug;
    @Parameter(defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="1")
    protected int warningLevel;
    @Parameter(defaultValue="0")
    protected int tolerance;
    @Parameter(defaultValue="PROJECT_ONLY")
    protected IncludeClasspath includeClasspath;
    @Inject
    protected ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="fork", defaultValue="false")
    protected boolean fork;

    protected synchronized void doStubGeneration(Set<File> stubSources, List<?> classpath, File outputDirectory) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException, MalformedURLException {
        if (stubSources == null || stubSources.isEmpty()) {
            this.getLog().info((CharSequence)"No sources specified for stub generation. Skipping.");
            return;
        }
        GroovyStubConfiguration configuration = new GroovyStubConfiguration(stubSources, classpath, outputDirectory);
        configuration.setIncludeClasspath(this.includeClasspath);
        configuration.setSkipBytecodeCheck(this.skipBytecodeCheck);
        configuration.setDebug(this.debug);
        configuration.setVerbose(this.verbose);
        configuration.setWarningLevel(this.warningLevel);
        configuration.setTolerance(this.tolerance);
        configuration.setSourceEncoding(this.sourceEncoding);
        configuration.setTargetBytecode(this.targetBytecode);
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (toolchain != null) {
            this.getLog().info((CharSequence)("Toolchain in gmavenplus-plugin: " + toolchain));
            this.performForkedStubGeneration(configuration, toolchain.findTool("java"));
        } else if (this.fork) {
            String javaExecutable = this.getJavaExecutable();
            this.getLog().info((CharSequence)("Forking stub generation using " + javaExecutable));
            this.performForkedStubGeneration(configuration, javaExecutable);
        } else {
            this.getLog().info((CharSequence)"Performing in-process stub generation");
            this.performInProcessStubGeneration(configuration, classpath);
        }
    }

    protected void performInProcessStubGeneration(GroovyStubConfiguration configuration, List<?> classpath) throws MalformedURLException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this.setupClassWrangler(classpath, this.includeClasspath);
        this.logPluginClasspath();
        this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
        GroovyCompiler compiler = new GroovyCompiler(this.classWrangler, this.getLog());
        compiler.generateStubs(configuration);
    }

    protected void performForkedStubGeneration(GroovyStubConfiguration configuration, String javaExecutable) throws InvocationTargetException {
        try {
            File configFile = File.createTempFile("groovy-stub-config", ".ser");
            configFile.deleteOnExit();
            try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(configFile.toPath(), new OpenOption[0]));){
                oos.writeObject(configuration);
            }
            String forkClasspath = this.buildForkClasspath();
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaExecutable);
            command.add("-cp");
            command.add(forkClasspath);
            command.add("org.codehaus.gmavenplus.util.ForkedGroovyCompiler");
            command.add(configFile.getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.inheritIO();
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new InvocationTargetException(new RuntimeException("Forked stub generation failed with exit code " + exitCode));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected String buildForkClasspath() {
        StringBuilder cp = new StringBuilder();
        cp.append(this.pluginDescriptor.getPluginArtifact().getFile().getAbsolutePath());
        for (Artifact artifact : this.pluginDescriptor.getArtifacts()) {
            cp.append(File.pathSeparator);
            cp.append(artifact.getFile().getAbsolutePath());
        }
        try {
            Class<Log> logClass = Log.class;
            CodeSource codeSource = logClass.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                String logJar = new File(codeSource.getLocation().toURI()).getAbsolutePath();
                cp.append(File.pathSeparator).append(logJar);
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Could not find maven-plugin-api jar to add to fork classpath", (Throwable)e);
        }
        return cp.toString();
    }

    protected void logGeneratedStubs(File outputDirectory) {
        Set<File> stubs = this.getStubs(outputDirectory);
        this.getLog().info((CharSequence)("Generated " + stubs.size() + " stub" + (stubs.size() != 1 ? "s" : "") + "."));
    }

    protected void resetStubModifiedDates(Set<File> stubs) {
        for (File stub : stubs) {
            boolean success = stub.setLastModified(0L);
            if (success) continue;
            this.getLog().warn((CharSequence)("Unable to set modified time on stub " + stub.getAbsolutePath() + "."));
        }
    }
}

