/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.license.LicenseMojoUtils;
import org.codehaus.mojo.license.ThirdPartyReportRenderer;
import org.codehaus.mojo.license.api.ArtifactFilters;
import org.codehaus.mojo.license.api.DefaultThirdPartyDetails;
import org.codehaus.mojo.license.api.DefaultThirdPartyHelper;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.DependenciesToolException;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.api.ThirdPartyDetails;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.mojo.license.utils.UrlRequester;
import org.codehaus.plexus.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThirdPartyReport
extends AbstractMavenReport
implements MavenProjectDependenciesConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractThirdPartyReport.class);
    @Parameter(property="license.excludedScopes", defaultValue="system")
    private String excludedScopes;
    @Parameter(property="license.includedScopes")
    private String includedScopes;
    @Parameter(property="license.excludedTypes")
    private String excludedTypes;
    @Parameter(property="license.includedTypes")
    private String includedTypes;
    @Parameter(property="license.excludedGroups")
    private String excludedGroups;
    @Parameter(property="license.includedGroups")
    private String includedGroups;
    @Parameter(property="license.excludedArtifacts")
    private String excludedArtifacts;
    @Parameter(property="license.includedArtifacts")
    private String includedArtifacts;
    @Parameter(property="license.includeTransitiveDependencies", defaultValue="true")
    private boolean includeTransitiveDependencies;
    @Parameter(property="license.excludeTransitiveDependencies", defaultValue="false")
    private boolean excludeTransitiveDependencies;
    @Parameter(property="license.includeOptional", defaultValue="true")
    boolean includeOptional;
    @Parameter(property="license.useMissingFile", defaultValue="false")
    private boolean useMissingFile;
    @Parameter(property="license.missingFile", defaultValue="src/license/THIRD-PARTY.properties")
    private File missingFile;
    @Parameter(property="license.missingFileUrl")
    String missingFileUrl;
    @Deprecated
    @Parameter(property="license.overrideFile")
    private File overrideFile;
    @Parameter(property="license.overrideUrl")
    private String overrideUrl;
    String resolvedOverrideUrl;
    @Parameter(property="license.useRepositoryMissingFiles", defaultValue="true")
    private boolean useRepositoryMissingFiles;
    @Parameter
    private List<String> licenseMerges;
    @Parameter(property="license.licenseMergesUrl")
    protected String licenseMergesUrl;
    @Parameter(property="license.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(property="license.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    private final I18N i18n;
    private final DependenciesTool dependenciesTool;
    private final ThirdPartyTool thirdPartyTool;
    @Parameter(property="license.artifactFiltersUrl")
    private String artifactFiltersUrl;
    private ArtifactFilters artifactFilters;

    protected AbstractThirdPartyReport(I18N i18n, DependenciesTool dependenciesTool, ThirdPartyTool thirdPartyTool) {
        this.i18n = i18n;
        this.dependenciesTool = dependenciesTool;
        this.thirdPartyTool = thirdPartyTool;
    }

    protected abstract Collection<ThirdPartyDetails> createThirdPartyDetails() throws IOException, ThirdPartyToolException, ProjectBuildingException, MojoFailureException, InvalidDependencyVersionException, ArtifactNotFoundException, ArtifactResolutionException, DependenciesToolException, MojoExecutionException;

    protected void init() throws IOException {
        if (this.licenseMergesUrl != null) {
            LOG.warn("");
            LOG.warn("licenseMerges will be overridden by licenseMergesUrl.");
            LOG.warn("");
            if (UrlRequester.isStringUrl(this.licenseMergesUrl)) {
                this.licenseMerges = Arrays.asList(UrlRequester.getFromUrl(this.licenseMergesUrl).split("[\n\r]+"));
            }
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Collection<ThirdPartyDetails> details;
        this.resolvedOverrideUrl = LicenseMojoUtils.prepareThirdPartyOverrideUrl(this.resolvedOverrideUrl, this.overrideFile, this.overrideUrl, this.project.getBasedir());
        try {
            this.init();
            details = this.createThirdPartyDetails();
        }
        catch (IOException | ArtifactNotFoundException | ArtifactResolutionException | MojoExecutionException | MojoFailureException | ProjectBuildingException | DependenciesToolException | ThirdPartyToolException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        ThirdPartyReportRenderer renderer = new ThirdPartyReportRenderer(this.getSink(), this.i18n, this.getOutputPath(), locale, details);
        renderer.render();
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString(this.getOutputPath(), locale, "report.description");
    }

    public String getName(Locale locale) {
        return this.i18n.getString(this.getOutputPath(), locale, "report.title");
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    @Override
    public boolean isExcludeTransitiveDependencies() {
        return this.excludeTransitiveDependencies;
    }

    @Override
    public ArtifactFilters getArtifactFilters() {
        if (this.artifactFilters == null) {
            this.artifactFilters = ArtifactFilters.of(this.includedGroups, this.excludedGroups, this.includedArtifacts, this.excludedArtifacts, this.includedScopes, this.excludedScopes, this.includedTypes, this.excludedTypes, this.includeOptional, this.artifactFiltersUrl, this.getEncoding());
        }
        return this.artifactFilters;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    Collection<ThirdPartyDetails> createThirdPartyDetails(MavenProject project, boolean loadArtifacts) throws IOException, ThirdPartyToolException, ProjectBuildingException, MojoFailureException, DependenciesToolException, MojoExecutionException {
        ResolvedProjectDependencies loadedDependencies = loadArtifacts ? new ResolvedProjectDependencies(project.getArtifacts(), MojoHelper.getDependencyArtifacts(project)) : new ResolvedProjectDependencies(this.getProject().getArtifacts(), MojoHelper.getDependencyArtifacts(project));
        DefaultThirdPartyHelper thirdPartyHelper = new DefaultThirdPartyHelper(project, this.encoding, this.verbose, this.dependenciesTool, this.thirdPartyTool, project.getRemoteArtifactRepositories(), project.getRemoteProjectRepositories());
        SortedMap<String, MavenProject> projectDependencies = thirdPartyHelper.loadDependencies(this, loadedDependencies);
        LicenseMap licenseMap = thirdPartyHelper.createLicenseMap(projectDependencies);
        SortedSet<MavenProject> dependenciesWithNoLicense = thirdPartyHelper.getProjectsWithNoLicense(licenseMap);
        TreeSet<MavenProject> dependenciesWithPomLicense = new TreeSet<MavenProject>(MojoHelper.newMavenProjectComparator());
        dependenciesWithPomLicense.addAll(projectDependencies.values());
        if (CollectionUtils.isNotEmpty(dependenciesWithNoLicense)) {
            dependenciesWithPomLicense.removeAll(dependenciesWithNoLicense);
            if (this.useMissingFile) {
                thirdPartyHelper.createUnsafeMapping(licenseMap, this.missingFile, this.missingFileUrl, this.useRepositoryMissingFiles, dependenciesWithNoLicense, projectDependencies, loadedDependencies.getAllDependencies());
            }
        }
        thirdPartyHelper.mergeLicenses(this.licenseMerges, licenseMap);
        this.thirdPartyTool.overrideLicenses(licenseMap, projectDependencies, this.encoding, this.resolvedOverrideUrl);
        ArrayList<ThirdPartyDetails> details = new ArrayList<ThirdPartyDetails>();
        for (Map.Entry<MavenProject, String[]> entry : licenseMap.toDependencyMap().entrySet()) {
            MavenProject dependency = entry.getKey();
            String[] licenses = entry.getValue();
            DefaultThirdPartyDetails detail = new DefaultThirdPartyDetails(dependency);
            details.add(detail);
            if (dependenciesWithPomLicense.contains(dependency)) {
                detail.setPomLicenses(licenses);
                continue;
            }
            if (dependenciesWithNoLicense.contains(dependency)) continue;
            detail.setThirdPartyLicenses(licenses);
        }
        return details;
    }

    public String getArtifactFiltersUrl() {
        return this.artifactFiltersUrl;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

