/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.providers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.deploy.providers.ScanningAppProvider;
import org.eclipse.jetty.deploy.util.FileID;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class ContextProvider
extends ScanningAppProvider {
    private ConfigurationManager _configurationManager;
    private boolean _parentLoaderPriority = false;
    private String _defaultsDescriptor;

    public ContextProvider() {
        super(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!dir.exists()) {
                    return false;
                }
                String lowername = name.toLowerCase(Locale.ENGLISH);
                if (lowername.startsWith(".")) {
                    return false;
                }
                return lowername.endsWith(".xml") && !new File(dir, name).isDirectory();
            }
        });
    }

    public ConfigurationManager getConfigurationManager() {
        return this._configurationManager;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this._configurationManager = configurationManager;
    }

    @Override
    public ContextHandler createContextHandler(App app) throws Exception {
        Resource resource = Resource.newResource((String)app.getOriginId());
        File file = resource.getFile();
        if (resource.exists() && FileID.isXmlFile(file)) {
            XmlConfiguration xmlc = new XmlConfiguration(resource.getURL()){

                public void initializeDefaults(Object context) {
                    super.initializeDefaults(context);
                    if (context instanceof WebAppContext) {
                        WebAppContext webapp = (WebAppContext)context;
                        webapp.setParentLoaderPriority(ContextProvider.this._parentLoaderPriority);
                        if (ContextProvider.this._defaultsDescriptor != null) {
                            webapp.setDefaultsDescriptor(ContextProvider.this._defaultsDescriptor);
                        }
                    }
                }
            };
            xmlc.getIdMap().put("Server", this.getDeploymentManager().getServer());
            if (this.getConfigurationManager() != null) {
                xmlc.getProperties().putAll(this.getConfigurationManager().getProperties());
            }
            return (ContextHandler)xmlc.configure();
        }
        throw new IllegalStateException("App resouce does not exist " + resource);
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean parentLoaderPriority) {
        this._parentLoaderPriority = parentLoaderPriority;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }
}

