/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/KotlinLoggerMessageCollectorAdapter;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "kotlinLogger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "(Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;)V", "messageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "kotlin.jvm.PlatformType", "clear", "", "hasErrors", "", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "kotlin-build-tools-impl"})
public final class KotlinLoggerMessageCollectorAdapter
implements MessageCollector {
    @NotNull
    private final KotlinLogger kotlinLogger;
    private final MessageRenderer messageRenderer;

    public KotlinLoggerMessageCollectorAdapter(@NotNull KotlinLogger kotlinLogger) {
        Intrinsics.checkNotNullParameter((Object)kotlinLogger, (String)"kotlinLogger");
        this.kotlinLogger = kotlinLogger;
        this.messageRenderer = MessageRenderer.GRADLE_STYLE;
    }

    public void clear() {
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String renderedMessage = this.messageRenderer.render(severity, message, location);
        switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: 
            case 2: {
                Intrinsics.checkNotNull((Object)renderedMessage);
                KotlinLogger.error$default((KotlinLogger)this.kotlinLogger, (String)renderedMessage, null, (int)2, null);
                break;
            }
            case 3: 
            case 4: {
                Intrinsics.checkNotNull((Object)renderedMessage);
                this.kotlinLogger.warn(renderedMessage);
                break;
            }
            case 5: {
                Intrinsics.checkNotNull((Object)renderedMessage);
                this.kotlinLogger.info(renderedMessage);
                break;
            }
            case 6: 
            case 7: {
                Intrinsics.checkNotNull((Object)renderedMessage);
                this.kotlinLogger.debug(renderedMessage);
            }
        }
    }

    public boolean hasErrors() {
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilerMessageSeverity.values().length];
            try {
                nArray[CompilerMessageSeverity.EXCEPTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.STRONG_WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.INFO.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.OUTPUT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.LOGGING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

