/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DeserializedDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LanguageVersionSettingsProvider;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.util.DeclarationUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u001f\u001a\u00020\u0014*\u00020\u00192\u0006\u0010 \u001a\u00020\u0016H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/config/JvmTarget;Lcom/intellij/openapi/project/Project;)V", "ideService", "Lorg/jetbrains/kotlin/resolve/LanguageVersionSettingsProvider;", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkJvmDefaultsInHierarchy", "", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "checkPossibleClashMember", "inheritedFun", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkSpecializationInCompatibilityMode", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "actualImplementation", "performSpecializationCheck", "findPossibleClashMember", "isCompiledToJvmDefaultWithProperMode", "compilationDefaultMode", "frontend.java"})
public final class JvmDefaultChecker
implements DeclarationChecker {
    private final LanguageVersionSettingsProvider ideService;
    private final JvmTarget jvmTarget;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        void $this$filterTo$iv$iv;
        boolean performSpecializationCheck;
        Object list$iv$iv;
        boolean $i$f$any;
        Iterable $this$any$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Object destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JvmDefaultMode jvmDefaultMode = context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getJvmDefaultMode());
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_FQ_NAME());
        if (annotationDescriptor != null) {
            KtElement reportOn;
            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
            boolean bl = false;
            boolean bl2 = false;
            AnnotationDescriptor annotationDescriptor3 = annotationDescriptor2;
            boolean bl3 = false;
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor3);
            KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration2;
            if (!DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_NOT_IN_INTERFACE.on(reportOn));
            } else if (this.jvmTarget == JvmTarget.JVM_1_6) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_JVM6_TARGET.on(reportOn, "JvmDefault"));
            } else if (!jvmDefaultMode.isEnabled()) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtElement)((PsiElement)declaration2), "JvmDefault"));
            }
            return;
        }
        AnnotationDescriptor annotationDescriptor2 = descriptor2.getAnnotations().findAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME());
        if (annotationDescriptor2 != null) {
            KtElement reportOn;
            AnnotationDescriptor annotationDescriptor5 = annotationDescriptor2;
            boolean bl = false;
            boolean bl4 = false;
            AnnotationDescriptor annotationDescriptor6 = annotationDescriptor5;
            boolean bl5 = false;
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor6);
            KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration2;
            if (this.jvmTarget == JvmTarget.JVM_1_6) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_JVM6_TARGET.on(reportOn, "JvmDefaultWithoutCompatibility"));
            } else if (!jvmDefaultMode.isEnabled()) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtElement)((PsiElement)reportOn), "JvmDefaultWithoutCompatibility"));
            }
            return;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            boolean hasDeclaredJvmDefaults;
            block34: {
                boolean bl;
                Iterable $this$filterIsInstance$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope(), null, null, 3, null);
                boolean $i$f$filterIsInstance = false;
                Iterable annotationDescriptor6 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$any$iv = (List)destination$iv$iv;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl6 = false;
                        CallableMemberDescriptor.Kind kind = it.getKind();
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)kind), (String)"it.kind");
                        if (!(kind.isReal() && JvmAnnotationUtilKt.isCompiledToJvmDefault(it, jvmDefaultMode))) continue;
                        bl = true;
                        break block34;
                    }
                    bl = hasDeclaredJvmDefaults = false;
                }
            }
            if (!hasDeclaredJvmDefaults && !this.checkJvmDefaultsInHierarchy(descriptor2, jvmDefaultMode)) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_THROUGH_INHERITANCE.on((KtDeclaration)((PsiElement)declaration2)));
            }
        }
        if (!jvmDefaultMode.getForAllMethodsWithBody() && DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
            boolean bl;
            block35: {
                DeclarationDescriptor declarationDescriptor = descriptor2;
                if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                    declarationDescriptor = null;
                }
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
                if (callableMemberDescriptor == null) {
                    return;
                }
                CallableMemberDescriptor memberDescriptor = callableMemberDescriptor;
                if (descriptor2 instanceof PropertyAccessorDescriptor) {
                    return;
                }
                Collection<? extends CallableMemberDescriptor> collection = memberDescriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"memberDescriptor.overriddenDescriptors");
                $this$any$iv = collection;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl7 = false;
                        if (!it.getAnnotations().hasAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_FQ_NAME())) continue;
                        bl = true;
                        break block35;
                    }
                    bl = false;
                }
            }
            if (bl) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_REQUIRED_FOR_OVERRIDE.on((KtDeclaration)((PsiElement)declaration2)));
            } else if (jvmDefaultMode.isEnabled()) {
                void $this$flatMapTo$iv$iv22;
                Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"descriptor.overriddenDescriptors");
                Iterable $this$flatMap$iv = collection;
                boolean $i$f$flatMap = false;
                $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv22) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
                    boolean bl8 = false;
                    list$iv$iv = OverridingUtil.getOverriddenDeclarations(it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                $i$f$flatMap = false;
                boolean $this$flatMapTo$iv$iv22 = false;
                Iterable it = $this$flatMap$iv;
                boolean bl9 = false;
                for (CallableMemberDescriptor realDescriptor : OverridingUtil.filterOutOverridden(it)) {
                    if (!(realDescriptor instanceof JavaMethodDescriptor) || ((JavaMethodDescriptor)realDescriptor).getModality() == Modality.ABSTRACT) continue;
                    context2.getTrace().report(ErrorsJvm.NON_JVM_DEFAULT_OVERRIDES_JAVA_DEFAULT.on((KtDeclaration)((PsiElement)declaration2)));
                    return;
                }
            }
        }
        if (!jvmDefaultMode.isEnabled() || !(descriptor2 instanceof ClassDescriptor) || DescriptorUtils.isInterface(descriptor2) || DescriptorUtils.isAnnotationClass(descriptor2)) {
            return;
        }
        boolean bl = performSpecializationCheck = jvmDefaultMode.isCompatibility() && !JvmAnnotationUtilKt.hasJvmDefaultNoCompatibilityAnnotation(descriptor2) && (((ClassDescriptor)descriptor2).getModality() == Modality.OPEN || ((ClassDescriptor)descriptor2).getModality() == Modality.ABSTRACT) && !DescriptorUtilsKt.isEffectivelyPrivateApi((DeclarationDescriptorWithVisibility)descriptor2);
        if (DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2) == null && !performSpecializationCheck) {
            return;
        }
        Map<CallableMemberDescriptor, CallableMemberDescriptor> $this$filter$iv = DeclarationUtilKt.getNonPrivateTraitMembersForDelegation((ClassDescriptor)descriptor2, true);
        boolean $i$f$filter = false;
        Map<CallableMemberDescriptor, CallableMemberDescriptor> $this$flatMapTo$iv$iv22 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> bl7 = $this$filterTo$iv$iv;
        boolean realDescriptor = false;
        list$iv$iv = bl7.entrySet().iterator();
        while (list$iv$iv.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $dstr$_u24__u24$actualImplementation = element$iv$iv = list$iv$iv.next();
            boolean bl10 = false;
            Map.Entry entry = $dstr$_u24__u24$actualImplementation;
            boolean bl11 = false;
            CallableMemberDescriptor actualImplementation = (CallableMemberDescriptor)entry.getValue();
            if (!this.isCompiledToJvmDefaultWithProperMode(actualImplementation, jvmDefaultMode)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv;
        boolean bl12 = false;
        Iterator iterator3 = object.entrySet().iterator();
        while (iterator3.hasNext()) {
            void inheritedMember;
            Map.Entry element$iv;
            Map.Entry $dstr$inheritedMember$actualImplementation = element$iv = iterator3.next();
            boolean bl13 = false;
            Map.Entry element$iv$iv = $dstr$inheritedMember$actualImplementation;
            boolean $dstr$_u24__u24$actualImplementation = false;
            CallableMemberDescriptor bl10 = (CallableMemberDescriptor)element$iv$iv.getKey();
            element$iv$iv = $dstr$inheritedMember$actualImplementation;
            $dstr$_u24__u24$actualImplementation = false;
            CallableMemberDescriptor actualImplementation = (CallableMemberDescriptor)element$iv$iv.getValue();
            if (actualImplementation instanceof FunctionDescriptor && inheritedMember instanceof FunctionDescriptor) {
                if (!this.checkSpecializationInCompatibilityMode((FunctionDescriptor)inheritedMember, (FunctionDescriptor)actualImplementation, context2, declaration2, performSpecializationCheck)) continue;
                this.checkPossibleClashMember((CallableMemberDescriptor)inheritedMember, jvmDefaultMode, context2, declaration2);
                continue;
            }
            if (!(actualImplementation instanceof PropertyDescriptor) || !(inheritedMember instanceof PropertyDescriptor)) continue;
            PropertyGetterDescriptor getterImpl = ((PropertyDescriptor)actualImplementation).getGetter();
            PropertyGetterDescriptor getterInherited = ((PropertyDescriptor)inheritedMember).getGetter();
            if (getterImpl != null && getterInherited != null && jvmDefaultMode.isCompatibility() && !this.checkSpecializationInCompatibilityMode(getterInherited, getterImpl, context2, declaration2, performSpecializationCheck)) continue;
            if (((PropertyDescriptor)actualImplementation).isVar() && ((PropertyDescriptor)inheritedMember).isVar()) {
                PropertySetterDescriptor setterImpl = ((PropertyDescriptor)actualImplementation).getSetter();
                PropertySetterDescriptor setterInherited = ((PropertyDescriptor)inheritedMember).getSetter();
                if (setterImpl != null && setterInherited != null && !this.checkSpecializationInCompatibilityMode(setterInherited, setterImpl, context2, declaration2, performSpecializationCheck)) continue;
            }
            this.checkPossibleClashMember((CallableMemberDescriptor)inheritedMember, jvmDefaultMode, context2, declaration2);
        }
    }

    private final boolean checkSpecializationInCompatibilityMode(FunctionDescriptor inheritedFun, FunctionDescriptor actualImplementation, DeclarationCheckerContext context2, KtDeclaration declaration2, boolean performSpecializationCheck) {
        if (!performSpecializationCheck || actualImplementation instanceof JavaMethodDescriptor) {
            return true;
        }
        String inheritedSignature = MethodSignatureMappingKt.computeJvmDescriptor(inheritedFun, true, false);
        FunctionDescriptor functionDescriptor = actualImplementation.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"actualImplementation.original");
        FunctionDescriptor originalImplementation = functionDescriptor;
        String actualSignature = MethodSignatureMappingKt.computeJvmDescriptor(originalImplementation, true, false);
        if (Intrinsics.areEqual((Object)inheritedSignature, (Object)actualSignature) ^ true) {
            context2.getTrace().report(ErrorsJvm.EXPLICIT_OVERRIDE_REQUIRED_IN_COMPATIBILITY_MODE.on((KtDeclaration)((PsiElement)declaration2), DescriptorUtils.getDirectMember(inheritedFun), DescriptorUtils.getDirectMember(originalImplementation)));
            return false;
        }
        return true;
    }

    private final void checkPossibleClashMember(CallableMemberDescriptor inheritedFun, JvmDefaultMode jvmDefaultMode, DeclarationCheckerContext context2, KtDeclaration declaration2) {
        CallableMemberDescriptor clashMember = this.findPossibleClashMember(inheritedFun, jvmDefaultMode);
        if (clashMember != null) {
            context2.getTrace().report(ErrorsJvm.EXPLICIT_OVERRIDE_REQUIRED_IN_MIXED_MODE.on((KtDeclaration)((PsiElement)declaration2), DescriptorUtils.getDirectMember(inheritedFun), DescriptorUtils.getDirectMember(clashMember), jvmDefaultMode.getDescription()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final CallableMemberDescriptor findPossibleClashMember(CallableMemberDescriptor inheritedFun, JvmDefaultMode jvmDefaultMode) {
        block8: {
            block7: {
                v0 = inheritedFun.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"inheritedFun.containingDeclaration");
                classDescriptor = v0;
                if (!(classDescriptor instanceof ClassDescriptor) || DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)classDescriptor) == null) {
                    return null;
                }
                v1 = inheritedFun.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(v1, (String)"inheritedFun.overriddenDescriptors");
                $this$filter$iv = v1;
                $i$f$filter = false;
                var7_7 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (CallableMemberDescriptor)element$iv$iv;
                    $i$a$-filter-JvmDefaultChecker$findPossibleClashMember$classMembers$1 = false;
                    v2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                    if (!(DescriptorUtils.isInterface(v2.getContainingDeclaration()) == false && DescriptorUtils.isAnnotationClass(it.getContainingDeclaration()) == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                classMembers = (List)destination$iv$iv;
                $this$firstOrNull$iv = classMembers;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (CallableMemberDescriptor)element$iv;
                    $i$a$-firstOrNull-JvmDefaultChecker$findPossibleClashMember$implicitDefaultImplsDelegate$1 = false;
                    if (it instanceof JavaCallableMemberDescriptor) ** GOTO lbl-1000
                    v3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                    v4 = DeclarationUtilKt.getNonPrivateTraitMembersForDelegation(v3, true);
                    if (v4 == null) ** GOTO lbl-1000
                    if (!this.isCompiledToJvmDefaultWithProperMode(v4, jvmDefaultMode)) {
                        v5 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        v5 = false;
                    }
                    if (!v5) continue;
                    v6 = element$iv;
                    break block7;
                }
                v6 = null;
            }
            implicitDefaultImplsDelegate = v6;
            if (implicitDefaultImplsDelegate != null) {
                return implicitDefaultImplsDelegate;
            }
            $this$firstNotNullResult$iv = classMembers;
            $i$f$firstNotNullResult = false;
            for (T element$iv : $this$firstNotNullResult$iv) {
                it = (CallableMemberDescriptor)element$iv;
                $i$a$-firstNotNullResult-JvmDefaultChecker$findPossibleClashMember$1 = false;
                v7 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it");
                result$iv = this.findPossibleClashMember(v7, jvmDefaultMode);
                if (result$iv == null) continue;
                v8 = result$iv;
                break block8;
            }
            v8 = null;
        }
        return v8;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkJvmDefaultsInHierarchy(DeclarationDescriptor descriptor2, JvmDefaultMode jvmDefaultMode) {
        boolean bl;
        void $this$filterIsInstanceTo$iv$iv;
        if (jvmDefaultMode.isEnabled()) {
            return true;
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return true;
        }
        Iterable $this$filterIsInstance$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope(), null, null, 3, null);
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$all$iv = (List)destination$iv$iv;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        object = $this$all$iv.iterator();
        do {
            if (!object.hasNext()) return true;
            Object element$iv = object.next();
            CallableMemberDescriptor memberDescriptor = (CallableMemberDescriptor)element$iv;
            boolean bl2 = false;
            CallableMemberDescriptor.Kind kind = memberDescriptor.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)kind), (String)"memberDescriptor.kind");
            if (!kind.isReal()) {
                boolean bl3;
                Collection<? extends CallableMemberDescriptor> collection = memberDescriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"memberDescriptor.overriddenDescriptors");
                Set set = OverridingUtil.filterOutOverridden(CollectionsKt.toSet((Iterable)collection));
                Intrinsics.checkNotNullExpressionValue(set, (String)"OverridingUtil.filterOut\u2026iddenDescriptors.toSet())");
                Iterable $this$all$iv2 = set;
                boolean $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv2;
                        boolean bl4 = false;
                        CallableMemberDescriptor callableMemberDescriptor = it;
                        Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"it");
                        if (DescriptorUtils.isInterface(callableMemberDescriptor.getContainingDeclaration()) && this.isCompiledToJvmDefaultWithProperMode(it, jvmDefaultMode)) {
                            if (it.getModality() != Modality.ABSTRACT) return false;
                        }
                        boolean bl5 = true;
                        if (bl5) continue;
                        return false;
                    }
                    bl3 = true;
                }
                if (!bl3) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    private final boolean isCompiledToJvmDefaultWithProperMode(CallableMemberDescriptor $this$isCompiledToJvmDefaultWithProperMode, JvmDefaultMode compilationDefaultMode) {
        Object object;
        if ($this$isCompiledToJvmDefaultWithProperMode instanceof DeserializedDescriptor) {
            object = compilationDefaultMode;
        } else {
            object = this.ideService;
            if (object == null || (object = object.getModuleLanguageVersionSettings(DescriptorUtilsKt.getModule($this$isCompiledToJvmDefaultWithProperMode))) == null || (object = object.getFlag(JvmAnalysisFlags.getJvmDefaultMode())) == null) {
                object = compilationDefaultMode;
            }
        }
        JvmDefaultMode jvmDefault = object;
        return JvmAnnotationUtilKt.isCompiledToJvmDefault($this$isCompiledToJvmDefaultWithProperMode, jvmDefault);
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    public JvmDefaultChecker(@NotNull JvmTarget jvmTarget, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.jvmTarget = jvmTarget;
        this.ideService = LanguageVersionSettingsProvider.Companion.getInstance(project);
    }
}

