/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/PackagePartClassUtils;", "", "()V", "PART_CLASS_NAME_SUFFIX", "", "decapitalizeAsJavaClassName", "str", "getDefaultPartFqName", "Lorg/jetbrains/kotlin/name/FqName;", "facadeClassFqName", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileNameByFacadeName", "facadeClassName", "getFilePartShortName", "fileName", "getFilesWithCallables", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "", "getPackagePartFqName", "packageFqName", "getPathHashCode", "", "frontend.java"})
public final class PackagePartClassUtils {
    @NotNull
    public static final PackagePartClassUtils INSTANCE = new PackagePartClassUtils();
    @NotNull
    private static final String PART_CLASS_NAME_SUFFIX = "Kt";

    private PackagePartClassUtils() {
    }

    @JvmStatic
    public static final int getPathHashCode(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string2 = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
        boolean bl = false;
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return string3.hashCode();
    }

    @JvmStatic
    private static final String decapitalizeAsJavaClassName(String str) {
        String string2;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            String string3 = str;
            int n = 0;
            int n2 = 1;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string5;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            n2 = 0;
            String string6 = string3;
            boolean bl2 = false;
            String string7 = string6;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toLowerCase(locale)");
            string3 = str;
            int n3 = 1;
            n2 = 0;
            String string9 = string3;
            if (string9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
            string2 = Intrinsics.stringPlus((String)string8, (Object)string10);
        } else if (str.charAt(0) == '_') {
            String string11 = str;
            int n = 1;
            boolean bl = false;
            String string12 = string11;
            if (string12 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string13 = string12.substring(n);
            string2 = string13;
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string2 = str;
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final FqName getDefaultPartFqName(@NotNull FqName facadeClassFqName, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)facadeClassFqName, (String)"facadeClassFqName");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object object = facadeClassFqName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"facadeClassFqName.parent()");
        FqName fqName2 = object;
        object = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.name");
        return PackagePartClassUtils.getPackagePartFqName(fqName2, (String)object);
    }

    @JvmStatic
    @NotNull
    public static final FqName getPackagePartFqName(@NotNull FqName packageFqName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String partClassName = PackagePartClassUtils.getFilePartShortName(fileName);
        FqName fqName2 = packageFqName.child(Name.identifier(partClassName));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"packageFqName.child(Name.identifier(partClassName))");
        return fqName2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<KtFile> getFilesWithCallables(@NotNull Collection<? extends KtFile> files2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!it.hasTopLevelCallables()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final String getFilePartShortName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string2 = FileUtil.getNameWithoutExtension(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(fileName)");
        return Intrinsics.stringPlus((String)NameUtils.getPackagePartClassNamePrefix(string2), (Object)PART_CLASS_NAME_SUFFIX);
    }

    @JvmStatic
    @Nullable
    public static final String getFileNameByFacadeName(@NotNull String facadeClassName) {
        Intrinsics.checkNotNullParameter((Object)facadeClassName, (String)"facadeClassName");
        if (!StringsKt.endsWith$default((String)facadeClassName, (String)PART_CLASS_NAME_SUFFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        String string2 = facadeClassName;
        int n = 0;
        int n2 = facadeClassName.length() - PART_CLASS_NAME_SUFFIX.length();
        boolean bl = false;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String baseName = string3;
        if (Intrinsics.areEqual((Object)baseName, (Object)"_")) {
            return null;
        }
        return Intrinsics.stringPlus((String)PackagePartClassUtils.decapitalizeAsJavaClassName(baseName), (Object)".kt");
    }
}

