/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PropertiesWithInlineClassAsReceiver;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class PropertiesWithInlineClassAsReceiver
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration2 instanceof KtProperty)) {
            return;
        }
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        Object object2 = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"descriptor.containingDeclaration");
        if (InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)object2)) {
            if (Intrinsics.areEqual(context2.getTrace().get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2), (Object)true)) {
                context2.getTrace().report(Errors.PROPERTY_WITH_BACKING_FIELD_INSIDE_INLINE_CLASS.on((KtProperty)declaration2));
            }
            if ((object2 = ((KtProperty)declaration2).getDelegate()) != null) {
                object = object2;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                context2.getTrace().report(Errors.DELEGATED_PROPERTY_INSIDE_INLINE_CLASS.on((PsiElement)it));
            }
        }
        if (!((PropertyDescriptor)descriptor2).isVar()) {
            return;
        }
        object2 = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"descriptor.containingDeclaration");
        if (InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)object2) || Intrinsics.areEqual((object2 = ((PropertyDescriptor)descriptor2).getExtensionReceiverParameter()) == null ? null : ((object = object2.getType()) == null ? null : Boolean.valueOf(InlineClassesUtilsKt.isInlineClassType((KotlinType)object))), (Object)true)) {
            context2.getTrace().report(Errors.RESERVED_VAR_PROPERTY_OF_VALUE_CLASS.on(((KtProperty)declaration2).getValOrVarKeyword()));
        }
    }
}

