/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByVersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedTypealiasByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000b\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u000b\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0005*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000f\u00a8\u0006\u0013"}, d2={"computeLevelForDeprecatedSinceKotlin", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "createDeprecationDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lcom/intellij/psi/PsiElement;", "deprecation", "Lorg/jetbrains/kotlin/resolve/deprecation/Deprecation;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecatedByAnnotationReplaceWithExpression", "", "deprecatedByOverriddenMessage", "getSinceVersion", "name", "frontend"})
public final class DeprecationUtilKt {
    @Nullable
    public static final String deprecatedByOverriddenMessage(@NotNull Deprecation $this$deprecatedByOverriddenMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$deprecatedByOverriddenMessage, (String)"<this>");
        DeprecatedByOverridden deprecatedByOverridden = $this$deprecatedByOverriddenMessage instanceof DeprecatedByOverridden ? (DeprecatedByOverridden)$this$deprecatedByOverriddenMessage : null;
        return deprecatedByOverridden == null ? null : deprecatedByOverridden.additionalMessage$frontend();
    }

    @Nullable
    public static final String deprecatedByAnnotationReplaceWithExpression(@NotNull Deprecation $this$deprecatedByAnnotationReplaceWithExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$deprecatedByAnnotationReplaceWithExpression, (String)"<this>");
        DeprecatedByAnnotation deprecatedByAnnotation = $this$deprecatedByAnnotationReplaceWithExpression instanceof DeprecatedByAnnotation ? (DeprecatedByAnnotation)$this$deprecatedByAnnotationReplaceWithExpression : null;
        return deprecatedByAnnotation == null ? null : deprecatedByAnnotation.getReplaceWithValue$frontend();
    }

    @Nullable
    public static final ApiVersion getSinceVersion(@NotNull AnnotationDescriptor $this$getSinceVersion, @NotNull String name) {
        ApiVersion apiVersion;
        StringValue stringValue;
        StringValue stringValue2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getSinceVersion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StringValue stringValue3 = AnnotationUtilKt.argumentValue($this$getSinceVersion, name);
        if (stringValue3 == null) {
            object = null;
        } else {
            StringValue $this$safeAs$iv = stringValue3;
            boolean $i$f$safeAs = false;
            StringValue stringValue4 = $this$safeAs$iv;
            if (!(stringValue4 instanceof StringValue)) {
                stringValue4 = null;
            }
            object = stringValue2 = (stringValue = (StringValue)stringValue4) == null ? null : (String)stringValue.getValue();
        }
        if (stringValue2 == null) {
            apiVersion = null;
        } else {
            stringValue = stringValue2;
            boolean bl = false;
            boolean bl2 = false;
            CharSequence p0 = (CharSequence)((Object)stringValue);
            boolean bl3 = false;
            CharSequence charSequence = p0;
            boolean bl4 = false;
            StringValue stringValue5 = stringValue3 = !(charSequence.length() == 0) ? stringValue : null;
            if (stringValue3 == null) {
                apiVersion = null;
            } else {
                stringValue = stringValue3;
                ApiVersion.Companion companion = ApiVersion.Companion;
                bl2 = false;
                boolean bl5 = false;
                StringValue p02 = stringValue;
                boolean bl6 = false;
                apiVersion = companion.parse((String)((Object)p02));
            }
        }
        return apiVersion;
    }

    @Nullable
    public static final DeprecationLevelValue computeLevelForDeprecatedSinceKotlin(@NotNull AnnotationDescriptor annotation2, @NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        ApiVersion hiddenSince = DeprecationUtilKt.getSinceVersion(annotation2, "hiddenSince");
        if (hiddenSince != null && apiVersion.compareTo(hiddenSince) >= 0) {
            return DeprecationLevelValue.HIDDEN;
        }
        ApiVersion errorSince = DeprecationUtilKt.getSinceVersion(annotation2, "errorSince");
        if (errorSince != null && apiVersion.compareTo(errorSince) >= 0) {
            return DeprecationLevelValue.ERROR;
        }
        ApiVersion warningSince = DeprecationUtilKt.getSinceVersion(annotation2, "warningSince");
        if (warningSince != null && apiVersion.compareTo(warningSince) >= 0) {
            return DeprecationLevelValue.WARNING;
        }
        return null;
    }

    @NotNull
    public static final Diagnostic createDeprecationDiagnostic(@NotNull PsiElement element, @NotNull Deprecation deprecation, @NotNull LanguageVersionSettings languageVersionSettings) {
        Diagnostic diagnostic;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)deprecation, (String)"deprecation");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Object object = deprecation.getTarget().getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deprecation.target.original");
        DeclarationDescriptor targetOriginal = object;
        object = deprecation;
        if (object instanceof DeprecatedByVersionRequirement) {
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<LanguageVersion, String>> diagnosticFactory3;
            DeprecationLevelValue deprecationLevelValue = deprecation.getDeprecationLevel();
            int n = WhenMappings.$EnumSwitchMapping$0[deprecationLevelValue.ordinal()];
            switch (n) {
                case 1: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<LanguageVersion, String>> factory2 = diagnosticFactory3;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory2.on(element, targetOriginal, ((DeprecatedByVersionRequirement)deprecation).getVersionRequirement().getVersion(), (Pair<LanguageVersion, String>)TuplesKt.to((Object)languageVersionSettings.getLanguageVersion(), (Object)deprecation.getMessage()));
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"{\n            val factory = when (deprecation.deprecationLevel) {\n                WARNING -> Errors.VERSION_REQUIREMENT_DEPRECATION\n                ERROR, HIDDEN -> Errors.VERSION_REQUIREMENT_DEPRECATION_ERROR\n            }\n            factory.on(\n                element, targetOriginal, deprecation.versionRequirement.version,\n                languageVersionSettings.languageVersion to deprecation.message\n            )\n        }");
            diagnostic = parametrizedDiagnostic;
        } else if (object instanceof DeprecatedTypealiasByAnnotation) {
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> diagnosticFactory3;
            Object object2 = deprecation.getDeprecationLevel();
            int n = WhenMappings.$EnumSwitchMapping$0[object2.ordinal()];
            switch (n) {
                case 1: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> factory3 = diagnosticFactory3;
            object2 = ((DeprecatedTypealiasByAnnotation)deprecation).getNested().getMessage();
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory3.on(element, ((DeprecatedTypealiasByAnnotation)deprecation).getTypeAliasTarget().getOriginal(), ((DeprecatedTypealiasByAnnotation)deprecation).getNested().getTarget().getOriginal(), (String)(object2 == null ? "" : object2));
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"{\n            val factory = when (deprecation.deprecationLevel) {\n                WARNING -> Errors.TYPEALIAS_EXPANSION_DEPRECATION\n                ERROR, HIDDEN -> Errors.TYPEALIAS_EXPANSION_DEPRECATION_ERROR\n            }\n            factory.on(element, deprecation.typeAliasTarget.original, deprecation.nested.target.original, deprecation.nested.message ?: \"\")\n        }");
            diagnostic = parametrizedDiagnostic;
        } else {
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> diagnosticFactory2;
            Object object3 = deprecation.getDeprecationLevel();
            int n = WhenMappings.$EnumSwitchMapping$0[object3.ordinal()];
            switch (n) {
                case 1: {
                    diagnosticFactory2 = Errors.DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory2 = Errors.DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> factory4 = diagnosticFactory2;
            object3 = deprecation.getMessage();
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory4.on(element, targetOriginal, (String)(object3 == null ? "" : object3));
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"{\n            val factory = when (deprecation.deprecationLevel) {\n                WARNING -> Errors.DEPRECATION\n                ERROR, HIDDEN -> Errors.DEPRECATION_ERROR\n            }\n            factory.on(element, targetOriginal, deprecation.message ?: \"\")\n        }");
            diagnostic = parametrizedDiagnostic;
        }
        return diagnostic;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeprecationLevelValue.values().length];
            nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
            nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
            nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

