/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.utils;

import com.google.common.collect.LinkedListMultimap;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.AbstractDiagnosticDescriptor;
import org.jetbrains.kotlin.checkers.ActualDiagnosticDescriptor;
import org.jetbrains.kotlin.checkers.CheckerDebugInfoReporter;
import org.jetbrains.kotlin.checkers.DiagnosedRange;
import org.jetbrains.kotlin.checkers.DiagnosticDiffCallbacks;
import org.jetbrains.kotlin.checkers.TextDiagnosticDescriptor;
import org.jetbrains.kotlin.checkers.diagnostics.AbstractTestDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.ActualDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.PositionalTextDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.SyntaxErrorDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.TextDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory0;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory1;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.checkers.utils.DebugInfoUtil;
import org.jetbrains.kotlin.checkers.utils.DiagnosticsRenderingConfiguration;
import org.jetbrains.kotlin.checkers.utils.TypeOfCall;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.PlatformUtilKt;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014Jb\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00040\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0018\u0010$\u001a\n \r*\u0004\u0018\u00010\u00100\u00102\u0006\u0010%\u001a\u00020\u0010H\u0002J4\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190.H\u0002J\u0018\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0019H\u0002J6\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\f\u00100\u001a\b\u0012\u0004\u0012\u00020*022\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010'\u001a\u00020(J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020,022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J$\u00104\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000106\u0012\u0004\u0012\u00020\u0004052\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:Jj\u0010;\u001a\b\u0012\u0004\u0012\u00020\u0015022\u0006\u0010<\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010=\u001a\u00020\u001f2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u00010F2\u001a\u0010G\u001a\u0016\u0012\u0004\u0012\u00020H\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040I\u0018\u00010\u0017Jl\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00150?2\u0006\u00109\u001a\u00020:2\u0006\u0010<\u001a\u0002082\u0006\u0010=\u001a\u00020\u001f2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u00010F2\u001c\b\u0002\u0010G\u001a\u0016\u0012\u0004\u0012\u00020H\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040I\u0018\u00010.J\u0086\u0001\u0010J\u001a\b\u0012\u0004\u0012\u00020\u0015022\u0006\u00109\u001a\u00020:2\u0018\u0010K\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020:05022\u0006\u0010<\u001a\u0002082\u0006\u0010=\u001a\u00020\u001f2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u00010F2\u001c\b\u0002\u0010G\u001a\u0016\u0012\u0004\u0012\u00020H\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040I\u0018\u00010.J*\u0010M\u001a\b\u0012\u0004\u0012\u00020N022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0014H\u0002JJ\u0010O\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010P\u0012\f\u0012\n\u0012\u0004\u0012\u00020P\u0018\u00010Q052\u0006\u0010R\u001a\u0002082\u0006\u00109\u001a\u00020:2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010S\u001a\u0004\u0018\u00010T2\b\u0010E\u001a\u0004\u0018\u00010FJ\u0018\u0010U\u001a\u00020\u00042\u0006\u0010R\u001a\u00020V2\u0006\u00109\u001a\u00020:H\u0002J*\u0010W\u001a\b\u0012\u0004\u0012\u00020N0?2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0014H\u0002J\u0010\u0010X\u001a\u00020\u001f2\u0006\u0010Y\u001a\u00020\u0018H\u0002J\u0018\u0010Z\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J<\u0010[\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010\\\u001a\u00020N2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J:\u0010]\u001a\u00020\u00042\u0006\u0010^\u001a\u00020\u00042\f\u0010_\u001a\b\u0012\u0004\u0012\u00020*0?2\u001c\b\u0002\u0010`\u001a\u0016\u0012\u0004\u0012\u00020H\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040I\u0018\u00010.Jn\u0010a\u001a\u00020\"2\u0006\u0010b\u001a\u00020c2\u0006\u0010R\u001a\u00020V2\u0006\u0010<\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u00010F2\u001a\u0010G\u001a\u0016\u0012\u0004\u0012\u00020H\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040I\u0018\u00010\u00172\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00150?H\u0002J\u00ac\u0001\u0010e\u001a\u00020\"\"\u0004\b\u0000\u0010f\"\u0004\b\u0001\u0010g2(\u0010h\u001a$\u0012 \u0012\u001e\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u0002Hf\u0012\u0006\b\u0001\u0012\u0002Hg0i\u0012\u0004\u0012\u00020c05022\u0006\u0010<\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u00010F2\u001a\u0010G\u001a\u0016\u0012\u0004\u0012\u00020H\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040I\u0018\u00010\u00172\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00150?2\u0016\b\u0002\u0010j\u001a\u0010\u0012\u0004\u0012\u0002Hf\u0012\u0006\u0012\u0004\u0018\u00010V0\u001bH\u0002J#\u0010k\u001a\u0004\u0018\u0001Hf\"\u0004\b\u0000\u0010f2\f\u0010l\u001a\b\u0012\u0004\u0012\u0002Hf0mH\u0002\u00a2\u0006\u0002\u0010nJ\u0018\u0010o\u001a\u00020\"2\u0006\u0010p\u001a\u00020,2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \r*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006q"}, d2={"Lorg/jetbrains/kotlin/checkers/utils/CheckerTestUtil;", "", "()V", "IGNORE_DIAGNOSTIC_PARAMETER", "", "INDIVIDUAL_DIAGNOSTIC", "NEW_INFERENCE_PREFIX", "OLD_INFERENCE_PREFIX", "individualDiagnosticPattern", "Ljava/util/regex/Pattern;", "getIndividualDiagnosticPattern", "()Ljava/util/regex/Pattern;", "rangeStartOrEndPattern", "kotlin.jvm.PlatformType", "getRangeStartOrEndPattern", "addDiagnosticMarkersToText", "Ljava/lang/StringBuffer;", "psiFile", "Lcom/intellij/psi/PsiFile;", "diagnostics", "", "Lorg/jetbrains/kotlin/checkers/diagnostics/ActualDiagnostic;", "diagnosticToExpectedDiagnostic", "", "Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractTestDiagnostic;", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic;", "getFileText", "Lkotlin/Function1;", "uncheckedDiagnostics", "Lorg/jetbrains/kotlin/checkers/diagnostics/PositionalTextDiagnostic;", "withNewInferenceDirective", "", "renderDiagnosticMessages", "assertSameFile", "", "actual", "closeDiagnosticString", "result", "compareDiagnostics", "callbacks", "Lorg/jetbrains/kotlin/checkers/DiagnosticDiffCallbacks;", "currentExpected", "Lorg/jetbrains/kotlin/checkers/DiagnosedRange;", "currentActual", "Lorg/jetbrains/kotlin/checkers/ActualDiagnosticDescriptor;", "diagnosticToInput", "", "compareTextDiagnostic", "expected", "diagnosticsDiff", "", "getActualSortedDiagnosticDescriptors", "getCallDebugInfo", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "element", "Lcom/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDebugInfoDiagnostics", "root", "markDynamicCalls", "dynamicCallDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "configuration", "Lorg/jetbrains/kotlin/checkers/utils/DiagnosticsRenderingConfiguration;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "diagnosedRanges", "Lkotlin/ranges/IntRange;", "", "getDiagnosticsIncludingSyntaxErrors", "implementingModulesBindings", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getSortedDiagnosticDescriptors", "Lorg/jetbrains/kotlin/checkers/AbstractDiagnosticDescriptor;", "getTypeInfo", "Lorg/jetbrains/kotlin/types/KotlinType;", "", "expression", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getTypeOfCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "groupDiagnosticsByTextRange", "hasExplicitDefinitionOnlyOption", "diagnostic", "missingDiagnostics", "openDiagnosticsString", "currentDescriptor", "parseDiagnosedRanges", "text", "ranges", "rangesToDiagnosticNames", "renderDiagnostics", "factory", "Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory;", "debugAnnotations", "renderDiagnosticsByFactoryList", "T", "K", "factoryList", "Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;", "toExpression", "safeAdvance", "iterator", "", "(Ljava/util/Iterator;)Ljava/lang/Object;", "unexpectedDiagnostics", "descriptor", "frontend"})
public final class CheckerTestUtil {
    @NotNull
    public static final CheckerTestUtil INSTANCE = new CheckerTestUtil();
    @NotNull
    public static final String NEW_INFERENCE_PREFIX = "NI";
    @NotNull
    public static final String OLD_INFERENCE_PREFIX = "OI";
    private static final Pattern rangeStartOrEndPattern = Pattern.compile("(<!(\\w+;)?(\\w+:)?(\\w+)(\\{[\\w;]+})?(?:\\(((?:\".*?\")(?:,\\s*\".*?\")*)\\))?(,\\s*(\\w+;)?(\\w+:)?(\\w+)(\\{[\\w;]+})?(?:\\(((?:\".*?\")(?:,\\s*\".*?\")*)\\))?)*!>)|(<!>)");
    @NotNull
    private static final Pattern individualDiagnosticPattern;

    private CheckerTestUtil() {
    }

    public final Pattern getRangeStartOrEndPattern() {
        return rangeStartOrEndPattern;
    }

    @NotNull
    public final Pattern getIndividualDiagnosticPattern() {
        return individualDiagnosticPattern;
    }

    @NotNull
    public final List<ActualDiagnostic> getDiagnosticsIncludingSyntaxErrors(@NotNull BindingContext bindingContext, @NotNull List<? extends Pair<? extends TargetPlatform, ? extends BindingContext>> implementingModulesBindings, @NotNull PsiElement root2, boolean markDynamicCalls, @NotNull List<DeclarationDescriptor> dynamicCallDescriptors, @NotNull DiagnosticsRenderingConfiguration configuration, @Nullable DataFlowValueFactory dataFlowValueFactory, @Nullable ModuleDescriptorImpl moduleDescriptor, @Nullable Map<IntRange, Set<String>> diagnosedRanges) {
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter(implementingModulesBindings, (String)"implementingModulesBindings");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter(dynamicCallDescriptors, (String)"dynamicCallDescriptors");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        List<ActualDiagnostic> result2 = this.getDiagnosticsIncludingSyntaxErrors(bindingContext, root2, markDynamicCalls, dynamicCallDescriptors, configuration, dataFlowValueFactory, moduleDescriptor, diagnosedRanges);
        Iterable $this$sortedBy$iv = implementingModulesBindings;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List sortedBindings = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)PlatformUtilKt.getOldFashionedDescription((TargetPlatform)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string2 = PlatformUtilKt.getOldFashionedDescription((TargetPlatform)it.getFirst());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
            }
        });
        for (Pair pair : sortedBindings) {
            TargetPlatform platform = (TargetPlatform)pair.component1();
            BindingContext second = (BindingContext)pair.component2();
            boolean bl2 = !TargetPlatformKt.isCommon(platform);
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string2 = Intrinsics.stringPlus((String)"Implementing module must have a specific platform: ", (Object)platform);
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            result2.addAll((Collection<ActualDiagnostic>)this.getDiagnosticsIncludingSyntaxErrors(second, root2, markDynamicCalls, dynamicCallDescriptors, DiagnosticsRenderingConfiguration.copy$default(configuration, ((SimplePlatform)CollectionsKt.single((Iterable)platform)).getPlatformName(), false, null, false, 14, null), dataFlowValueFactory, moduleDescriptor, diagnosedRanges));
        }
        return result2;
    }

    public static /* synthetic */ List getDiagnosticsIncludingSyntaxErrors$default(CheckerTestUtil checkerTestUtil, BindingContext bindingContext, List list2, PsiElement psiElement, boolean bl, List list3, DiagnosticsRenderingConfiguration diagnosticsRenderingConfiguration, DataFlowValueFactory dataFlowValueFactory, ModuleDescriptorImpl moduleDescriptorImpl, Map map, int n, Object object) {
        if ((n & 0x100) != 0) {
            map = null;
        }
        return checkerTestUtil.getDiagnosticsIncludingSyntaxErrors(bindingContext, list2, psiElement, bl, list3, diagnosticsRenderingConfiguration, dataFlowValueFactory, moduleDescriptorImpl, map);
    }

    @NotNull
    public final List<ActualDiagnostic> getDiagnosticsIncludingSyntaxErrors(@NotNull BindingContext bindingContext, @NotNull PsiElement root2, boolean markDynamicCalls, @NotNull List<DeclarationDescriptor> dynamicCallDescriptors, @NotNull DiagnosticsRenderingConfiguration configuration, @Nullable DataFlowValueFactory dataFlowValueFactory, @Nullable ModuleDescriptorImpl moduleDescriptor, @Nullable Map<IntRange, Set<String>> diagnosedRanges) {
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter(dynamicCallDescriptors, (String)"dynamicCallDescriptors");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        boolean bl = false;
        List diagnostics2 = new ArrayList();
        Diagnostics diagnostics3 = bindingContext.getDiagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)diagnostics3, (String)"bindingContext.diagnostics");
        Iterable $this$forEach$iv = diagnostics3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Diagnostic diagnostic = (Diagnostic)element$iv;
            boolean bl2 = false;
            if (!PsiTreeUtil.isAncestor(root2, diagnostic.getPsiElement(), false)) continue;
            diagnostics2.add(new ActualDiagnostic(diagnostic, configuration.getPlatform(), configuration.getWithNewInference()));
        }
        for (PsiErrorElement errorElement : AnalyzingUtils.getSyntaxErrorRanges(root2)) {
            diagnostics2.add(new ActualDiagnostic(new SyntaxErrorDiagnostic(errorElement), configuration.getPlatform(), configuration.getWithNewInference()));
        }
        if (!configuration.getSkipDebugInfoDiagnostics()) {
            diagnostics2.addAll((Collection)this.getDebugInfoDiagnostics(root2, bindingContext, markDynamicCalls, dynamicCallDescriptors, configuration, dataFlowValueFactory, moduleDescriptor, diagnosedRanges));
        }
        return diagnostics2;
    }

    public static /* synthetic */ List getDiagnosticsIncludingSyntaxErrors$default(CheckerTestUtil checkerTestUtil, BindingContext bindingContext, PsiElement psiElement, boolean bl, List list2, DiagnosticsRenderingConfiguration diagnosticsRenderingConfiguration, DataFlowValueFactory dataFlowValueFactory, ModuleDescriptorImpl moduleDescriptorImpl, Map map, int n, Object object) {
        if ((n & 0x80) != 0) {
            map = null;
        }
        return checkerTestUtil.getDiagnosticsIncludingSyntaxErrors(bindingContext, psiElement, bl, list2, diagnosticsRenderingConfiguration, dataFlowValueFactory, moduleDescriptorImpl, map);
    }

    @NotNull
    public final List<ActualDiagnostic> getDebugInfoDiagnostics(@NotNull PsiElement root2, @NotNull BindingContext bindingContext, boolean markDynamicCalls, @NotNull List<DeclarationDescriptor> dynamicCallDescriptors, @NotNull DiagnosticsRenderingConfiguration configuration, @Nullable DataFlowValueFactory dataFlowValueFactory, @Nullable ModuleDescriptorImpl moduleDescriptor, @Nullable Map<IntRange, ? extends Set<String>> diagnosedRanges) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter(dynamicCallDescriptors, (String)"dynamicCallDescriptors");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        boolean bl = false;
        List debugAnnotations = new ArrayList();
        DebugInfoUtil.INSTANCE.markDebugAnnotations(root2, bindingContext, new CheckerDebugInfoReporter(dynamicCallDescriptors, markDynamicCalls, debugAnnotations, configuration.getWithNewInference(), configuration.getPlatform()));
        Object[] objectArray = new Pair[]{TuplesKt.to(BindingContext.EXPRESSION_TYPE_INFO, (Object)DebugInfoDiagnosticFactory1.Companion.getEXPRESSION_TYPE()), TuplesKt.to(BindingContext.SMARTCAST, (Object)DebugInfoDiagnosticFactory0.Companion.getSMARTCAST()), TuplesKt.to(BindingContext.IMPLICIT_RECEIVER_SMARTCAST, (Object)DebugInfoDiagnosticFactory0.Companion.getIMPLICIT_RECEIVER_SMARTCAST()), TuplesKt.to(BindingContext.SMARTCAST_NULL, (Object)DebugInfoDiagnosticFactory0.Companion.getCONSTANT()), TuplesKt.to(BindingContext.LEAKING_THIS, (Object)DebugInfoDiagnosticFactory0.Companion.getLEAKING_THIS()), TuplesKt.to(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN, (Object)DebugInfoDiagnosticFactory0.Companion.getIMPLICIT_EXHAUSTIVE())};
        List factoryListForDiagnosticsOnExpression = CollectionsKt.listOf((Object[])objectArray);
        List factoryListForDiagnosticsOnCall = CollectionsKt.listOf((Object)TuplesKt.to(BindingContext.RESOLVED_CALL, (Object)DebugInfoDiagnosticFactory1.Companion.getCALL()));
        CheckerTestUtil.renderDiagnosticsByFactoryList$default(this, factoryListForDiagnosticsOnExpression, root2, bindingContext, configuration, dataFlowValueFactory, moduleDescriptor, diagnosedRanges, debugAnnotations, null, 256, null);
        this.renderDiagnosticsByFactoryList(factoryListForDiagnosticsOnCall, root2, bindingContext, configuration, dataFlowValueFactory, moduleDescriptor, diagnosedRanges, debugAnnotations, getDebugInfoDiagnostics.1.INSTANCE);
        return debugAnnotations;
    }

    private final <T, K> void renderDiagnosticsByFactoryList(List<? extends Pair<? extends WritableSlice<? extends T, ? extends K>, ? extends DebugInfoDiagnosticFactory>> factoryList, PsiElement root2, BindingContext bindingContext, DiagnosticsRenderingConfiguration configuration, DataFlowValueFactory dataFlowValueFactory, ModuleDescriptorImpl moduleDescriptor, Map<IntRange, ? extends Set<String>> diagnosedRanges, List<ActualDiagnostic> debugAnnotations, Function1<? super T, ? extends KtExpression> toExpression) {
        for (Pair<WritableSlice<T, K>, DebugInfoDiagnosticFactory> pair : factoryList) {
            WritableSlice context2 = (WritableSlice)pair.component1();
            DebugInfoDiagnosticFactory factory2 = (DebugInfoDiagnosticFactory)pair.component2();
            Object object = bindingContext.getSliceContents(context2);
            Intrinsics.checkNotNullExpressionValue(object, (String)"bindingContext.getSliceContents(context)");
            object = (Map)object;
            boolean bl = false;
            Iterator iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object2 = object = iterator2.next();
                boolean bl2 = false;
                Object element = object2.getKey();
                if ((object2 = (KtExpression)toExpression.invoke(element)) == null) continue;
                this.renderDiagnostics(factory2, (KtExpression)object2, root2, bindingContext, configuration, dataFlowValueFactory, moduleDescriptor, diagnosedRanges, debugAnnotations);
            }
        }
    }

    static /* synthetic */ void renderDiagnosticsByFactoryList$default(CheckerTestUtil checkerTestUtil, List list2, PsiElement psiElement, BindingContext bindingContext, DiagnosticsRenderingConfiguration diagnosticsRenderingConfiguration, DataFlowValueFactory dataFlowValueFactory, ModuleDescriptorImpl moduleDescriptorImpl, Map map, List list3, Function1 function1, int n, Object object) {
        if ((n & 0x100) != 0) {
            function1 = renderDiagnosticsByFactoryList.1.INSTANCE;
        }
        checkerTestUtil.renderDiagnosticsByFactoryList(list2, psiElement, bindingContext, diagnosticsRenderingConfiguration, dataFlowValueFactory, moduleDescriptorImpl, map, list3, function1);
    }

    private final void renderDiagnostics(DebugInfoDiagnosticFactory factory2, KtExpression expression2, PsiElement root2, BindingContext bindingContext, DiagnosticsRenderingConfiguration configuration, DataFlowValueFactory dataFlowValueFactory, ModuleDescriptorImpl moduleDescriptor, Map<IntRange, ? extends Set<String>> diagnosedRanges, List<ActualDiagnostic> debugAnnotations) {
        boolean needRender;
        Set<String> set;
        Map<IntRange, ? extends Set<String>> map;
        if (!(factory2 instanceof DiagnosticFactory)) {
            return;
        }
        boolean bl = !factory2.getWithExplicitDefinitionOnly() || Intrinsics.areEqual((map = diagnosedRanges) == null ? null : ((set = map.get(new IntRange(PsiUtilsKt.getStartOffset(expression2), PsiUtilsKt.getEndOffset(expression2)))) == null ? null : Boolean.valueOf(set.contains(((DiagnosticFactory)((Object)factory2)).getName()))), (Object)true) ? true : (needRender = false);
        if (PsiTreeUtil.isAncestor(root2, expression2, false) && needRender) {
            Diagnostic diagnostic = factory2.createDiagnostic(expression2, bindingContext, dataFlowValueFactory, configuration.getLanguageVersionSettings(), moduleDescriptor);
            debugAnnotations.add(new ActualDiagnostic(diagnostic, configuration.getPlatform(), configuration.getWithNewInference()));
        }
    }

    @NotNull
    public final Map<AbstractTestDiagnostic, TextDiagnostic> diagnosticsDiff(@NotNull List<DiagnosedRange> expected, @NotNull Collection<ActualDiagnostic> actual, @NotNull DiagnosticDiffCallbacks callbacks) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)callbacks, (String)"callbacks");
        boolean bl = false;
        Map diagnosticToExpectedDiagnostic = new LinkedHashMap();
        this.assertSameFile(actual);
        Iterator<DiagnosedRange> expectedDiagnostics = expected.iterator();
        List<ActualDiagnosticDescriptor> sortedDiagnosticDescriptors = this.getActualSortedDiagnosticDescriptors(actual);
        Iterator<ActualDiagnosticDescriptor> actualDiagnostics = sortedDiagnosticDescriptors.iterator();
        DiagnosedRange currentExpected = this.safeAdvance(expectedDiagnostics);
        ActualDiagnosticDescriptor currentActual = this.safeAdvance(actualDiagnostics);
        while (currentExpected != null || currentActual != null) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            if (currentExpected == null) {
                boolean bl5 = currentActual != null;
                boolean bl6 = false;
                boolean bl7 = false;
                if (_Assertions.ENABLED && !bl5) {
                    boolean bl8 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                Intrinsics.checkNotNull((Object)currentActual);
                this.unexpectedDiagnostics(currentActual, callbacks);
                currentActual = this.safeAdvance(actualDiagnostics);
                continue;
            }
            if (currentActual == null) {
                this.missingDiagnostics(callbacks, currentExpected);
                currentExpected = this.safeAdvance(expectedDiagnostics);
                continue;
            }
            int expectedStart = currentExpected.getStart();
            int actualStart = currentActual.getStart();
            int expectedEnd = currentExpected.getEnd();
            int actualEnd = currentActual.getEnd();
            if (expectedStart < actualStart) {
                this.missingDiagnostics(callbacks, currentExpected);
                currentExpected = this.safeAdvance(expectedDiagnostics);
                continue;
            }
            if (expectedStart > actualStart) {
                this.unexpectedDiagnostics(currentActual, callbacks);
                currentActual = this.safeAdvance(actualDiagnostics);
                continue;
            }
            if (expectedEnd > actualEnd) {
                bl4 = expectedStart == actualStart;
                bl3 = false;
                bl2 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl9 = false;
                    String string3 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                this.missingDiagnostics(callbacks, currentExpected);
                currentExpected = this.safeAdvance(expectedDiagnostics);
                continue;
            }
            if (expectedEnd < actualEnd) {
                bl4 = expectedStart == actualStart;
                bl3 = false;
                bl2 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl10 = false;
                    String string4 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string4));
                }
                this.unexpectedDiagnostics(currentActual, callbacks);
                currentActual = this.safeAdvance(actualDiagnostics);
                continue;
            }
            this.compareDiagnostics(callbacks, currentExpected, currentActual, diagnosticToExpectedDiagnostic);
            currentExpected = this.safeAdvance(expectedDiagnostics);
            currentActual = this.safeAdvance(actualDiagnostics);
        }
        return diagnosticToExpectedDiagnostic;
    }

    private final void compareDiagnostics(DiagnosticDiffCallbacks callbacks, DiagnosedRange currentExpected, ActualDiagnosticDescriptor currentActual, Map<AbstractTestDiagnostic, TextDiagnostic> diagnosticToInput) {
        int expectedStart = currentExpected.getStart();
        int expectedEnd = currentExpected.getEnd();
        int actualStart = currentActual.getStart();
        int actualEnd = currentActual.getEnd();
        boolean bl = expectedStart == actualStart && expectedEnd == actualEnd;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Map<AbstractTestDiagnostic, TextDiagnostic> actualDiagnostics = currentActual.getTextDiagnosticsMap();
        List<TextDiagnostic> expectedDiagnostics = currentExpected.getDiagnostics();
        HashSet<String> diagnosticNames = new HashSet<String>();
        for (TextDiagnostic expectedDiagnostic : expectedDiagnostics) {
            Object v1;
            TextDiagnostic actualDiagnostic;
            Map.Entry entry;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block8: {
                $this$firstOrNull$iv = actualDiagnostics.entrySet();
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    entry = (Map.Entry)element$iv;
                    boolean bl5 = false;
                    actualDiagnostic = (TextDiagnostic)entry.getValue();
                    boolean bl6 = Intrinsics.areEqual((Object)expectedDiagnostic.getDescription(), (Object)actualDiagnostic.getDescription()) && expectedDiagnostic.getInferenceCompatibility().isCompatible(actualDiagnostic.getInferenceCompatibility()) && Intrinsics.areEqual(expectedDiagnostic.getParameters(), actualDiagnostic.getParameters());
                    if (!bl6) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            Map.Entry actualDiagnosticEntry = v1;
            if (actualDiagnosticEntry == null) {
                Object v3;
                block9: {
                    $this$firstOrNull$iv = actualDiagnostics.entrySet();
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        entry = (Map.Entry)element$iv;
                        boolean bl7 = false;
                        actualDiagnostic = (TextDiagnostic)entry.getValue();
                        boolean bl8 = Intrinsics.areEqual((Object)expectedDiagnostic.getDescription(), (Object)actualDiagnostic.getDescription()) && expectedDiagnostic.getInferenceCompatibility().isCompatible(actualDiagnostic.getInferenceCompatibility());
                        if (!bl8) continue;
                        v3 = element$iv;
                        break block9;
                    }
                    v3 = null;
                }
                actualDiagnosticEntry = v3;
            }
            if (actualDiagnosticEntry == null) {
                callbacks.missingDiagnostic(expectedDiagnostic, expectedStart, expectedEnd);
                continue;
            }
            AbstractTestDiagnostic actualDiagnostic2 = (AbstractTestDiagnostic)actualDiagnosticEntry.getKey();
            TextDiagnostic actualTextDiagnostic = (TextDiagnostic)actualDiagnosticEntry.getValue();
            if (!this.compareTextDiagnostic(expectedDiagnostic, actualTextDiagnostic)) {
                callbacks.wrongParametersDiagnostic(expectedDiagnostic, actualTextDiagnostic, expectedStart, expectedEnd);
            }
            actualDiagnostics.remove(actualDiagnostic2);
            diagnosticNames.add(actualDiagnostic2.getName());
            actualDiagnostic2.enhanceInferenceCompatibility(expectedDiagnostic.getInferenceCompatibility());
            Map<AbstractTestDiagnostic, TextDiagnostic> map = diagnosticToInput;
            boolean bl9 = false;
            map.put(actualDiagnostic2, expectedDiagnostic);
        }
        for (AbstractTestDiagnostic unexpectedDiagnostic : actualDiagnostics.keySet()) {
            TextDiagnostic textDiagnostic = actualDiagnostics.get(unexpectedDiagnostic);
            if (this.hasExplicitDefinitionOnlyOption(unexpectedDiagnostic) && !diagnosticNames.contains(unexpectedDiagnostic.getName())) continue;
            Intrinsics.checkNotNull((Object)textDiagnostic);
            callbacks.unexpectedDiagnostic(textDiagnostic, actualStart, actualEnd);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean compareTextDiagnostic(TextDiagnostic expected, TextDiagnostic actual) {
        if (!Intrinsics.areEqual((Object)expected.getDescription(), (Object)actual.getDescription())) {
            return false;
        }
        if (expected.getParameters() == null) {
            return true;
        }
        if (actual.getParameters() == null || expected.getParameters().size() != actual.getParameters().size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = expected.getParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void expectedParameter;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int index2 = n;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)expectedParameter, (Object)"IGNORE") || Intrinsics.areEqual((Object)expectedParameter, (Object)actual.getParameters().get(index2))) continue;
            return false;
        }
        return true;
    }

    private final void assertSameFile(Collection<ActualDiagnostic> actual) {
        if (actual.isEmpty()) {
            return;
        }
        PsiFile file2 = ((ActualDiagnostic)CollectionsKt.first((Iterable)actual)).getFile();
        for (ActualDiagnostic actualDiagnostic : actual) {
            boolean bl = Intrinsics.areEqual((Object)actualDiagnostic.getFile(), (Object)file2);
            boolean bl2 = false;
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl3 = false;
            String string2 = "All diagnostics should come from the same file: " + actualDiagnostic.getFile() + ", " + file2;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }

    private final void unexpectedDiagnostics(ActualDiagnosticDescriptor descriptor2, DiagnosticDiffCallbacks callbacks) {
        for (AbstractTestDiagnostic diagnostic : descriptor2.getDiagnostics()) {
            if (this.hasExplicitDefinitionOnlyOption(diagnostic)) continue;
            callbacks.unexpectedDiagnostic(TextDiagnostic.Companion.asTextDiagnostic(diagnostic), descriptor2.getStart(), descriptor2.getEnd());
        }
    }

    private final void missingDiagnostics(DiagnosticDiffCallbacks callbacks, DiagnosedRange currentExpected) {
        for (TextDiagnostic diagnostic : currentExpected.getDiagnostics()) {
            callbacks.missingDiagnostic(diagnostic, currentExpected.getStart(), currentExpected.getEnd());
        }
    }

    private final <T> T safeAdvance(Iterator<? extends T> iterator2) {
        return iterator2.hasNext() ? (T)iterator2.next() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String parseDiagnosedRanges(@NotNull String text2, @NotNull List<DiagnosedRange> ranges2, @Nullable Map<IntRange, Set<String>> rangesToDiagnosticNames) {
        int effectiveOffset;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
        Matcher matcher2 = rangeStartOrEndPattern.matcher(text2);
        Stack<DiagnosedRange> opened = new Stack<DiagnosedRange>();
        int offsetCompensation = 0;
        while (matcher2.find()) {
            effectiveOffset = matcher2.start() - offsetCompensation;
            String matchedText = matcher2.group();
            if (Intrinsics.areEqual((Object)matchedText, (Object)"<!>")) {
                ((DiagnosedRange)opened.pop()).setEnd(effectiveOffset);
            } else {
                Matcher diagnosticTypeMatcher = individualDiagnosticPattern.matcher(matchedText);
                DiagnosedRange range = new DiagnosedRange(effectiveOffset);
                while (diagnosticTypeMatcher.find()) {
                    String string2 = diagnosticTypeMatcher.group();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"diagnosticTypeMatcher.group()");
                    range.addDiagnostic(string2);
                }
                opened.push(range);
                ranges2.add(range);
            }
            offsetCompensation += matchedText.length();
        }
        effectiveOffset = opened.isEmpty();
        boolean matchedText = false;
        if (_Assertions.ENABLED && effectiveOffset == 0) {
            boolean bl = false;
            String string3 = "Stack is not empty";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        matcher2.reset();
        if (rangesToDiagnosticNames != null) {
            Iterable $this$forEach$iv = ranges2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                DiagnosedRange it = (DiagnosedRange)element$iv;
                boolean bl = false;
                IntRange range = new IntRange(it.getStart(), it.getEnd());
                boolean bl2 = false;
                rangesToDiagnosticNames.putIfAbsent(range, new LinkedHashSet());
                Collection<String> collection = rangesToDiagnosticNames.get(range);
                Intrinsics.checkNotNull(collection);
                collection = collection;
                Iterable $this$map$iv = it.getDiagnostics();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    TextDiagnostic textDiagnostic = (TextDiagnostic)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    String string4 = it2.getName();
                    collection2.add(string4);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                boolean bl4 = false;
                CollectionsKt.addAll(collection, (Iterable)iterable2);
            }
        }
        String string5 = matcher2.replaceAll("");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"matcher.replaceAll(\"\")");
        return string5;
    }

    public static /* synthetic */ String parseDiagnosedRanges$default(CheckerTestUtil checkerTestUtil, String string2, List list2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = null;
        }
        return checkerTestUtil.parseDiagnosedRanges(string2, list2, map);
    }

    private final boolean hasExplicitDefinitionOnlyOption(AbstractTestDiagnostic diagnostic) {
        if (!(diagnostic instanceof ActualDiagnostic)) {
            return false;
        }
        DiagnosticFactory<?> factory2 = ((ActualDiagnostic)diagnostic).getDiagnostic().getFactory();
        return factory2 instanceof DebugInfoDiagnosticFactory && ((DebugInfoDiagnosticFactory)((Object)factory2)).getWithExplicitDefinitionOnly();
    }

    @NotNull
    public final StringBuffer addDiagnosticMarkersToText(@NotNull PsiFile psiFile, @NotNull Collection<ActualDiagnostic> diagnostics2) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
        return this.addDiagnosticMarkersToText(psiFile, diagnostics2, MapsKt.emptyMap(), (Function1<? super PsiFile, String>)((Function1)addDiagnosticMarkersToText.1.INSTANCE), CollectionsKt.emptyList(), false, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StringBuffer addDiagnosticMarkersToText(@NotNull PsiFile psiFile, @NotNull Collection<ActualDiagnostic> diagnostics2, @NotNull Map<AbstractTestDiagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic, @NotNull Function1<? super PsiFile, String> getFileText, @NotNull Collection<PositionalTextDiagnostic> uncheckedDiagnostics, boolean withNewInferenceDirective, boolean renderDiagnosticMessages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
        Intrinsics.checkNotNullParameter(diagnosticToExpectedDiagnostic, (String)"diagnosticToExpectedDiagnostic");
        Intrinsics.checkNotNullParameter(getFileText, (String)"getFileText");
        Intrinsics.checkNotNullParameter(uncheckedDiagnostics, (String)"uncheckedDiagnostics");
        String text2 = (String)getFileText.invoke((Object)psiFile);
        StringBuffer result2 = new StringBuffer();
        Iterable $this$filter$iv = diagnostics2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        int $i$f$filterTo = 0;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ActualDiagnostic actualDiagnostic = (ActualDiagnostic)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)psiFile, (Object)actualDiagnostic.getFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List diagnosticsFiltered = (List)destination$iv$iv;
        if (diagnosticsFiltered.isEmpty() && uncheckedDiagnostics.isEmpty()) {
            result2.append(text2);
            return result2;
        }
        List<AbstractDiagnosticDescriptor> diagnosticDescriptors = this.getSortedDiagnosticDescriptors(diagnosticsFiltered, uncheckedDiagnostics);
        if (diagnosticDescriptors.isEmpty()) {
            return result2;
        }
        Stack<AbstractDiagnosticDescriptor> opened = new Stack<AbstractDiagnosticDescriptor>();
        ListIterator<AbstractDiagnosticDescriptor> iterator2 = diagnosticDescriptors.listIterator();
        AbstractDiagnosticDescriptor currentDescriptor = iterator2.next();
        $i$f$filterTo = 0;
        int n = text2.length();
        if ($i$f$filterTo < n) {
            do {
                int i = $i$f$filterTo++;
                char c = text2.charAt(i);
                while (!opened.isEmpty() && i == ((AbstractDiagnosticDescriptor)opened.peek()).getEnd()) {
                    this.closeDiagnosticString(result2);
                    opened.pop();
                }
                while (currentDescriptor != null && i == currentDescriptor.getStart()) {
                    boolean isSkip = this.openDiagnosticsString(result2, currentDescriptor, diagnosticToExpectedDiagnostic, withNewInferenceDirective, renderDiagnosticMessages);
                    if (currentDescriptor.getEnd() == i && !isSkip) {
                        this.closeDiagnosticString(result2);
                    } else if (!isSkip) {
                        opened.push(currentDescriptor);
                    }
                    currentDescriptor = iterator2.hasNext() ? iterator2.next() : null;
                }
                result2.append(c);
            } while ($i$f$filterTo < n);
        }
        if (currentDescriptor != null) {
            $i$f$filterTo = currentDescriptor.getStart() == text2.length() ? 1 : 0;
            n = 0;
            boolean i = false;
            if (_Assertions.ENABLED && $i$f$filterTo == 0) {
                boolean bl = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            $i$f$filterTo = currentDescriptor.getEnd() == text2.length() ? 1 : 0;
            n = 0;
            i = false;
            if (_Assertions.ENABLED && $i$f$filterTo == 0) {
                boolean bl = false;
                String string3 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string3));
            }
            boolean isSkip = this.openDiagnosticsString(result2, currentDescriptor, diagnosticToExpectedDiagnostic, withNewInferenceDirective, renderDiagnosticMessages);
            if (!isSkip) {
                opened.push(currentDescriptor);
            }
        }
        while (!opened.isEmpty() && text2.length() == ((AbstractDiagnosticDescriptor)opened.peek()).getEnd()) {
            this.closeDiagnosticString(result2);
            opened.pop();
        }
        boolean bl = opened.isEmpty();
        n = 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string4 = Intrinsics.stringPlus((String)"Stack is not empty: ", opened);
            throw (Throwable)((Object)new AssertionError((Object)string4));
        }
        return result2;
    }

    private final boolean openDiagnosticsString(StringBuffer result2, AbstractDiagnosticDescriptor currentDescriptor, Map<AbstractTestDiagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic, boolean withNewInferenceDirective, boolean renderDiagnosticMessages) {
        boolean isSkip = true;
        boolean bl = false;
        List diagnosticsAsText = new ArrayList();
        AbstractDiagnosticDescriptor abstractDiagnosticDescriptor = currentDescriptor;
        if (abstractDiagnosticDescriptor instanceof TextDiagnosticDescriptor) {
            diagnosticsAsText.add(TextDiagnostic.asString$default(((TextDiagnosticDescriptor)currentDescriptor).getTextDiagnostic(), false, false, 3, null));
        } else if (abstractDiagnosticDescriptor instanceof ActualDiagnosticDescriptor) {
            List<AbstractTestDiagnostic> diagnostics2 = ((ActualDiagnosticDescriptor)currentDescriptor).getDiagnostics();
            for (AbstractTestDiagnostic diagnostic : diagnostics2) {
                TextDiagnostic textDiagnostic;
                TextDiagnostic expectedDiagnostic = diagnosticToExpectedDiagnostic.get(diagnostic);
                TextDiagnostic actualTextDiagnostic = TextDiagnostic.Companion.asTextDiagnostic(diagnostic);
                if (expectedDiagnostic == null && this.hasExplicitDefinitionOnlyOption(diagnostic)) continue;
                boolean shouldRenderParameters = renderDiagnosticMessages || ((textDiagnostic = expectedDiagnostic) == null ? null : textDiagnostic.getParameters()) != null;
                diagnosticsAsText.add(actualTextDiagnostic.asString(withNewInferenceDirective, shouldRenderParameters));
            }
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown diagnostic descriptor: ", (Object)currentDescriptor));
        }
        if (diagnosticsAsText.size() != 0) {
            CollectionsKt.sort((List)diagnosticsAsText);
            result2.append("<!" + CollectionsKt.joinToString$default((Iterable)diagnosticsAsText, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "!>");
            isSkip = false;
        }
        return isSkip;
    }

    private final StringBuffer closeDiagnosticString(StringBuffer result2) {
        return result2.append("<!>");
    }

    private final List<ActualDiagnosticDescriptor> getActualSortedDiagnosticDescriptors(Collection<ActualDiagnostic> diagnostics2) {
        return CollectionsKt.filterIsInstance((Iterable)this.getSortedDiagnosticDescriptors(diagnostics2, CollectionsKt.emptyList()), ActualDiagnosticDescriptor.class);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AbstractDiagnosticDescriptor> getSortedDiagnosticDescriptors(Collection<ActualDiagnostic> diagnostics2, Collection<PositionalTextDiagnostic> uncheckedDiagnostics) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = diagnostics2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ActualDiagnostic actualDiagnostic = (ActualDiagnostic)element$iv$iv;
            boolean bl = false;
            if (!actualDiagnostic.getDiagnostic().isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validDiagnostics = (List)destination$iv$iv;
        List<AbstractDiagnosticDescriptor> diagnosticDescriptors = this.groupDiagnosticsByTextRange(validDiagnostics, uncheckedDiagnostics);
        CollectionsKt.sortWith(diagnosticDescriptors, CheckerTestUtil::getSortedDiagnosticDescriptors$lambda-13);
        return diagnosticDescriptors;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AbstractDiagnosticDescriptor> groupDiagnosticsByTextRange(Collection<ActualDiagnostic> diagnostics2, Collection<PositionalTextDiagnostic> uncheckedDiagnostics) {
        void $this$mapTo$iv$iv;
        Object diagnostic;
        LinkedListMultimap<TextRange, Object> diagnosticsGroupedByRanges = LinkedListMultimap.create();
        for (ActualDiagnostic actualDiagnostic : diagnostics2) {
            diagnostic = actualDiagnostic.getDiagnostic();
            for (TextRange textRange : diagnostic.getTextRanges()) {
                diagnosticsGroupedByRanges.put(textRange, actualDiagnostic);
            }
        }
        for (PositionalTextDiagnostic positionalTextDiagnostic : uncheckedDiagnostics) {
            diagnostic = positionalTextDiagnostic.component1();
            int start = positionalTextDiagnostic.component2();
            int end = positionalTextDiagnostic.component3();
            TextRange range = new TextRange(start, end);
            diagnosticsGroupedByRanges.put(range, diagnostic);
        }
        Set set = diagnosticsGroupedByRanges.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"diagnosticsGroupedByRanges.keySet()");
        Iterable $this$map$iv = set;
        boolean bl = false;
        diagnostic = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            boolean $i$f$sortBy;
            Collection $this$sortBy$iv;
            boolean needSortingByName;
            Collection abstractDiagnostics;
            void range;
            Collection collection;
            block11: {
                boolean bl2;
                TextRange textRange = (TextRange)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl22 = false;
                abstractDiagnostics = diagnosticsGroupedByRanges.get(range);
                Intrinsics.checkNotNullExpressionValue((Object)abstractDiagnostics, (String)"abstractDiagnostics");
                Iterable $this$any$iv = abstractDiagnostics;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AbstractTestDiagnostic diagnostic2 = (AbstractTestDiagnostic)element$iv;
                        boolean bl3 = false;
                        if (!(diagnostic2.getInferenceCompatibility() != TextDiagnostic.InferenceCompatibility.ALL)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = needSortingByName = false;
                }
            }
            if (needSortingByName) {
                $this$sortBy$iv = abstractDiagnostics;
                $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    boolean bl3 = false;
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            AbstractTestDiagnostic it = (AbstractTestDiagnostic)a;
                            boolean bl2 = false;
                            Comparable comparable = (Comparable)((Object)it.getName());
                            it = (AbstractTestDiagnostic)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            String string2 = it.getName();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                        }
                    });
                }
            } else {
                $this$sortBy$iv = abstractDiagnostics;
                $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    boolean bl4 = false;
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            AbstractTestDiagnostic it = (AbstractTestDiagnostic)a;
                            boolean bl2 = false;
                            Comparable comparable = it;
                            it = (AbstractTestDiagnostic)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            AbstractTestDiagnostic abstractTestDiagnostic = it;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)abstractTestDiagnostic);
                        }
                    });
                }
            }
            ActualDiagnosticDescriptor actualDiagnosticDescriptor = new ActualDiagnosticDescriptor(range.getStartOffset(), range.getEndOffset(), (List<? extends AbstractTestDiagnostic>)abstractDiagnostics);
            collection.add(actualDiagnosticDescriptor);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    @NotNull
    public final Pair<KotlinType, Set<KotlinType>> getTypeInfo(@NotNull PsiElement expression2, @NotNull BindingContext bindingContext, @Nullable DataFlowValueFactory dataFlowValueFactory, @Nullable LanguageVersionSettings languageVersionSettings, @Nullable ModuleDescriptorImpl moduleDescriptor) {
        KotlinType expressionType;
        KotlinTypeInfo kotlinTypeInfo;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        if (expression2 instanceof KtCallableDeclaration) {
            CallableDescriptor descriptor2;
            object = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, expression2);
            CallableDescriptor callableDescriptor = descriptor2 = object instanceof CallableDescriptor ? (CallableDescriptor)object : null;
            if (descriptor2 != null) {
                return new Pair((Object)descriptor2.getReturnType(), null);
            }
        }
        object = (kotlinTypeInfo = (KotlinTypeInfo)bindingContext.get(BindingContext.EXPRESSION_TYPE_INFO, (KtExpression)expression2)) == null ? TypeInfoFactoryKt.noTypeInfo(DataFlowInfo.Companion.getEMPTY()) : kotlinTypeInfo;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bindingContext[BindingContext.EXPRESSION_TYPE_INFO, expression as KtExpression] ?: noTypeInfo(DataFlowInfo.EMPTY)");
        Object expressionTypeInfo = object;
        KotlinType kotlinType = expressionType = CallUtilKt.getType((KtExpression)expression2, bindingContext);
        if (kotlinType == null) {
            return new Pair(null, null);
        }
        KotlinType result2 = kotlinType;
        if (dataFlowValueFactory == null || moduleDescriptor == null) {
            return new Pair((Object)expressionType, null);
        }
        DataFlowValue dataFlowValue2 = dataFlowValueFactory.createDataFlowValue((KtExpression)expression2, expressionType, bindingContext, moduleDescriptor);
        DataFlowInfo dataFlowInfo = ((KotlinTypeInfo)expressionTypeInfo).getDataFlowInfo();
        Intrinsics.checkNotNull((Object)languageVersionSettings);
        Set<KotlinType> types2 = dataFlowInfo.getStableTypes(dataFlowValue2, languageVersionSettings);
        Collection collection = types2;
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            return new Pair((Object)result2, types2);
        }
        ExplicitSmartCasts smartCast = (ExplicitSmartCasts)bindingContext.get(BindingContext.SMARTCAST, expression2);
        if (smartCast != null && expression2 instanceof KtReferenceExpression) {
            KotlinType declaredType;
            Object v = bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
            CallableDescriptor callableDescriptor = v instanceof CallableDescriptor ? (CallableDescriptor)v : null;
            KotlinType kotlinType2 = declaredType = callableDescriptor == null ? null : callableDescriptor.getReturnType();
            if (declaredType != null) {
                return new Pair((Object)result2, (Object)SetsKt.setOf((Object)declaredType));
            }
        }
        return new Pair((Object)result2, null);
    }

    @NotNull
    public final Pair<FqNameUnsafe, String> getCallDebugInfo(@NotNull PsiElement element, @NotNull BindingContext bindingContext) {
        Object d;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        if (!(element instanceof KtExpression)) {
            return TuplesKt.to(null, (Object)TypeOfCall.OTHER.getNameToRender());
        }
        Call call2 = CallUtilKt.getCall((KtElement)element, bindingContext);
        String typeOfCall = this.getTypeOfCall((KtExpression)element, bindingContext);
        ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext.get(BindingContext.RESOLVED_CALL, call2);
        FqNameUnsafe fqNameUnsafe = resolvedCall2 == null ? null : ((d = resolvedCall2.getCandidateDescriptor()) == null ? null : DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)d));
        return TuplesKt.to(fqNameUnsafe, (Object)typeOfCall);
    }

    private final String getTypeOfCall(KtExpression expression2, BindingContext bindingContext) {
        String string2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, bindingContext);
        if (resolvedCall2 == null) {
            return TypeOfCall.UNRESOLVED.getNameToRender();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 instanceof VariableAsFunctionResolvedCall) {
            return TypeOfCall.VARIABLE_THROUGH_INVOKE.getNameToRender();
        }
        CallableDescriptor functionDescriptor = resolvedCall3.getCandidateDescriptor();
        if (functionDescriptor instanceof PropertyDescriptor) {
            string2 = TypeOfCall.PROPERTY_GETTER.getNameToRender();
        } else if (functionDescriptor instanceof FunctionDescriptor) {
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$getTypeOfCall_u24lambda_u2d18 = stringBuilder2;
            boolean bl5 = false;
            if (((FunctionDescriptor)functionDescriptor).isInline()) {
                $this$getTypeOfCall_u24lambda_u2d18.append("inline ");
            }
            if (((FunctionDescriptor)functionDescriptor).isInfix()) {
                $this$getTypeOfCall_u24lambda_u2d18.append("infix ");
            }
            if (((FunctionDescriptor)functionDescriptor).isOperator()) {
                $this$getTypeOfCall_u24lambda_u2d18.append("operator ");
            }
            if (DescriptorUtilsKt.isExtension(functionDescriptor)) {
                $this$getTypeOfCall_u24lambda_u2d18.append("extension ");
            }
            $this$getTypeOfCall_u24lambda_u2d18.append(TypeOfCall.FUNCTION.getNameToRender());
            String string3 = stringBuilder2.toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        } else {
            string2 = TypeOfCall.OTHER.getNameToRender();
        }
        return string2;
    }

    private static final int getSortedDiagnosticDescriptors$lambda-13(AbstractDiagnosticDescriptor d1, AbstractDiagnosticDescriptor d2) {
        Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
        Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
        return d1.getStart() != d2.getStart() ? d1.getStart() - d2.getStart() : d2.getEnd() - d1.getEnd();
    }

    static {
        Pattern pattern = Pattern.compile("(\\w+;)?(\\w+:)?(\\w+)(\\{[\\w;]+})?(?:\\(((?:\".*?\")(?:,\\s*\".*?\")*)\\))?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(INDIVIDUAL_DIAGNOSTIC)");
        individualDiagnosticPattern = pattern;
    }
}

