/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocationWithRange;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;

public class MessageUtil {
    private MessageUtil() {
    }

    @Nullable
    public static CompilerMessageSourceLocation psiElementToMessageLocation(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        return MessageUtil.psiFileToMessageLocation(file2, "<no path>", DiagnosticUtils.getLineAndColumnRangeInPsiFile(file2, element.getTextRange()));
    }

    @Nullable
    public static CompilerMessageSourceLocation psiFileToMessageLocation(@NotNull PsiFile file2, @Nullable String defaultValue, @NotNull PsiDiagnosticUtils.LineAndColumnRange range) {
        VirtualFile virtualFile2;
        if (file2 == null) {
            MessageUtil.$$$reportNull$$$0(0);
        }
        if (range == null) {
            MessageUtil.$$$reportNull$$$0(1);
        }
        String path2 = (virtualFile2 = file2.getVirtualFile()) != null ? MessageUtil.virtualFileToPath(virtualFile2) : defaultValue;
        PsiDiagnosticUtils.LineAndColumn start = range.getStart();
        PsiDiagnosticUtils.LineAndColumn end = range.getEnd();
        return MessageUtil.createMessageLocation(path2, start.getLineContent(), start.getLine(), start.getColumn(), end.getLine(), end.getColumn());
    }

    @Nullable
    public static CompilerMessageLocationWithRange createMessageLocation(@Nullable String path2, @Nullable String lineContent, int line, int column, int endLine, int endColumn) {
        return CompilerMessageLocationWithRange.create(path2, line, column, endLine, endColumn, lineContent);
    }

    @NotNull
    public static String virtualFileToPath(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            MessageUtil.$$$reportNull$$$0(2);
        }
        String string2 = FileUtil.toSystemDependentName(virtualFile2.getPath());
        if (string2 == null) {
            MessageUtil.$$$reportNull$$$0(3);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "virtualFileToPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiFileToMessageLocation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "virtualFileToPath";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

