/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a$\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"checkContextReceiversAreEnabled", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "contextReceiverList", "Lorg/jetbrains/kotlin/psi/KtContextReceiverList;", "checkSubtypingBetweenContextReceivers", "contextReceiverTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
public final class ContextReceiversUtilKt {
    public static final void checkContextReceiversAreEnabled(@NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull KtContextReceiverList contextReceiverList) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)contextReceiverList, (String)"contextReceiverList");
        if (!languageVersionSettings.supportsFeature(LanguageFeature.ContextReceivers)) {
            trace.report(Errors.UNSUPPORTED_FEATURE.on(contextReceiverList, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.ContextReceivers), (Object)languageVersionSettings)));
        }
    }

    public static final void checkSubtypingBetweenContextReceivers(@NotNull BindingTrace trace, @NotNull KtContextReceiverList contextReceiverList, @NotNull List<? extends KotlinType> contextReceiverTypes) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)contextReceiverList, (String)"contextReceiverList");
        Intrinsics.checkNotNullParameter(contextReceiverTypes, (String)"contextReceiverTypes");
        int n = CollectionsKt.getLastIndex(contextReceiverTypes);
        for (int i = 0; i < n; ++i) {
            KotlinType contextReceiverType = ContextReceiversUtilKt.checkSubtypingBetweenContextReceivers$prepared(contextReceiverTypes.get(i));
            int n2 = contextReceiverTypes.size();
            for (int j = i + 1; j < n2; ++j) {
                KotlinType anotherContextReceiverType = ContextReceiversUtilKt.checkSubtypingBetweenContextReceivers$prepared(contextReceiverTypes.get(j));
                if (!NewKotlinTypeChecker.Companion.getDefault().isSubtypeOf(contextReceiverType, anotherContextReceiverType) && !NewKotlinTypeChecker.Companion.getDefault().isSubtypeOf(anotherContextReceiverType, contextReceiverType)) continue;
                trace.report(Errors.SUBTYPING_BETWEEN_CONTEXT_RECEIVERS.on((KtElement)((PsiElement)contextReceiverList)));
                return;
            }
        }
    }

    private static final KotlinType checkSubtypingBetweenContextReceivers$prepared(KotlinType $this$checkSubtypingBetweenContextReceivers_u24prepared) {
        return TypeUtilsKt.isTypeParameter($this$checkSubtypingBetweenContextReceivers_u24prepared) ? (KotlinType)CollectionsKt.first((Iterable)TypeUtilsKt.supertypes($this$checkSubtypingBetweenContextReceivers_u24prepared)) : (TypeUtilsKt.containsTypeParameter($this$checkSubtypingBetweenContextReceivers_u24prepared) ? TypeUtilsKt.replaceArgumentsWithStarProjections($this$checkSubtypingBetweenContextReceivers_u24prepared) : $this$checkSubtypingBetweenContextReceivers_u24prepared);
    }
}

