/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.db.client;

import co.kuali.coeus.db.client.internal.CollectionUtils;
import co.kuali.coeus.db.client.internal.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.api.output.InfoResult;
import org.flywaydb.core.api.output.MigrateErrorResult;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.OperationResultBase;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;

public final class FlywayClient {
    private static final Logger LOG = LogManager.getLogger(FlywayClient.class);

    private FlywayClient() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void main(String[] args) {
        try {
            FlywayClient.main();
            LOG.info("SUCCESS");
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
            System.exit(1);
        }
    }

    public static void main() {
        Boolean enabled = FlywayClient.getValueAsBoolean("KC_FLYWAY_ENABLED");
        if (enabled != null && enabled.booleanValue()) {
            String commands = FlywayClient.getValueAsString("KC_FLYWAY_COMMANDS");
            if (StringUtils.isNotBlank(commands)) {
                FlywayClient.execute(commands);
            } else {
                LOG.warn("Flyway is enabled but no flyway commands are found.");
            }
        } else {
            LOG.info("Disabled flyway");
        }
    }

    private static void execute(String commands) {
        Flyway flyway = new FluentConfiguration().envVars().load();
        Arrays.stream(commands.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(String::toLowerCase).distinct().map(command -> CollectionUtils.entry(command, FlywayClient.findMethod(flyway, command))).forEach(cmdEntry -> {
            String command = (String)cmdEntry.getKey();
            Method cmdMethod = (Method)cmdEntry.getValue();
            if (cmdMethod != null) {
                LOG.info("Executing flyway command [" + command + "]");
                try {
                    Object result = cmdMethod.invoke((Object)flyway, new Object[0]);
                    if (!LOG.isInfoEnabled()) return;
                    LOG.info("Executed flyway command [" + command + "] with result [" + FlywayClient.resultToString(result) + "]");
                    return;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOG.error("Failed flyway command [" + command + "]", (Throwable)e);
                    throw new RuntimeException(e);
                }
            } else {
                LOG.error("Not Found flyway command [" + command + "]");
            }
        });
    }

    private static String resultToString(Object result) {
        if (result instanceof MigrateErrorResult) {
            return FlywayClient.resultToString((MigrateErrorResult)result);
        }
        if (result instanceof MigrateResult) {
            return FlywayClient.resultToString((MigrateResult)result);
        }
        if (result instanceof InfoResult) {
            return FlywayClient.resultToString((InfoResult)result);
        }
        if (result instanceof MigrationInfoServiceImpl) {
            return FlywayClient.resultToString(((MigrationInfoServiceImpl)result).getInfoResult());
        }
        if (result instanceof CleanResult) {
            return FlywayClient.resultToString((CleanResult)result);
        }
        if (result instanceof RepairResult) {
            return FlywayClient.resultToString((RepairResult)result);
        }
        if (result instanceof ValidateResult) {
            return FlywayClient.resultToString((ValidateResult)result);
        }
        if (result instanceof BaselineResult) {
            return FlywayClient.resultToString((BaselineResult)result);
        }
        if (result instanceof HtmlResult) {
            return FlywayClient.resultToString((HtmlResult)result);
        }
        if (result instanceof OperationResultBase) {
            return FlywayClient.resultToString((OperationResultBase)result);
        }
        return ToStringBuilder.reflectionToString(result, ToStringStyle.SHORT_PREFIX_STYLE, true);
    }

    private static String resultToString(MigrateErrorResult result) {
        return FlywayClient.append(new ToStringBuilder(result, ToStringStyle.SHORT_PREFIX_STYLE), result).append("error", new ToStringBuilder(result.error, ToStringStyle.SHORT_PREFIX_STYLE).append("errorCode", result.error.errorCode).append("message", result.error.message).append("stackTrace", result.error.stackTrace).append("lineNumber", result.error.lineNumber).append("path", result.error.path).append("cause", ToStringBuilder.reflectionToString(result.error.cause, ToStringStyle.SHORT_PREFIX_STYLE, true)).toString()).toString();
    }

    private static String resultToString(MigrateResult result) {
        return FlywayClient.append(new ToStringBuilder(result, ToStringStyle.SHORT_PREFIX_STYLE), result).toString();
    }

    private static ToStringBuilder append(ToStringBuilder toStringBuilder, MigrateResult result) {
        return FlywayClient.appendHtmlResult(toStringBuilder, result).append("initialSchemaVersion", result.success).append("targetSchemaVersion", result.targetSchemaVersion).append("schemaName", result.schemaName).append("migrationsExecuted", result.migrationsExecuted).append("success", result.success).append("flywayVersion", result.flywayVersion).append("database", result.database).append("warnings", result.warnings).append("databaseType", result.databaseType).append("migrations", result.migrations.stream().map(migration -> ToStringBuilder.reflectionToString(migration, ToStringStyle.SHORT_PREFIX_STYLE, true)).toList());
    }

    private static String resultToString(InfoResult result) {
        return FlywayClient.appendHtmlResult(new ToStringBuilder(result, ToStringStyle.SHORT_PREFIX_STYLE), result).append("schemaVersion", result.schemaVersion).append("schemaName", result.schemaName).append("flywayVersion", result.flywayVersion).append("database", result.database).append("allSchemasEmpty", result.allSchemasEmpty).append("migrations", result.migrations.stream().map(migration -> new ToStringBuilder(migration, ToStringStyle.SHORT_PREFIX_STYLE).append("category", migration.category).append("version", migration.version).append("rawVersion", migration.rawVersion).append("installedOnUTC", migration.installedOnUTC).append("state", migration.state).append("undoable", migration.undoable).append("installedBy", migration.installedBy).append("shouldExecuteExpression", migration.shouldExecuteExpression).append("executionTime", migration.executionTime).toString()).toList()).toString();
    }

    private static String resultToString(CleanResult result) {
        return ToStringBuilder.reflectionToString(result, ToStringStyle.SHORT_PREFIX_STYLE, true);
    }

    private static String resultToString(RepairResult result) {
        return FlywayClient.appendOperationResultBase(new ToStringBuilder(result, ToStringStyle.SHORT_PREFIX_STYLE), result).append("repairActions", result.repairActions).append("migrationsRemoved", result.migrationsRemoved.stream().map(repairAction -> ToStringBuilder.reflectionToString(repairAction, ToStringStyle.SHORT_PREFIX_STYLE, true)).toList()).append("migrationsDeleted", result.migrationsDeleted.stream().map(repairAction -> ToStringBuilder.reflectionToString(repairAction, ToStringStyle.SHORT_PREFIX_STYLE, true)).toList()).append("migrationsAligned", result.migrationsAligned.stream().map(repairAction -> ToStringBuilder.reflectionToString(repairAction, ToStringStyle.SHORT_PREFIX_STYLE, true)).toList()).toString();
    }

    private static String resultToString(ValidateResult result) {
        return FlywayClient.appendOperationResultBase(new ToStringBuilder(result, ToStringStyle.SHORT_PREFIX_STYLE), result).append("errorDetails", ToStringBuilder.reflectionToString(result.operation, ToStringStyle.SHORT_PREFIX_STYLE, true)).append("validationSuccessful", result.validationSuccessful).append("validateCount", result.validateCount).append("invalidMigrations", result.invalidMigrations.stream().map(repairAction -> ToStringBuilder.reflectionToString(repairAction, ToStringStyle.SHORT_PREFIX_STYLE, true)).toList()).toString();
    }

    private static String resultToString(BaselineResult result) {
        return ToStringBuilder.reflectionToString(result, ToStringStyle.SHORT_PREFIX_STYLE, true);
    }

    private static String resultToString(HtmlResult result) {
        return ToStringBuilder.reflectionToString(result, ToStringStyle.SHORT_PREFIX_STYLE, true);
    }

    private static String resultToString(OperationResultBase result) {
        return ToStringBuilder.reflectionToString(result, ToStringStyle.SHORT_PREFIX_STYLE, true);
    }

    private static ToStringBuilder appendHtmlResult(ToStringBuilder toStringBuilder, HtmlResult result) {
        return toStringBuilder.append("timestamp", result.getTimestamp()).append("operation", result.getOperation()).append("exception", result.getException()).append("licenseFailed", result.isLicenseFailed());
    }

    private static ToStringBuilder appendOperationResultBase(ToStringBuilder toStringBuilder, OperationResultBase result) {
        return toStringBuilder.append("flywayVersion", result.flywayVersion).append("database", result.database).append("warnings", result.warnings).append("operation", result.operation);
    }

    private static Method findMethod(Flyway flyway, String command) {
        try {
            return flyway.getClass().getMethod(command, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getValueAsString(String envCfg) {
        String env = System.getenv(envCfg);
        if (StringUtils.isNotBlank(env)) {
            return env;
        }
        return null;
    }

    private static Boolean getValueAsBoolean(String envCfg) {
        String env = System.getenv(envCfg);
        if (StringUtils.isNotBlank(env)) {
            return Boolean.valueOf(env);
        }
        return null;
    }
}

