/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.proprietaryStubs;

import java.util.List;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.TelemetrySpan;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.internal.license.FlywayRedgateEditionRequiredException;

public class AuthCommandExtensionStub
implements CommandExtension {
    private static final Log LOG = LogFactory.getLog(AuthCommandExtensionStub.class);
    private static final String FEATURE_NAME = "Auth";
    public static final String COMMAND = "Auth".toLowerCase();
    public static final String DESCRIPTION = "Authenticates Flyway with Redgate licensing";

    @Override
    public boolean handlesCommand(String command) {
        return COMMAND.equals(command);
    }

    @Override
    public boolean handlesParameter(String parameter) {
        return false;
    }

    @Override
    public OperationResult handle(String command, Configuration config, List<String> flags, FlywayTelemetryManager flywayTelemetryManager) throws FlywayException {
        return TelemetrySpan.trackSpan(new EventTelemetryModel(command, flywayTelemetryManager), telemetryModel -> {
            throw new FlywayRedgateEditionRequiredException(FEATURE_NAME);
        });
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getPriority() {
        return -100;
    }
}

