-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
-- Best Practices Memo
update COI_DISPOSITION_STATUS set COI_DISPOSITION_CODE = 215 where COI_DISPOSITION_CODE = 300
/

update COI_DISCLOSURE set DISCLOSURE_DISPOSITION_CODE = 215 where DISCLOSURE_DISPOSITION_CODE = 300
/

-- Submitted for Review
update COI_DISPOSITION_STATUS set COI_DISPOSITION_CODE = 300 where COI_DISPOSITION_CODE = 200
/

update COI_DISCLOSURE set DISCLOSURE_DISPOSITION_CODE = 300 where DISCLOSURE_DISPOSITION_CODE = 200
/

-- No Further Action
update COI_DISPOSITION_STATUS set COI_DISPOSITION_CODE = 211 where COI_DISPOSITION_CODE = 301
/

update COI_DISCLOSURE set DISCLOSURE_DISPOSITION_CODE = 211 where DISCLOSURE_DISPOSITION_CODE = 301
/

-- Disclosed Interests Eliminated
update COI_DISPOSITION_STATUS set COI_DISPOSITION_CODE = 220 where COI_DISPOSITION_CODE = 302
/

update COI_DISCLOSURE set DISCLOSURE_DISPOSITION_CODE = 220 where DISCLOSURE_DISPOSITION_CODE = 302
/

-- Disclosed Interests Reduced
update COI_DISPOSITION_STATUS set COI_DISPOSITION_CODE = 230 where COI_DISPOSITION_CODE = 303
/

update COI_DISCLOSURE set DISCLOSURE_DISPOSITION_CODE = 230 where DISCLOSURE_DISPOSITION_CODE = 303
/

-- Disclosed Interests Managed
update COI_DISPOSITION_STATUS set COI_DISPOSITION_CODE = 240 where COI_DISPOSITION_CODE = 304
/

update COI_DISCLOSURE set DISCLOSURE_DISPOSITION_CODE = 240 where DISCLOSURE_DISPOSITION_CODE = 304
/

-- No Conflict Exists
update COI_DISPOSITION_STATUS set COI_DISPOSITION_CODE = 210, DISPLAY_TO_REPORTER = 'Y' where COI_DISPOSITION_CODE = 305
/

update COI_DISCLOSURE set DISCLOSURE_DISPOSITION_CODE = 210 where DISCLOSURE_DISPOSITION_CODE = 305
/

-- Exempt
update COI_DISPOSITION_STATUS set COI_DISPOSITION_CODE = 200 where COI_DISPOSITION_CODE = 306
/

update COI_DISCLOSURE set DISCLOSURE_DISPOSITION_CODE = 200 where DISCLOSURE_DISPOSITION_CODE = 306
/

-- Under Review by COI Reviewer
update COI_DISPOSITION_STATUS set COI_DISPOSITION_CODE = 301 where COI_DISPOSITION_CODE = 201
/

update COI_DISCLOSURE set DISCLOSURE_DISPOSITION_CODE = 301 where DISCLOSURE_DISPOSITION_CODE = 201
/

-- Under COI Office Review
update COI_DISPOSITION_STATUS set COI_DISPOSITION_CODE = 302 where COI_DISPOSITION_CODE = 202
/

update COI_DISCLOSURE set DISCLOSURE_DISPOSITION_CODE = 302 where DISCLOSURE_DISPOSITION_CODE = 202
/

-- Under COI Committee Review
update COI_DISPOSITION_STATUS set COI_DISPOSITION_CODE = 303 where COI_DISPOSITION_CODE = 203
/

update COI_DISCLOSURE set DISCLOSURE_DISPOSITION_CODE = 303 where DISCLOSURE_DISPOSITION_CODE = 203
/

insert into COI_DISPOSITION_STATUS (COI_DISPOSITION_CODE, COI_DISCLOSURE_STATUS_CODE, DESCRIPTION, DISPLAY_TO_REPORTER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
	values (209, '3', 'Project Level Approval', 'N', NOW(), 'admin', 1, UUID())
/

insert into COI_DISPOSITION_STATUS (COI_DISPOSITION_CODE, COI_DISCLOSURE_STATUS_CODE, DESCRIPTION, DISPLAY_TO_REPORTER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
	values (305, '2', 'Awaiting Additional Information', 'N', NOW(), 'admin', 1, UUID())
/

insert into COI_DISPOSITION_STATUS (COI_DISPOSITION_CODE, COI_DISCLOSURE_STATUS_CODE, DESCRIPTION, DISPLAY_TO_REPORTER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
	values (310, '2', 'Potential Relationship', 'Y', NOW(), 'admin', 1, UUID())
/

insert into COI_DISPOSITION_STATUS (COI_DISPOSITION_CODE, COI_DISCLOSURE_STATUS_CODE, DESCRIPTION, DISPLAY_TO_REPORTER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
	values (320, '2', 'Relationship Identified', 'Y', NOW(), 'admin', 1, UUID())
/

insert into COI_DISPOSITION_STATUS (COI_DISPOSITION_CODE, COI_DISCLOSURE_STATUS_CODE, DESCRIPTION, DISPLAY_TO_REPORTER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
	values (325, '2', 'Reviewer Identified Conflict', 'N', NOW(), 'admin', 1, UUID())
/

insert into COI_DISPOSITION_STATUS (COI_DISPOSITION_CODE, COI_DISCLOSURE_STATUS_CODE, DESCRIPTION, DISPLAY_TO_REPORTER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
	values (330, '4', 'Unresolved', 'N', NOW(), 'admin', 1, UUID())
/

DELIMITER ;
