-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

CREATE TABLE SEQ_S2S_OPPORTUNITY_CFDA_ID (
  id BIGINT(19) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (id)
)
  ENGINE MyISAM;

ALTER TABLE SEQ_S2S_OPPORTUNITY_CFDA_ID
  AUTO_INCREMENT = 1;

CREATE TABLE S2S_OPPORTUNITY_CFDA (
  S2S_OPPORTUNITY_CFDA_ID DECIMAL(12,0) NOT NULL,
  PROPOSAL_NUMBER VARCHAR(8) NOT NULL,
  CFDA_NUMBER VARCHAR(7),
  CFDA_DESCRIPTION VARCHAR(255),
  UPDATE_TIMESTAMP DATETIME NOT NULL,
  UPDATE_USER VARCHAR(60) NOT NULL,
  VER_NBR DECIMAL(8, 0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR(36) NOT NULL
);

ALTER TABLE S2S_OPPORTUNITY_CFDA
  ADD CONSTRAINT PK_S2S_OPPORTUNITY_CFDA
PRIMARY KEY (S2S_OPPORTUNITY_CFDA_ID);

ALTER TABLE S2S_OPPORTUNITY_CFDA
  ADD CONSTRAINT FK_S2S_OPPORTUNITY_CFDA
FOREIGN KEY (PROPOSAL_NUMBER) REFERENCES S2S_OPPORTUNITY (PROPOSAL_NUMBER);

ALTER TABLE S2S_OPPORTUNITY_CFDA
  ADD CONSTRAINT UQ_S2S_OPPORTUNITY_CFDA
UNIQUE (OBJ_ID);

DELIMITER /

DROP PROCEDURE IF EXISTS s2s_cfda
/

CREATE PROCEDURE s2s_cfda()
  BEGIN
    DECLARE NO_MORE_RECORDS BOOLEAN DEFAULT FALSE;
    DECLARE V_PROPOSAL_NUMBER VARCHAR(8);
    DECLARE V_CFDA_NUMBER VARCHAR(7);
    DECLARE V_CFDA_DESCRIPTION VARCHAR(255);
    DECLARE V_UPDATE_TIMESTAMP DATETIME;
    DECLARE V_UPDATE_USER VARCHAR(60);
    DECLARE V_VER_NBR DECIMAL(8, 0);
    DECLARE V_OBJ_ID VARCHAR(36);

    DECLARE CFDA_CUR CURSOR FOR
      select PROPOSAL_NUMBER, CFDA_NUMBER, CFDA_DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID
      from S2S_OPPORTUNITY
      where CFDA_NUMBER is not null;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_RECORDS = TRUE;

    OPEN CFDA_CUR;

    CFDA_LOOP: LOOP
      FETCH CFDA_CUR INTO V_PROPOSAL_NUMBER, V_CFDA_NUMBER, V_CFDA_DESCRIPTION, V_UPDATE_TIMESTAMP, V_UPDATE_USER, V_VER_NBR, V_OBJ_ID;
      IF NO_MORE_RECORDS THEN
        CLOSE CFDA_CUR;
        LEAVE CFDA_LOOP;
      END IF;

      INSERT INTO SEQ_S2S_OPPORTUNITY_CFDA_ID VALUES(NULL);
      INSERT INTO S2S_OPPORTUNITY_CFDA (S2S_OPPORTUNITY_CFDA_ID, PROPOSAL_NUMBER, CFDA_NUMBER, CFDA_DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
      VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_OPPORTUNITY_CFDA_ID), V_PROPOSAL_NUMBER, V_CFDA_NUMBER, V_CFDA_DESCRIPTION, V_UPDATE_TIMESTAMP, V_UPDATE_USER, V_VER_NBR, V_OBJ_ID);

    END LOOP;

  END
/
CALL s2s_cfda()
/

DROP PROCEDURE IF EXISTS s2s_cfda
/

DELIMITER ;

-- update in a later script
-- update S2S_OPPORTUNITY set CFDA_NUMBER = null, CFDA_DESCRIPTION = null;


CREATE TABLE SEQ_EPS_PROP_CFDA_ID (
  id BIGINT(19) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (id)
)
  ENGINE MyISAM;

ALTER TABLE SEQ_EPS_PROP_CFDA_ID
  AUTO_INCREMENT = 1;

CREATE TABLE EPS_PROP_CFDA (
  EPS_PROP_CFDA_ID DECIMAL(12,0) NOT NULL,
  PROPOSAL_NUMBER VARCHAR(8) NOT NULL,
  CFDA_NUMBER VARCHAR(7) NOT NULL,
  CFDA_DESCRIPTION VARCHAR(255),
  UPDATE_TIMESTAMP DATETIME NOT NULL,
  UPDATE_USER VARCHAR(60) NOT NULL,
  VER_NBR DECIMAL(8, 0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR(36) NOT NULL
);

ALTER TABLE EPS_PROP_CFDA
  ADD CONSTRAINT PK_EPS_PROP_CFDA
PRIMARY KEY (EPS_PROP_CFDA_ID);

ALTER TABLE EPS_PROP_CFDA
  ADD CONSTRAINT FK_EPS_PROP_CFDA
FOREIGN KEY (PROPOSAL_NUMBER) REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE EPS_PROP_CFDA
  ADD CONSTRAINT UQ_EPS_PROP_CFDA
UNIQUE (OBJ_ID);

DELIMITER /

DROP PROCEDURE IF EXISTS proposal_cfda
/

CREATE PROCEDURE proposal_cfda()
  BEGIN
    DECLARE NO_MORE_RECORDS BOOLEAN DEFAULT FALSE;
    DECLARE V_PROPOSAL_NUMBER VARCHAR(8);
    DECLARE V_CFDA_NUMBER VARCHAR(7);
    DECLARE V_UPDATE_TIMESTAMP DATETIME;
    DECLARE V_UPDATE_USER VARCHAR(60);
    DECLARE V_VER_NBR DECIMAL(8, 0);
    DECLARE V_OBJ_ID VARCHAR(36);

    DECLARE CFDA_CUR CURSOR FOR
      select PROPOSAL_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID
      from EPS_PROPOSAL
      where CFDA_NUMBER is not null;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_RECORDS = TRUE;

    OPEN CFDA_CUR;

    CFDA_LOOP: LOOP
      FETCH CFDA_CUR INTO V_PROPOSAL_NUMBER, V_CFDA_NUMBER, V_UPDATE_TIMESTAMP, V_UPDATE_USER, V_VER_NBR, V_OBJ_ID;
      IF NO_MORE_RECORDS THEN
        CLOSE CFDA_CUR;
        LEAVE CFDA_LOOP;
      END IF;

      INSERT INTO SEQ_EPS_PROP_CFDA_ID VALUES(NULL);
      INSERT INTO EPS_PROP_CFDA (EPS_PROP_CFDA_ID, PROPOSAL_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
      VALUES ((SELECT (MAX(ID)) FROM SEQ_EPS_PROP_CFDA_ID), V_PROPOSAL_NUMBER, V_CFDA_NUMBER, V_UPDATE_TIMESTAMP, V_UPDATE_USER, V_VER_NBR, V_OBJ_ID);

    END LOOP;

  END
/
CALL proposal_cfda()
/

DROP PROCEDURE IF EXISTS proposal_cfda
/

DELIMITER ;

-- update in a later script
-- update EPS_PROPOSAL set CFDA_NUMBER = null;


CREATE TABLE SEQ_PROPOSAL_CFDA_ID (
  id BIGINT(19) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (id)
)
  ENGINE MyISAM;

ALTER TABLE SEQ_PROPOSAL_CFDA_ID
  AUTO_INCREMENT = 1;

CREATE TABLE PROPOSAL_CFDA (
  PROPOSAL_CFDA_ID DECIMAL(12,0) NOT NULL,
  PROPOSAL_ID DECIMAL(12,0) NOT NULL,
  PROPOSAL_NUMBER VARCHAR(8) NOT NULL,
  SEQUENCE_NUMBER DECIMAL(4,0) NOT NULL,
  CFDA_NUMBER VARCHAR(7) NOT NULL,
  CFDA_DESCRIPTION VARCHAR(255),
  UPDATE_TIMESTAMP DATETIME NOT NULL,
  UPDATE_USER VARCHAR(60) NOT NULL,
  VER_NBR DECIMAL(8, 0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR(36) NOT NULL
);

ALTER TABLE PROPOSAL_CFDA
  ADD CONSTRAINT PK_PROPOSAL_CFDA
PRIMARY KEY (PROPOSAL_CFDA_ID);

ALTER TABLE PROPOSAL_CFDA
  ADD CONSTRAINT UQ_PROPOSAL_CFDA
UNIQUE (OBJ_ID);

ALTER TABLE PROPOSAL_CFDA
  ADD CONSTRAINT FK_PROPOSAL_CFDA
FOREIGN KEY (PROPOSAL_ID) REFERENCES PROPOSAL (PROPOSAL_ID);

DELIMITER /

DROP PROCEDURE IF EXISTS ip_cfda
/

CREATE PROCEDURE ip_cfda()
  BEGIN
    DECLARE NO_MORE_RECORDS BOOLEAN DEFAULT FALSE;
    DECLARE V_PROPOSAL_ID DECIMAL(12,0);
    DECLARE V_PROPOSAL_NUMBER VARCHAR(8);
    DECLARE V_SEQUENCE_NUMBER DECIMAL(4,0);
    DECLARE V_CFDA_NUMBER VARCHAR(7);
    DECLARE V_UPDATE_TIMESTAMP DATETIME;
    DECLARE V_UPDATE_USER VARCHAR(60);
    DECLARE V_VER_NBR DECIMAL(8, 0);
    DECLARE V_OBJ_ID VARCHAR(36);

    DECLARE CFDA_CUR CURSOR FOR
      SELECT PROPOSAL_ID, PROPOSAL_NUMBER, SEQUENCE_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID
      FROM PROPOSAL
      WHERE CFDA_NUMBER IS NOT NULL;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_RECORDS = TRUE;

    OPEN CFDA_CUR;

    CFDA_LOOP: LOOP
      FETCH CFDA_CUR INTO V_PROPOSAL_ID, V_PROPOSAL_NUMBER, V_SEQUENCE_NUMBER, V_CFDA_NUMBER, V_UPDATE_TIMESTAMP, V_UPDATE_USER, V_VER_NBR, V_OBJ_ID;
      IF NO_MORE_RECORDS THEN
        CLOSE CFDA_CUR;
        LEAVE CFDA_LOOP;
      END IF;

      INSERT INTO SEQ_PROPOSAL_CFDA_ID VALUES(NULL);
      INSERT INTO PROPOSAL_CFDA (PROPOSAL_CFDA_ID, PROPOSAL_ID, PROPOSAL_NUMBER, SEQUENCE_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
      VALUES ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CFDA_ID), V_PROPOSAL_ID, V_PROPOSAL_NUMBER, V_SEQUENCE_NUMBER, V_CFDA_NUMBER, V_UPDATE_TIMESTAMP, V_UPDATE_USER, V_VER_NBR, V_OBJ_ID);

    END LOOP;

  END
/
CALL ip_cfda()
/

DROP PROCEDURE IF EXISTS ip_cfda
/

DELIMITER ;

-- update in a later script
-- update PROPOSAL set CFDA_NUMBER = null;


CREATE TABLE SEQ_AWARD_CFDA_ID (
  id BIGINT(19) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (id)
)
  ENGINE MyISAM;

ALTER TABLE SEQ_AWARD_CFDA_ID
  AUTO_INCREMENT = 1;

CREATE TABLE AWARD_CFDA (
  AWARD_CFDA_ID DECIMAL(12,0) NOT NULL,
  AWARD_ID DECIMAL(22,0) NOT NULL,
  AWARD_NUMBER VARCHAR(12) NOT NULL,
  SEQUENCE_NUMBER DECIMAL(8,0) NOT NULL,
  CFDA_NUMBER VARCHAR(7) NOT NULL,
  CFDA_DESCRIPTION VARCHAR(255),
  UPDATE_TIMESTAMP DATETIME NOT NULL,
  UPDATE_USER VARCHAR(60) NOT NULL,
  VER_NBR DECIMAL(8, 0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR(36) NOT NULL
);

ALTER TABLE AWARD_CFDA
  ADD CONSTRAINT PK_AWARD_CFDA
PRIMARY KEY (AWARD_CFDA_ID);

ALTER TABLE AWARD_CFDA
  ADD CONSTRAINT UQ_AWARD_CFDA
UNIQUE (OBJ_ID);

ALTER TABLE AWARD_CFDA
  ADD CONSTRAINT FK_AWARD_CFDA
FOREIGN KEY (AWARD_ID) REFERENCES AWARD (AWARD_ID);

DELIMITER /

DROP PROCEDURE IF EXISTS award_cfda
/

CREATE PROCEDURE award_cfda()
  BEGIN
    DECLARE NO_MORE_RECORDS BOOLEAN DEFAULT FALSE;
    DECLARE V_AWARD_ID DECIMAL(22,0);
    DECLARE V_AWARD_NUMBER VARCHAR(12);
    DECLARE V_SEQUENCE_NUMBER DECIMAL(8,0);
    DECLARE V_CFDA_NUMBER VARCHAR(7);
    DECLARE V_UPDATE_TIMESTAMP DATETIME;
    DECLARE V_UPDATE_USER VARCHAR(60);
    DECLARE V_VER_NBR DECIMAL(8, 0);
    DECLARE V_OBJ_ID VARCHAR(36);

    DECLARE CFDA_CUR CURSOR FOR
      SELECT AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID
      FROM AWARD
      WHERE CFDA_NUMBER IS NOT NULL;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_RECORDS = TRUE;

    OPEN CFDA_CUR;

    CFDA_LOOP: LOOP
      FETCH CFDA_CUR INTO V_AWARD_ID, V_AWARD_NUMBER, V_SEQUENCE_NUMBER, V_CFDA_NUMBER, V_UPDATE_TIMESTAMP, V_UPDATE_USER, V_VER_NBR, V_OBJ_ID;
      IF NO_MORE_RECORDS THEN
        CLOSE CFDA_CUR;
        LEAVE CFDA_LOOP;
      END IF;

      INSERT INTO SEQ_AWARD_CFDA_ID VALUES(NULL);
      INSERT INTO AWARD_CFDA (AWARD_CFDA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
      VALUES ((SELECT (MAX(ID)) FROM SEQ_AWARD_CFDA_ID), V_AWARD_ID, V_AWARD_NUMBER, V_SEQUENCE_NUMBER, V_CFDA_NUMBER, V_UPDATE_TIMESTAMP, V_UPDATE_USER, V_VER_NBR, V_OBJ_ID);

    END LOOP;

  END
/
CALL award_cfda()
/

DROP PROCEDURE IF EXISTS award_cfda
/

DELIMITER ;

-- update in a later script
-- update AWARD set CFDA_NUMBER = null;
