-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /

DROP PROCEDURE IF EXISTS p
/
CREATE PROCEDURE p ()
BEGIN
    DECLARE temp INT;
    
    SELECT COUNT(*) INTO temp FROM RATE_CLASS WHERE RATE_CLASS_CODE = '1';
    IF temp = 0 THEN 
        INSERT INTO RATE_CLASS (RATE_CLASS_CODE,DESCRIPTION,RATE_CLASS_TYPE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
            VALUES ('1','MTDC','O','admin',NOW(),UUID(),1); 
    END IF;
    
    SELECT COUNT(*) INTO temp FROM RATE_CLASS WHERE RATE_CLASS_CODE = '2';
    IF temp = 0 THEN
        INSERT INTO RATE_CLASS (RATE_CLASS_CODE,DESCRIPTION,RATE_CLASS_TYPE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
            VALUES ('2','TDC','O','admin',NOW(),UUID(),1);
    END IF;
    
    SELECT COUNT(*) INTO temp FROM RATE_CLASS WHERE RATE_CLASS_CODE = '3';
    IF temp = 0 THEN
        INSERT INTO RATE_CLASS (RATE_CLASS_CODE,DESCRIPTION,RATE_CLASS_TYPE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
            VALUES ('3','S&W','O','admin',NOW(),UUID(),1);
    END IF;
    
    SELECT COUNT(*) INTO temp FROM RATE_CLASS WHERE RATE_CLASS_CODE = '4';
    IF temp = 0 THEN
        INSERT INTO RATE_CLASS (RATE_CLASS_CODE,DESCRIPTION,RATE_CLASS_TYPE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
            VALUES ('4','Fund with Transaction Fee (FUNSN)','O','admin',NOW(),UUID(),1);
    END IF;
    
    SELECT COUNT(*) INTO temp FROM RATE_CLASS WHERE RATE_CLASS_CODE = '5';
    IF temp = 0 THEN
        INSERT INTO RATE_CLASS (RATE_CLASS_CODE,DESCRIPTION,RATE_CLASS_TYPE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
            VALUES ('5','Employee Benefits','E','admin',NOW(),UUID(),1);
    END IF;
    
    SELECT COUNT(*) INTO temp FROM RATE_CLASS WHERE RATE_CLASS_CODE = '7';
    IF temp = 0 THEN
        INSERT INTO RATE_CLASS (RATE_CLASS_CODE,DESCRIPTION,RATE_CLASS_TYPE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
            VALUES ('7','Inflation','I','admin',NOW(),UUID(),1);
    END IF;
    
    SELECT COUNT(*) INTO temp FROM RATE_CLASS WHERE RATE_CLASS_CODE = '8';
    IF temp = 0 THEN
        INSERT INTO RATE_CLASS (RATE_CLASS_CODE,DESCRIPTION,RATE_CLASS_TYPE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
            VALUES ('8','Vacation','V','admin',NOW(),UUID(),1);
    END IF;
    
    SELECT COUNT(*) INTO temp FROM RATE_CLASS WHERE RATE_CLASS_CODE = '9';
    IF temp = 0 THEN
        INSERT INTO RATE_CLASS (RATE_CLASS_CODE,DESCRIPTION,RATE_CLASS_TYPE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
            VALUES ('9','Other','X','admin',NOW(),UUID(),1);
    END IF;
    
    SELECT COUNT(*) INTO temp FROM RATE_CLASS WHERE RATE_CLASS_CODE = '10';
    IF temp = 0 THEN
        INSERT INTO RATE_CLASS (RATE_CLASS_CODE,DESCRIPTION,RATE_CLASS_TYPE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
            VALUES ('10','Lab Allocation - Salaries','Y','admin',NOW(),UUID(),1);
    END IF;
    
    SELECT COUNT(*) INTO temp FROM RATE_CLASS WHERE RATE_CLASS_CODE = '11';
    IF temp = 0 THEN
        INSERT INTO RATE_CLASS (RATE_CLASS_CODE,DESCRIPTION,RATE_CLASS_TYPE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
            VALUES ('11','Lab Allocation - M&S','L','admin',NOW(),UUID(),1);
    END IF;
    
    SELECT COUNT(*) INTO temp FROM RATE_CLASS WHERE RATE_CLASS_CODE = '12';
    IF temp = 0 THEN
        INSERT INTO RATE_CLASS (RATE_CLASS_CODE,DESCRIPTION,RATE_CLASS_TYPE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
            VALUES ('12','Lab Allocation - Utilities','L','admin',NOW(),UUID(),1);
    END IF;
END
/
CALL p ()
/
DROP PROCEDURE IF EXISTS p
/

CREATE PROCEDURE p ()
BEGIN
    DECLARE temp INT;
    
    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '1' AND RATE_CLASS_CODE = '1';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('1','1','MTDC','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '1' AND RATE_CLASS_CODE = '2';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('1','2','TDC','admin',NOW(),UUID(),1);
    END IF;
    
    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '1' AND RATE_CLASS_CODE = '3';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('1','3','S&W','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '1' AND RATE_CLASS_CODE = '4';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('1','4','Salaries','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '1' AND RATE_CLASS_CODE = '5';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('1','5','Research Rate','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '1' AND RATE_CLASS_CODE = '7';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('1','7','Faculty Salaries (6/1)','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '1' AND RATE_CLASS_CODE = '8';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('1','8','Vacation ','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '1' AND RATE_CLASS_CODE = '9';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('1','9','Other','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '1' AND RATE_CLASS_CODE = '10';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('1','10','Lab Allocation - Salaries','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '1' AND RATE_CLASS_CODE = '11';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('1','11','Lab Allocation - M&S','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '1' AND RATE_CLASS_CODE = '12';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('1','12','Lab Allocation - Utilities','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '2' AND RATE_CLASS_CODE = '4';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('2','4','Materials and Services','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '2' AND RATE_CLASS_CODE = '5';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('2','5','UROP Rate','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '2' AND RATE_CLASS_CODE = '7';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('2','7','Administrative Salaries (7/1)','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '2' AND RATE_CLASS_CODE = '8';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('2','8','Vacation on LA','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '3' AND RATE_CLASS_CODE = '5';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('3','5','EB on LA','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '3' AND RATE_CLASS_CODE = '7';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('3','7','Support Staff Salaries (4/1)','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '4' AND RATE_CLASS_CODE = '5';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('4','5','another EB rate','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '4' AND RATE_CLASS_CODE = '7';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('4','7','Materials and Services','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '5' AND RATE_CLASS_CODE = '5';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('5','5','eb added in pb','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '5' AND RATE_CLASS_CODE = '7';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('5','7','Research Staff (1/1)','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '6' AND RATE_CLASS_CODE = '5';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('6','5','Award Special EB Rate','admin',NOW(),UUID(),1);
    END IF;

    SELECT COUNT(*) INTO temp FROM RATE_TYPE WHERE RATE_TYPE_CODE = '6' AND RATE_CLASS_CODE = '7';
    IF temp = 0 THEN
    INSERT INTO RATE_TYPE (RATE_TYPE_CODE,RATE_CLASS_CODE,DESCRIPTION,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
        VALUES ('6','7','Students (6/1)','admin',NOW(),UUID(),1);
    END IF;
END 
/
CALL p ()
/
DROP PROCEDURE IF EXISTS p
/
delimiter ;
