-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /

DROP PROCEDURE IF EXISTS p
/
CREATE PROCEDURE p ()
BEGIN
  DECLARE maxAttributeId INT;
  CREATE TABLE IF NOT EXISTS SEQ_CUSTOM_ATTRIBUTE (id bigint(19) not null auto_increment, primary key (id)) ENGINE MyISAM;
  select ifnull(max(ID),0) into maxAttributeId from CUSTOM_ATTRIBUTE;
  IF maxAttributeId = 0 THEN
    set @alter_seq := concat('ALTER TABLE SEQ_CUSTOM_ATTRIBUTE auto_increment = ', maxAttributeId+1); 
    prepare alter_seq_stmt from @alter_seq;
    execute alter_seq_stmt;
    deallocate prepare alter_seq_stmt;
  END IF;
END;
/
CALL p ()
/
DROP PROCEDURE IF EXISTS p
/
DELIMITER ;
