--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

DELIMITER /
CREATE TABLE IACUC_PROTOCOL ( 
    PROTOCOL_ID DECIMAL(12,0) NOT NULL, 
    PROTOCOL_NUMBER VARCHAR(20) NOT NULL, 
    SEQUENCE_NUMBER DECIMAL(4,0) NOT NULL, 
    VERSION_NUMBER DECIMAL(4,0), 
    DOCUMENT_NUMBER     VARCHAR(40) NOT NULL,
    PROTOCOL_TYPE_CODE DECIMAL(3,0) NOT NULL, 
    PROJECT_TYPE_CODE DECIMAL(3,0), 
    PROTOCOL_STATUS_CODE DECIMAL(3,0) NOT NULL, 
    TITLE VARCHAR(2000) NOT NULL, 
    DESCRIPTION VARCHAR(2000), 
    APPLICATION_DATE DATE NOT NULL, 
    APPROVAL_DATE DATE, 
    EXPIRATION_DATE DATE, 
    FDA_APPLICATION_NUMBER VARCHAR(15), 
    REFERENCE_NUMBER_1 VARCHAR(50), 
    REFERENCE_NUMBER_2 VARCHAR(50), 
    ACTIVE VARCHAR(1),
    IS_BILLABLE VARCHAR(1) DEFAULT 'N' NOT NULL, 
    SPECIAL_REVIEW_INDICATOR VARCHAR(2) DEFAULT 'N0' NOT NULL, 
    KEY_STUDY_PERSON_INDICATOR VARCHAR(2) DEFAULT 'N0' NOT NULL, 
    FUNDING_SOURCE_INDICATOR VARCHAR(2) DEFAULT 'N0' NOT NULL, 
    CORRESPONDENT_INDICATOR VARCHAR(2) DEFAULT 'N0' NOT NULL, 
    REFERENCE_INDICATOR VARCHAR(2) DEFAULT 'N0' NOT NULL, 
    LAY_STATEMENT_1 VARCHAR(2000), 
    LAY_STATEMENT_2 VARCHAR(2000), 
    CREATE_TIMESTAMP DATE NOT NULL, 
    CREATE_USER VARCHAR(60) NOT NULL, 
    UPDATE_TIMESTAMP DATE NOT NULL, 
    UPDATE_USER VARCHAR(60) NOT NULL, 
    LAST_APPROVAL_DATE DATE, 
    OVERVIEW_TIMELINE VARCHAR(2000), 
    SPECIES_STUDY_GROUP_INDICATOR VARCHAR(2) DEFAULT 'N0' NOT NULL, 
    ALTERNATIVE_SEARCH_INDICATOR VARCHAR(2) DEFAULT 'N0' NOT NULL, 
    SCIENTIFIC_JUSTIF_INDICATOR VARCHAR(2) DEFAULT 'N0' NOT NULL, 
    VER_NBR DECIMAL(8,0) DEFAULT 1 NOT NULL, 
    OBJ_ID VARCHAR(36) NOT NULL) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/
ALTER TABLE IACUC_PROTOCOL 
ADD CONSTRAINT PK_IACUC_PROTOCOL 
PRIMARY KEY (PROTOCOL_ID)
/
DELIMITER ;
