/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.common.UniversalConnectionPoolStatisticsImpl;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.runtime.TraceControllerImpl;
import oracle.ucp.tuners.PoolSizeTuner;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT})
public class UniversalConnectionPoolImpl
extends UniversalConnectionPoolBase {
    public final UniversalConnectionPoolInternal m_ucpInternal = new UniversalConnectionPoolInternal(this);
    private boolean isNoWaitBorrow = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;

    public UniversalConnectionPoolImpl(ConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        JDBCConnectionRetrievalInfo jdbcCri;
        ConnectionRetrievalInfo connectionRetrievalInfo2;
        boolean bl;
        boolean bl2 = bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        if (null == connectionRetrievalInfo2) {
            UCPErrorHandler.throwUniversalConnectionPoolException(203);
        }
        PoolSizeTuner.trigger();
        if (connectionRetrievalInfo2 instanceof JDBCConnectionRetrievalInfo && (jdbcCri = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo2).getServiceName() == null) {
            connectionRetrievalInfo2 = jdbcCri.getCopyWithService(this.getServiceName());
        }
        UniversalPooledConnection conn = null;
        this.m_pendingRequestsCount.incrementAndGet();
        try {
            conn = this.borrowConnectionAndValidate(connectionRetrievalInfo2);
            this.borrowedAccumulator.addAndGet(this.getBorrowedConnectionsCount());
            this.borrowedSamples.incrementAndGet();
            if (conn != null) {
                ((UniversalPooledConnectionImpl)conn).setBorrowCRI(connectionRetrievalInfo2);
            }
        }
        catch (UniversalConnectionPoolException e2) {
            if (bl) {
                this.ilogThrowing($$$loggerRef$$$0, UniversalConnectionPoolImpl.class, $$$methodRef$$$0, this, e2);
            }
            throw e2;
        }
        finally {
            this.m_pendingRequestsCount.decrementAndGet();
        }
        return conn;
    }

    private UniversalPooledConnection borrowConnectionAndValidate(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        long delta;
        int stt;
        boolean needToValidate = this.getValidateConnectionOnBorrow();
        if (!needToValidate) {
            return this.borrowConnectionWithoutCountingRequests(cri);
        }
        UniversalPooledConnection upc = null;
        while (!(null == (upc = this.borrowConnectionWithoutCountingRequests(cri)) || (stt = this.getSecondsToTrustIdleConnection()) > 0 && (delta = Clock.clock() - upc.getLastNetworkAccessTime()) < (long)stt * 1000L || upc.isValid())) {
            upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
            upc.setLastConnectionValidationTime(0L);
            this.returnConnection(upc);
            upc = null;
        }
        if (null == upc) {
            UCPErrorHandler.throwUniversalConnectionPoolException(56);
        }
        return upc;
    }

    /*
     * WARNING - void declaration
     */
    protected void setNoWaitBorrow(boolean bl) {
        void isNoWaitBorrow;
        boolean bl2 = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.isNoWaitBorrow = isNoWaitBorrow;
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$2, UniversalConnectionPoolImpl.class, $$$methodRef$$$2, this, "isNoWaitBorrow=" + (boolean)isNoWaitBorrow);
        }
    }

    protected long computeBorrowGiveUpTimestamp() {
        return Clock.clock() + (this.isNoWaitBorrow ? 0L : (long)this.getConnectionWaitTimeout() * 1000L);
    }

    protected boolean isStillOkayToBorrow(long giveUp) {
        return Clock.clock() <= giveUp || this.core.pendingAvailableGrows() > 0;
    }

    private UniversalPooledConnection borrowConnectionWithoutCountingRequests(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        UniversalPooledConnection upc;
        assert (cri != null);
        Properties reqLabels = cri.getLabels();
        if (reqLabels != null && this.getConnectionLabelingCallback() == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(92);
        }
        long begTime = Clock.clock();
        long giveUp = this.computeBorrowGiveUpTimestamp();
        int ITERATIONS_TO_YIELD = 5;
        int iteration = 0;
        while (this.isStillOkayToBorrow(giveUp)) {
            if (!this.isLifecycleRunning()) {
                UCPErrorHandler.throwUniversalConnectionPoolException(60);
            }
            this.validatePoolSizes();
            if (this.core.uselessConnsCleanerInProgress() || 0 == this.getAvailableConnectionsCount() || !this.core.available(cri)) {
                upc = this.helpGrowBorrowed(cri, this.getConnectionAffinityCallback(), giveUp - Clock.clock());
                if (null != upc) {
                    return this.postBorrow(upc, begTime, reqLabels);
                }
                if (this.isNoWaitBorrow) {
                    return null;
                }
            }
            if (0 == ++iteration % 5) {
                Thread.yield();
            }
            if ((upc = this.getAvailableConnection(cri, giveUp - Clock.clock())) != null) {
                return this.postBorrow(upc, begTime);
            }
            ConnectionAffinityCallback callback = this.getConnectionAffinityCallback();
            if (null == callback || null == callback.getConnectionAffinityContext()) continue;
            callback.setConnectionAffinityContext(null);
        }
        upc = this.getAvailableConnection(cri, 0L);
        if (null != upc) {
            return this.postBorrow(upc, begTime);
        }
        upc = this.helpGrowBorrowed(cri, this.getConnectionAffinityCallback(), giveUp - Clock.clock());
        if (null != upc) {
            return this.postBorrow(upc, begTime, reqLabels);
        }
        this.updateConnectionWaitCounters(false, begTime);
        if (this.isNoWaitBorrow) {
            return null;
        }
        if (this.core.noMoreGrows()) {
            UCPErrorHandler.throwUniversalConnectionPoolException(65);
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(64);
        }
        return null;
    }

    private UniversalPooledConnection helpGrowBorrowed(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long timeToRetry) throws UniversalConnectionPoolException {
        long started = Clock.clock();
        CoreConnection conn = this.core.growBorrowed(cri, callback, timeToRetry);
        this.insertToCreatedHistogram(cri, Clock.clock() - started);
        return null == conn ? null : (UniversalPooledConnection)conn.getDelegate();
    }

    private UniversalPooledConnection postBorrow(UniversalPooledConnection upc, long begTime, Properties reqLabels) {
        if (null == upc) {
            throw new IllegalArgumentException("no upc");
        }
        if (null != reqLabels) {
            this.getConnectionLabelingCallback().configure(reqLabels, this.getConnectionObjectForLabelingConfigure(upc));
        }
        upc.setBorrowedStartTime();
        upc.heartbeat();
        this.updateConnectionWaitCounters(true, begTime);
        return upc;
    }

    private UniversalPooledConnection postBorrow(UniversalPooledConnection upc, long begTime) {
        return this.postBorrow(upc, begTime, null);
    }

    protected UniversalPooledConnection createOnePooledConnection() {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        UniversalPooledConnection upc = null;
        try {
            ConnectionRetrievalInfo cri = this.getConnectionRetrievalInfo();
            if (null == cri) {
                UCPErrorHandler.throwUniversalConnectionPoolException(4);
            }
            upc = this.createOnePooledConnection(cri);
        }
        catch (UniversalConnectionPoolException exc) {
            if (bl) {
                this.ilogThrowing($$$loggerRef$$$9, UniversalConnectionPoolImpl.class, $$$methodRef$$$9, this, exc);
            }
            upc = null;
        }
        if (bl) {
            this.ilogFinest($$$loggerRef$$$9, UniversalConnectionPoolImpl.class, $$$methodRef$$$9, this, "upc=" + upc);
        }
        return upc;
    }

    private void updateConnectionWaitCounters(boolean success, long begTime) {
        long waitTime = Clock.clock() - begTime;
        (success ? this.m_cumulativeSuccessfulConnectionWaitCount : this.m_cumulativeFailedConnectionWaitCount).incrementAndGet();
        (success ? this.m_cumulativeSuccessfulConnectionWaitTime : this.m_cumulativeFailedConnectionWaitTime).addAndGet(waitTime);
        this.m_peakConnectionWaitTime.update(waitTime);
    }

    @Override
    public UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        return this.m_ucpInternal.createOnePooledConnectionInternal(cri);
    }

    @Override
    public void returnConnection(UniversalPooledConnection upc) throws UniversalConnectionPoolException {
        if (null == upc) {
            UCPErrorHandler.throwUniversalConnectionPoolException(150);
        }
        if (this.m_lifeCycleState.get() != UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING) {
            UCPErrorHandler.throwUniversalConnectionPoolException(60);
        }
        if (upc.isAvailable()) {
            return;
        }
        this.core.reclaim(upc.getDelegator());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeConnection(UniversalPooledConnection universalPooledConnection) throws UniversalConnectionPoolException {
        void pooledConnection;
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.m_ucpInternal.checkLifecycle();
        if (null == pooledConnection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(150);
        }
        this.m_cumulativeConnectionUseTime.getAndAdd(Clock.clock() - pooledConnection.getBorrowedStartTime());
        if (UniversalPooledConnectionStatus.STATUS_RECONNECTING == pooledConnection.getStatus()) {
            Object removedConnection = null;
        } else {
            this.closePooledConnection((UniversalPooledConnection)pooledConnection);
        }
        if (bl) {
            this.ilogFinest($$$loggerRef$$$13, UniversalConnectionPoolImpl.class, $$$methodRef$$$13, this, "pooledConnection=" + pooledConnection);
        }
    }

    protected void closePooledConnection(UniversalPooledConnection pooledConnection) {
        CoreConnection conn = pooledConnection.getDelegator();
        if (this.core.retrieve(conn)) {
            conn.abort();
            conn.close();
        }
    }

    @Override
    public void purge() throws UniversalConnectionPoolException {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.m_ucpInternal.checkLifecycle();
        this.core.closeAll();
        if (bl) {
            this.ilogFinest($$$loggerRef$$$15, UniversalConnectionPoolImpl.class, $$$methodRef$$$15, this, "purge");
        }
    }

    @Override
    public void refresh() throws UniversalConnectionPoolException {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.m_ucpInternal.checkLifecycle();
        this.core.replaceAvailable();
        if (bl) {
            this.ilogFinest($$$loggerRef$$$16, UniversalConnectionPoolImpl.class, $$$methodRef$$$16, this, "regresh");
        }
    }

    @Override
    public void recycle() throws UniversalConnectionPoolException {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.m_ucpInternal.checkLifecycle();
        this.core.replaceInvalidAvailable();
        if (bl) {
            this.ilogFinest($$$loggerRef$$$17, UniversalConnectionPoolImpl.class, $$$methodRef$$$17, this, "recycle");
        }
    }

    @Override
    void processConnectionHarvesting() {
        this.core.harvest(this.getConnectionHarvestTriggerCount(), this.getConnectionHarvestMaxCount());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setConnectionHarvestable(UniversalPooledConnection universalPooledConnection, boolean bl) {
        block3: {
            boolean bl2 = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
            try {
                void isConnectionHarvestable;
                void pooledConnection;
                pooledConnection.setConnectionHarvestable((boolean)isConnectionHarvestable);
                if (bl2) {
                    this.ilogFinest($$$loggerRef$$$19, UniversalConnectionPoolImpl.class, $$$methodRef$$$19, this, "isConnectionHarvestable=" + (boolean)isConnectionHarvestable);
                }
            }
            catch (UniversalConnectionPoolException e2) {
                if (!bl2) break block3;
                this.ilogThrowing($$$loggerRef$$$19, UniversalConnectionPoolImpl.class, $$$methodRef$$$19, this, e2);
            }
        }
    }

    @Override
    protected void closePhysicalConnection(Object physicalConnection) {
        super.closePhysicalConnection(physicalConnection);
    }

    @Override
    public UniversalConnectionPoolStatistics getStatistics() {
        return new UniversalConnectionPoolStatisticsImpl(this);
    }

    @Override
    protected void discardUsedConnection(Object physicalConnection) {
        this.m_ucpInternal.discardUsedConnectionInternal(physicalConnection);
    }

    @Override
    protected UniversalPooledConnection getUsedConnection(Object physicalConnection) {
        return this.m_ucpInternal.getUsedConnectionInternal(physicalConnection);
    }

    @Override
    protected boolean returnUsedPhysicalConnection(Object physicalConnection) throws UniversalConnectionPoolException {
        return this.m_ucpInternal.returnUsedPhysicalConnectionInternal(physicalConnection);
    }

    @Override
    protected boolean closeUsedPhysicalConnection(Object physicalConnection) throws UniversalConnectionPoolException {
        return this.m_ucpInternal.closeUsedPhysicalConnectionInternal(physicalConnection);
    }

    protected UniversalPooledConnection getAvailableConnection(ConnectionRetrievalInfo cri, long timeout) throws UniversalConnectionPoolException {
        assert (cri != null);
        Properties requestedLabels = cri.getLabels();
        boolean isLabeledRequest = requestedLabels != null;
        UniversalPooledConnection upc = this.getAvailableConnectionHelper(cri, null, timeout);
        if (isLabeledRequest && upc == null) {
            upc = this.getAvailableConnectionHelper(cri.getCopyWithNoLabels(), cri.getLabels(), timeout);
        }
        return upc;
    }

    private UniversalPooledConnection getAvailableConnectionHelper(ConnectionRetrievalInfo cri, Properties requestedLabelsForRetry, long timeout) throws UniversalConnectionPoolException {
        Properties requestedLabels;
        if (null == cri) {
            throw new IllegalArgumentException("cri is null");
        }
        Properties criLabels = cri.getLabels();
        boolean isLabeledRequest = criLabels != null || requestedLabelsForRetry != null;
        CoreConnection coreConn = this.core.borrow(cri, this.getConnectionAffinityCallback(), timeout);
        UniversalPooledConnection selectedConnection = null == coreConn ? null : (UniversalPooledConnection)coreConn.getDelegate();
        Properties properties = requestedLabels = criLabels != null ? criLabels : requestedLabelsForRetry;
        if (selectedConnection != null && (isLabeledRequest && (this.needToConfigureConnection(selectedConnection, requestedLabels) || selectedConnection.labelingCost(requestedLabels) > 0) || null != requestedLabelsForRetry)) {
            this.getConnectionLabelingCallback().configure(requestedLabels, this.getConnectionObjectForLabelingConfigure(selectedConnection));
        }
        return selectedConnection;
    }

    protected Object getConnectionObjectForLabelingConfigure(UniversalPooledConnection upc) {
        return upc.getPhysicalConnection();
    }

    protected void incrementCumulativeConnectionsCreated() {
        this.m_cumulativeConnectionsCreated.incrementAndGet();
    }

    protected boolean needToConfigureConnection(UniversalPooledConnection pc, Properties requestedLabels) throws UniversalConnectionPoolException {
        return false;
    }

    protected boolean isAffinityStrict() {
        return false;
    }

    static {
        try {
            $$$methodRef$$$32 = UniversalConnectionPoolImpl.class.getDeclaredConstructor(ConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = UniversalConnectionPoolImpl.class.getDeclaredMethod("isAffinityStrict", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = UniversalConnectionPoolImpl.class.getDeclaredMethod("needToConfigureConnection", UniversalPooledConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = UniversalConnectionPoolImpl.class.getDeclaredMethod("incrementCumulativeConnectionsCreated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getConnectionObjectForLabelingConfigure", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getAvailableConnectionHelper", ConnectionRetrievalInfo.class, Properties.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getAvailableConnection", ConnectionRetrievalInfo.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closeUsedPhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = UniversalConnectionPoolImpl.class.getDeclaredMethod("returnUsedPhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getUsedConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = UniversalConnectionPoolImpl.class.getDeclaredMethod("discardUsedConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closePhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = UniversalConnectionPoolImpl.class.getDeclaredMethod("setConnectionHarvestable", UniversalPooledConnection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = UniversalConnectionPoolImpl.class.getDeclaredMethod("processConnectionHarvesting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = UniversalConnectionPoolImpl.class.getDeclaredMethod("recycle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = UniversalConnectionPoolImpl.class.getDeclaredMethod("refresh", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = UniversalConnectionPoolImpl.class.getDeclaredMethod("purge", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closePooledConnection", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closeConnection", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = UniversalConnectionPoolImpl.class.getDeclaredMethod("returnConnection", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = UniversalConnectionPoolImpl.class.getDeclaredMethod("createOnePooledConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = UniversalConnectionPoolImpl.class.getDeclaredMethod("updateConnectionWaitCounters", Boolean.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = UniversalConnectionPoolImpl.class.getDeclaredMethod("createOnePooledConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = UniversalConnectionPoolImpl.class.getDeclaredMethod("postBorrow", UniversalPooledConnection.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = UniversalConnectionPoolImpl.class.getDeclaredMethod("postBorrow", UniversalPooledConnection.class, Long.TYPE, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = UniversalConnectionPoolImpl.class.getDeclaredMethod("helpGrowBorrowed", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = UniversalConnectionPoolImpl.class.getDeclaredMethod("borrowConnectionWithoutCountingRequests", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = UniversalConnectionPoolImpl.class.getDeclaredMethod("isStillOkayToBorrow", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = UniversalConnectionPoolImpl.class.getDeclaredMethod("computeBorrowGiveUpTimestamp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = UniversalConnectionPoolImpl.class.getDeclaredMethod("setNoWaitBorrow", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = UniversalConnectionPoolImpl.class.getDeclaredMethod("borrowConnectionAndValidate", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = UniversalConnectionPoolImpl.class.getDeclaredMethod("borrowConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
    }

    private static final class UniversalConnectionPoolInternal {
        private final UniversalConnectionPoolImpl m_cp;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;

        private UniversalConnectionPoolInternal(UniversalConnectionPoolImpl cp) throws UniversalConnectionPoolException {
            assert (null != cp);
            this.m_cp = cp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UniversalPooledConnection createOnePooledConnectionInternal(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
            assert (cri != null);
            this.checkLifecycle();
            Object connection = null;
            UniversalPooledConnection pooledConnection = null;
            try {
                ConnectionFactoryAdapter cfa = this.m_cp.getConnectionFactoryAdapter();
                connection = cfa.createConnection(cri);
                if (null == connection) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(100);
                }
                pooledConnection = cfa.createPooledConnection(connection, cri.getCopyWithNoLabels());
                this.m_cp.incrementConnectionsCreatedCount();
                this.m_cp.m_cumulativeConnectionsCreated.incrementAndGet();
            }
            finally {
                if (null != connection && null == pooledConnection) {
                    this.m_cp.closePhysicalConnection(connection);
                }
            }
            return pooledConnection;
        }

        private void checkLifecycle() throws UniversalConnectionPoolException {
            if (this.m_cp.isLifecycleFailed() || this.m_cp.isLifecycleStopped()) {
                UCPErrorHandler.throwUniversalConnectionPoolException(60);
            }
        }

        private void discardUsedConnectionInternal(Object physicalConnection) {
            UniversalPooledConnection pooledConnection = this.m_cp.getUsedConnection(physicalConnection);
            if (null != pooledConnection) {
                this.m_cp.m_cumulativeConnectionUseTime.getAndAdd(Clock.clock() - this.m_cp.getUsedConnection(physicalConnection).getBorrowedStartTime());
                this.m_cp.core.retrieve(pooledConnection.getDelegator());
                this.m_cp.totalConnectionsCount.decrementAndGet();
                this.m_cp.borrowedConnectionsCount.decrementAndGet();
            }
        }

        private UniversalPooledConnection getUsedConnectionInternal(Object physicalConnection) {
            CoreConnection coreConn = this.m_cp.core.findSpecificConnection(physicalConnection);
            return null == coreConn ? null : (UniversalPooledConnection)coreConn.getDelegate();
        }

        private boolean returnUsedPhysicalConnectionInternal(Object physicalConnection) throws UniversalConnectionPoolException {
            UniversalPooledConnection pooledConnection = this.m_cp.getUsedConnection(physicalConnection);
            if (pooledConnection == null) {
                return false;
            }
            this.m_cp.returnConnection(pooledConnection);
            return true;
        }

        private boolean closeUsedPhysicalConnectionInternal(Object physicalConnection) throws UniversalConnectionPoolException {
            UniversalPooledConnection pooledConnection = this.m_cp.getUsedConnection(physicalConnection);
            if (pooledConnection == null) {
                return false;
            }
            this.m_cp.m_cumulativeConnectionUseTime.getAndAdd(Clock.clock() - pooledConnection.getBorrowedStartTime());
            CoreConnection conn = pooledConnection.getDelegator();
            if (this.m_cp.core.retrieve(conn)) {
                conn.abort();
                conn.close();
            }
            return true;
        }

        static {
            try {
                $$$methodRef$$$13 = UniversalConnectionPoolInternal.class.getDeclaredConstructor(UniversalConnectionPoolImpl.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$12 = UniversalConnectionPoolInternal.class.getDeclaredConstructor(UniversalConnectionPoolImpl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$11 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$600", UniversalConnectionPoolInternal.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$10 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$500", UniversalConnectionPoolInternal.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$9 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$400", UniversalConnectionPoolInternal.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$300", UniversalConnectionPoolInternal.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$200", UniversalConnectionPoolInternal.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$100", UniversalConnectionPoolInternal.class, ConnectionRetrievalInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = UniversalConnectionPoolInternal.class.getDeclaredMethod("closeUsedPhysicalConnectionInternal", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = UniversalConnectionPoolInternal.class.getDeclaredMethod("returnUsedPhysicalConnectionInternal", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = UniversalConnectionPoolInternal.class.getDeclaredMethod("getUsedConnectionInternal", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = UniversalConnectionPoolInternal.class.getDeclaredMethod("discardUsedConnectionInternal", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = UniversalConnectionPoolInternal.class.getDeclaredMethod("checkLifecycle", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = UniversalConnectionPoolInternal.class.getDeclaredMethod("createOnePooledConnectionInternal", ConnectionRetrievalInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

