/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.pool2.ObjectPool;

public class PoolingDriver
implements Driver {
    protected static final HashMap<String, ObjectPool<? extends Connection>> pools;
    private final boolean accessToUnderlyingConnectionAllowed;
    public static final String URL_PREFIX = "jdbc:apache:commons:dbcp:";
    protected static final int URL_PREFIX_LEN;
    protected static final int MAJOR_VERSION = 1;
    protected static final int MINOR_VERSION = 0;

    public PoolingDriver() {
        this(true);
    }

    protected PoolingDriver(boolean accessToUnderlyingConnectionAllowed) {
        this.accessToUnderlyingConnectionAllowed = accessToUnderlyingConnectionAllowed;
    }

    protected boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized ObjectPool<? extends Connection> getConnectionPool(String name) throws SQLException {
        ObjectPool<? extends Connection> pool = pools.get(name);
        if (null == pool) {
            throw new SQLException("Pool not registered: " + name);
        }
        return pool;
    }

    public synchronized void registerPool(String name, ObjectPool<? extends Connection> pool) {
        pools.put(name, pool);
    }

    public synchronized void closePool(String name) throws SQLException {
        ObjectPool<? extends Connection> pool = pools.get(name);
        if (pool != null) {
            pools.remove(name);
            try {
                pool.close();
            }
            catch (Exception e2) {
                throw new SQLException("Error closing pool " + name, e2);
            }
        }
    }

    public synchronized String[] getPoolNames() {
        Set<String> names = pools.keySet();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url == null ? false : url.startsWith(URL_PREFIX);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            ObjectPool<? extends Connection> pool = this.getConnectionPool(url.substring(URL_PREFIX_LEN));
            try {
                Connection conn = pool.borrowObject();
                if (conn == null) {
                    return null;
                }
                return new PoolGuardConnectionWrapper(pool, conn);
            }
            catch (SQLException e2) {
                throw e2;
            }
            catch (NoSuchElementException e3) {
                throw new SQLException("Cannot get a connection, pool error: " + e3.getMessage(), e3);
            }
            catch (RuntimeException e4) {
                throw e4;
            }
            catch (Exception e5) {
                throw new SQLException("Cannot get a connection, general error: " + e5.getMessage(), e5);
            }
        }
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public void invalidateConnection(Connection conn) throws SQLException {
        if (conn instanceof PoolGuardConnectionWrapper) {
            PoolGuardConnectionWrapper pgconn = (PoolGuardConnectionWrapper)conn;
            ObjectPool pool = pgconn.pool;
            try {
                pool.invalidateObject(pgconn.getDelegateInternal());
            }
            catch (Exception exception) {}
        } else {
            throw new SQLException("Invalid connection class");
        }
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    static {
        try {
            DriverManager.registerDriver(new PoolingDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
        pools = new HashMap();
        URL_PREFIX_LEN = URL_PREFIX.length();
    }

    private class PoolGuardConnectionWrapper
    extends DelegatingConnection<Connection> {
        private final ObjectPool<? extends Connection> pool;

        PoolGuardConnectionWrapper(ObjectPool<? extends Connection> pool, Connection delegate) {
            super(delegate);
            this.pool = pool;
        }

        @Override
        public Connection getDelegate() {
            if (PoolingDriver.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getDelegate();
            }
            return null;
        }

        @Override
        public Connection getInnermostDelegate() {
            if (PoolingDriver.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getInnermostDelegate();
            }
            return null;
        }
    }
}

