/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.Task;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;

@DefaultLogger(value="oracle.ucp.util")
public class UCPTaskManagerImpl
implements TaskManager {
    public static final int THREAD_POOL_MAX_SIZE = 24;
    public static final int THREAD_POOL_CORE_SIZE = 4;
    public static final int THREAD_POOL_QUEUE_SIZE = 4;
    public static final int THREAD_POOL_KEEP_ALIVE_TIME = 180;
    private ExecutorService wtp = null;
    private final List<Thread> criticalThreads = Collections.synchronizedList(new ArrayList());
    private static AtomicInteger numCreatedCriticalThreads;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    @Override
    public synchronized void start() {
        if (null != this.wtp) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Object run() {
                    ThreadFactory tf = new ThreadFactory(){
                        private final AtomicInteger numCreatedThreads = new AtomicInteger(0);
                        private static final String THREAD_NAME_PREFIX = "UCP-worker-thread-";
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;

                        @Override
                        public Thread newThread(Runnable r2) {
                            Thread newT = new Thread(null, r2, THREAD_NAME_PREFIX + this.numCreatedThreads.incrementAndGet());
                            newT.setPriority(5);
                            newT.setDaemon(true);
                            return newT;
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredConstructor(1.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("newThread", Runnable.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        }
                    };
                    UCPTaskManagerImpl.this.wtp = new UCPThreadPoolExecutor(4, 24, 180L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(4), tf, UCPTaskManagerImpl.this.getUCPTaskRejectionHandler());
                    return null;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(UCPTaskManagerImpl.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException e2) {
            ClioSupport.ilogThrowing(null, null, null, null, e2);
        }
    }

    @Override
    public synchronized boolean isRunning() {
        return null != this.wtp;
    }

    @Override
    public synchronized void stop() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    if (null != UCPTaskManagerImpl.this.wtp) {
                        UCPTaskManagerImpl.this.wtp.shutdown();
                        UCPTaskManagerImpl.this.wtp = null;
                    }
                    List list = UCPTaskManagerImpl.this.criticalThreads;
                    synchronized (list) {
                        for (Thread thread : UCPTaskManagerImpl.this.criticalThreads) {
                            if (!thread.isAlive()) continue;
                            thread.interrupt();
                        }
                        UCPTaskManagerImpl.this.criticalThreads.clear();
                    }
                    return null;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredConstructor(UCPTaskManagerImpl.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException e2) {
            ClioSupport.ilogThrowing(null, null, null, null, e2);
        }
    }

    @Override
    public <T> TaskHandle<T> submitTask(Task<T> task) {
        if (null == this.wtp) {
            ClioSupport.ilogFinest(null, null, null, null, "wtp not started");
            return null;
        }
        if (!(task instanceof UCPTaskBase)) {
            ClioSupport.ilogFinest(null, null, null, null, "wrong task object");
            return null;
        }
        UCPTaskBase ucpTask = (UCPTaskBase)task;
        TaskHandle<T> handle = null;
        handle = ucpTask.isCritical() ? this.submitToDedicatedThread(ucpTask) : this.submitToWTP(ucpTask);
        return handle;
    }

    public <T> TaskHandle<T> submitToDedicatedThread(final Task<T> task) {
        ((UCPTaskBase)task).setFuture(null);
        final Thread newCriticalThread = new Thread("UCP-CriticalTaskExecutorThread-" + numCreatedCriticalThreads.incrementAndGet()){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void run() {
                try {
                    task.call();
                }
                catch (Exception e2) {
                    ClioSupport.ilogWarning(null, null, null, null, "Exception during executing task: " + task + "in a dedicated thread" + e2.getMessage());
                }
            }

            static {
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredConstructor(UCPTaskManagerImpl.class, String.class, Task.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        newCriticalThread.setDaemon(true);
        newCriticalThread.start();
        this.criticalThreads.add(newCriticalThread);
        return new TaskHandle<T>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public T get(long timeout) throws TaskManagerException {
                try {
                    if (((UCPTaskBase)task).isCancelled()) {
                        newCriticalThread.interrupt();
                    } else if (timeout == 0L) {
                        newCriticalThread.join();
                    } else {
                        newCriticalThread.join(timeout);
                    }
                    if (!newCriticalThread.isAlive()) {
                        UCPTaskManagerImpl.this.criticalThreads.remove(newCriticalThread);
                    }
                    return null;
                }
                catch (Exception e2) {
                    throw new TaskManagerException(e2);
                }
            }

            @Override
            public Task<T> getTask() {
                return task;
            }

            static {
                try {
                    $$$methodRef$$$2 = 4.class.getDeclaredConstructor(UCPTaskManagerImpl.class, Task.class, Thread.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredMethod("getTask", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("get", Long.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public <T> TaskHandle<T> submitToWTP(final Task<T> task) {
        final Future<T> future = this.wtp.submit(task);
        ((UCPTaskBase)task).setFuture(future);
        return new TaskHandle<T>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public T get(long timeout) throws TaskManagerException {
                try {
                    if (timeout == 0L) {
                        return future.get();
                    }
                    return future.get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (Exception e2) {
                    throw new TaskManagerException(e2);
                }
            }

            @Override
            public Task<T> getTask() {
                return task;
            }

            static {
                try {
                    $$$methodRef$$$2 = 5.class.getDeclaredConstructor(UCPTaskManagerImpl.class, Future.class, Task.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 5.class.getDeclaredMethod("getTask", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 5.class.getDeclaredMethod("get", Long.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public ExecutorService getUCPThreadPool() {
        return this.wtp;
    }

    protected RejectedExecutionHandler getUCPTaskRejectionHandler() {
        return new UCPTaskRejectionHandler();
    }

    static {
        try {
            $$$methodRef$$$11 = UCPTaskManagerImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$10 = UCPTaskManagerImpl.class.getDeclaredMethod("access$100", UCPTaskManagerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$9 = UCPTaskManagerImpl.class.getDeclaredMethod("access$000", UCPTaskManagerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$8 = UCPTaskManagerImpl.class.getDeclaredMethod("access$002", UCPTaskManagerImpl.class, ExecutorService.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$7 = UCPTaskManagerImpl.class.getDeclaredMethod("getUCPTaskRejectionHandler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$6 = UCPTaskManagerImpl.class.getDeclaredMethod("getUCPThreadPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$5 = UCPTaskManagerImpl.class.getDeclaredMethod("submitToWTP", Task.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$4 = UCPTaskManagerImpl.class.getDeclaredMethod("submitToDedicatedThread", Task.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$3 = UCPTaskManagerImpl.class.getDeclaredMethod("submitTask", Task.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$2 = UCPTaskManagerImpl.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$1 = UCPTaskManagerImpl.class.getDeclaredMethod("isRunning", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$0 = UCPTaskManagerImpl.class.getDeclaredMethod("start", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        numCreatedCriticalThreads = new AtomicInteger(0);
    }

    final class UCPFutureTask<T>
    extends FutureTask<T> {
        private UCPTaskBase<T> ucpTask;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        public UCPFutureTask(Callable<T> callable) {
            super(callable);
            this.ucpTask = (UCPTaskBase)callable;
        }

        public UCPTaskBase<T> getUCPTask() {
            return this.ucpTask;
        }

        static {
            try {
                $$$methodRef$$$1 = UCPFutureTask.class.getDeclaredConstructor(UCPTaskManagerImpl.class, Callable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = UCPFutureTask.class.getDeclaredMethod("getUCPTask", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    final class UCPThreadPoolExecutor
    extends ThreadPoolExecutor {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        public UCPThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory tf, RejectedExecutionHandler rejectionHandler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, tf, rejectionHandler);
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            return new UCPFutureTask<T>(callable);
        }

        static {
            try {
                $$$methodRef$$$1 = UCPThreadPoolExecutor.class.getDeclaredConstructor(UCPTaskManagerImpl.class, Integer.TYPE, Integer.TYPE, Long.TYPE, TimeUnit.class, BlockingQueue.class, ThreadFactory.class, RejectedExecutionHandler.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = UCPThreadPoolExecutor.class.getDeclaredMethod("newTaskFor", Callable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    class UCPTaskRejectionHandler
    extends ThreadPoolExecutor.CallerRunsPolicy {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        UCPTaskRejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            UCPFutureTask ucpFutureTask;
            UCPTaskBase ucpRejectedTask;
            if (runnable instanceof UCPFutureTask && (ucpRejectedTask = (ucpFutureTask = (UCPFutureTask)runnable).getUCPTask()).isCritical()) {
                throw new RejectedExecutionException("Failed to execute Critical UCP Task: " + ucpRejectedTask + ", Hence Need to terminate process");
            }
            super.rejectedExecution(runnable, executor);
        }

        static {
            try {
                $$$methodRef$$$1 = UCPTaskRejectionHandler.class.getDeclaredConstructor(UCPTaskManagerImpl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = UCPTaskRejectionHandler.class.getDeclaredMethod("rejectedExecution", Runnable.class, ThreadPoolExecutor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

