/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj;

import com.mysql.cj.AbstractQueryBindings;
import com.mysql.cj.BindValue;
import com.mysql.cj.CharsetMapping;
import com.mysql.cj.ClientPreparedQueryBindValue;
import com.mysql.cj.Messages;
import com.mysql.cj.MysqlType;
import com.mysql.cj.NativeSession;
import com.mysql.cj.Session;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.util.StringUtils;
import com.mysql.cj.util.TimeUtil;
import com.mysql.cj.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ClientPreparedQueryBindings
extends AbstractQueryBindings<ClientPreparedQueryBindValue> {
    private CharsetEncoder charsetEncoder;
    private SimpleDateFormat ddf;
    private SimpleDateFormat tdf;
    private SimpleDateFormat tsdf = null;

    public ClientPreparedQueryBindings(int parameterCount, Session sess) {
        super(parameterCount, sess);
        if (((NativeSession)this.session).getRequiresEscapingEncoder()) {
            this.charsetEncoder = Charset.forName(this.charEncoding).newEncoder();
        }
    }

    @Override
    protected void initBindValues(int parameterCount) {
        this.bindValues = new ClientPreparedQueryBindValue[parameterCount];
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            ((ClientPreparedQueryBindValue[])this.bindValues)[i2] = new ClientPreparedQueryBindValue();
        }
    }

    @Override
    public ClientPreparedQueryBindings clone() {
        ClientPreparedQueryBindings newBindings = new ClientPreparedQueryBindings(((ClientPreparedQueryBindValue[])this.bindValues).length, this.session);
        BindValue[] bvs = new ClientPreparedQueryBindValue[((ClientPreparedQueryBindValue[])this.bindValues).length];
        for (int i2 = 0; i2 < ((ClientPreparedQueryBindValue[])this.bindValues).length; ++i2) {
            bvs[i2] = ((ClientPreparedQueryBindValue[])this.bindValues)[i2].clone();
        }
        newBindings.setBindValues(bvs);
        newBindings.isLoadDataQuery = this.isLoadDataQuery;
        return newBindings;
    }

    @Override
    public void checkParameterSet(int columnIndex) {
        if (!((ClientPreparedQueryBindValue[])this.bindValues)[columnIndex].isSet()) {
            throw ExceptionFactory.createException(Messages.getString("PreparedStatement.40") + (columnIndex + 1), "07001", 0, true, null, this.session.getExceptionInterceptor());
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2) {
        this.setAsciiStream(parameterIndex, x2, -1);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2, int length) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            this.setBinaryStream(parameterIndex, x2, length);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2, long length) {
        this.setAsciiStream(parameterIndex, x2, (int)length);
        ((ClientPreparedQueryBindValue[])this.bindValues)[parameterIndex].setMysqlType(MysqlType.TEXT);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x2) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            this.setValue(parameterIndex, StringUtils.fixDecimalExponent(x2.toPlainString()), MysqlType.DECIMAL);
        }
    }

    @Override
    public void setBigInteger(int parameterIndex, BigInteger x2) {
        this.setValue(parameterIndex, x2.toString(), MysqlType.BIGINT_UNSIGNED);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2) {
        this.setBinaryStream(parameterIndex, x2, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2, int length) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            ((ClientPreparedQueryBindValue[])this.bindValues)[parameterIndex].setNull(false);
            ((ClientPreparedQueryBindValue[])this.bindValues)[parameterIndex].setIsStream(true);
            ((ClientPreparedQueryBindValue[])this.bindValues)[parameterIndex].setMysqlType(MysqlType.BLOB);
            ((ClientPreparedQueryBindValue[])this.bindValues)[parameterIndex].setStreamValue(x2, length);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2, long length) {
        this.setBinaryStream(parameterIndex, x2, (int)length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) {
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) {
        this.setBinaryStream(parameterIndex, inputStream, (int)length);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x2) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            try {
                this.setBinaryStream(parameterIndex, x2.getBinaryStream());
            }
            catch (Throwable t2) {
                throw ExceptionFactory.createException(t2.getMessage(), t2, this.session.getExceptionInterceptor());
            }
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x2) {
        this.setValue(parameterIndex, x2 ? "1" : "0", MysqlType.BOOLEAN);
    }

    @Override
    public void setByte(int parameterIndex, byte x2) {
        this.setValue(parameterIndex, String.valueOf(x2), MysqlType.TINYINT);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x2) {
        this.setBytes(parameterIndex, x2, true, true);
        if (x2 != null) {
            ((ClientPreparedQueryBindValue[])this.bindValues)[parameterIndex].setMysqlType(MysqlType.BINARY);
        }
    }

    @Override
    public synchronized void setBytes(int parameterIndex, byte[] x2, boolean checkForIntroducer, boolean escapeForMBChars) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            if (this.session.getServerSession().isNoBackslashEscapesSet() || escapeForMBChars && CharsetMapping.isMultibyteCharset(this.charEncoding)) {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream(x2.length * 2 + 3);
                bOut.write(120);
                bOut.write(39);
                for (int i2 = 0; i2 < x2.length; ++i2) {
                    int lowBits = (x2[i2] & 0xFF) / 16;
                    int highBits = (x2[i2] & 0xFF) % 16;
                    bOut.write(HEX_DIGITS[lowBits]);
                    bOut.write(HEX_DIGITS[highBits]);
                }
                bOut.write(39);
                this.setValue(parameterIndex, bOut.toByteArray(), MysqlType.BINARY);
                this.setOrigValue(parameterIndex, x2);
                return;
            }
            int numBytes = x2.length;
            int pad = 2;
            if (checkForIntroducer) {
                pad += 7;
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(numBytes + pad);
            if (checkForIntroducer) {
                bOut.write(95);
                bOut.write(98);
                bOut.write(105);
                bOut.write(110);
                bOut.write(97);
                bOut.write(114);
                bOut.write(121);
            }
            bOut.write(39);
            block10: for (int i3 = 0; i3 < numBytes; ++i3) {
                byte b2 = x2[i3];
                switch (b2) {
                    case 0: {
                        bOut.write(92);
                        bOut.write(48);
                        continue block10;
                    }
                    case 10: {
                        bOut.write(92);
                        bOut.write(110);
                        continue block10;
                    }
                    case 13: {
                        bOut.write(92);
                        bOut.write(114);
                        continue block10;
                    }
                    case 92: {
                        bOut.write(92);
                        bOut.write(92);
                        continue block10;
                    }
                    case 39: {
                        bOut.write(92);
                        bOut.write(39);
                        continue block10;
                    }
                    case 34: {
                        bOut.write(92);
                        bOut.write(34);
                        continue block10;
                    }
                    case 26: {
                        bOut.write(92);
                        bOut.write(90);
                        continue block10;
                    }
                    default: {
                        bOut.write(b2);
                    }
                }
            }
            bOut.write(39);
            this.setValue(parameterIndex, bOut.toByteArray(), MysqlType.BINARY);
        }
    }

    @Override
    public void setBytesNoEscape(int parameterIndex, byte[] parameterAsBytes) {
        byte[] parameterWithQuotes = StringUtils.quoteBytes(parameterAsBytes);
        this.setValue(parameterIndex, parameterWithQuotes, MysqlType.BINARY);
    }

    @Override
    public void setBytesNoEscapeNoQuotes(int parameterIndex, byte[] parameterAsBytes) {
        this.setValue(parameterIndex, parameterAsBytes, MysqlType.BINARY);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) {
        this.setCharacterStream(parameterIndex, reader, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) {
        try {
            if (reader == null) {
                this.setNull(parameterIndex);
            } else {
                char[] c2 = null;
                int len = 0;
                boolean useLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue();
                String forcedEncoding = this.session.getPropertySet().getStringProperty(PropertyKey.clobCharacterEncoding).getStringValue();
                if (useLength && length != -1) {
                    c2 = new char[length];
                    int numCharsRead = Util.readFully(reader, c2, length);
                    if (forcedEncoding == null) {
                        this.setString(parameterIndex, new String(c2, 0, numCharsRead));
                    } else {
                        this.setBytes(parameterIndex, StringUtils.getBytes(new String(c2, 0, numCharsRead), forcedEncoding));
                    }
                } else {
                    c2 = new char[4096];
                    StringBuilder buf = new StringBuilder();
                    while ((len = reader.read(c2)) != -1) {
                        buf.append(c2, 0, len);
                    }
                    if (forcedEncoding == null) {
                        this.setString(parameterIndex, buf.toString());
                    } else {
                        this.setBytes(parameterIndex, StringUtils.getBytes(buf.toString(), forcedEncoding));
                    }
                }
                ((ClientPreparedQueryBindValue[])this.bindValues)[parameterIndex].setMysqlType(MysqlType.TEXT);
            }
        }
        catch (UnsupportedEncodingException uec) {
            throw ExceptionFactory.createException(WrongArgumentException.class, uec.toString(), uec, this.session.getExceptionInterceptor());
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createException(ioEx.toString(), ioEx, this.session.getExceptionInterceptor());
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) {
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int i2, Clob x2) {
        if (x2 == null) {
            this.setNull(i2);
        } else {
            try {
                String forcedEncoding = this.session.getPropertySet().getStringProperty(PropertyKey.clobCharacterEncoding).getStringValue();
                if (forcedEncoding == null) {
                    this.setString(i2, x2.getSubString(1L, (int)x2.length()));
                } else {
                    this.setBytes(i2, StringUtils.getBytes(x2.getSubString(1L, (int)x2.length()), forcedEncoding));
                }
                ((ClientPreparedQueryBindValue[])this.bindValues)[i2].setMysqlType(MysqlType.TEXT);
            }
            catch (Throwable t2) {
                throw ExceptionFactory.createException(t2.getMessage(), t2);
            }
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x2) {
        this.setDate(parameterIndex, x2, null);
    }

    @Override
    public void setDate(int parameterIndex, Date x2, Calendar cal) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            this.ddf = TimeUtil.getSimpleDateFormat(this.ddf, "''yyyy-MM-dd''", cal, cal != null ? null : this.session.getServerSession().getDefaultTimeZone());
            this.setValue(parameterIndex, this.ddf.format(x2), MysqlType.DATE);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x2) {
        if (!this.session.getPropertySet().getBooleanProperty(PropertyKey.allowNanAndInf).getValue().booleanValue() && (x2 == Double.POSITIVE_INFINITY || x2 == Double.NEGATIVE_INFINITY || Double.isNaN(x2))) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.64", new Object[]{x2}), this.session.getExceptionInterceptor());
        }
        this.setValue(parameterIndex, StringUtils.fixDecimalExponent(String.valueOf(x2)), MysqlType.DOUBLE);
    }

    @Override
    public void setFloat(int parameterIndex, float x2) {
        this.setValue(parameterIndex, StringUtils.fixDecimalExponent(String.valueOf(x2)), MysqlType.FLOAT);
    }

    @Override
    public void setInt(int parameterIndex, int x2) {
        this.setValue(parameterIndex, String.valueOf(x2), MysqlType.INT);
    }

    @Override
    public void setLong(int parameterIndex, long x2) {
        this.setValue(parameterIndex, String.valueOf(x2), MysqlType.BIGINT);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) {
        this.setNCharacterStream(parameterIndex, value, -1L);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long length) {
        if (reader == null) {
            this.setNull(parameterIndex);
        } else {
            try {
                char[] c2 = null;
                int len = 0;
                boolean useLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue();
                if (useLength && length != -1L) {
                    c2 = new char[(int)length];
                    int numCharsRead = Util.readFully(reader, c2, (int)length);
                    this.setNString(parameterIndex, new String(c2, 0, numCharsRead));
                } else {
                    c2 = new char[4096];
                    StringBuilder buf = new StringBuilder();
                    while ((len = reader.read(c2)) != -1) {
                        buf.append(c2, 0, len);
                    }
                    this.setNString(parameterIndex, buf.toString());
                }
                ((ClientPreparedQueryBindValue[])this.bindValues)[parameterIndex].setMysqlType(MysqlType.TEXT);
            }
            catch (Throwable t2) {
                throw ExceptionFactory.createException(t2.getMessage(), t2, this.session.getExceptionInterceptor());
            }
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) {
        this.setNCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) {
        if (reader == null) {
            this.setNull(parameterIndex);
        } else {
            this.setNCharacterStream(parameterIndex, reader, length);
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) {
        if (value == null) {
            this.setNull(parameterIndex);
        } else {
            try {
                this.setNCharacterStream(parameterIndex, value.getCharacterStream(), value.length());
            }
            catch (Throwable t2) {
                throw ExceptionFactory.createException(t2.getMessage(), t2, this.session.getExceptionInterceptor());
            }
        }
    }

    @Override
    public void setNString(int parameterIndex, String x2) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            if (this.charEncoding.equalsIgnoreCase("UTF-8") || this.charEncoding.equalsIgnoreCase("utf8")) {
                this.setString(parameterIndex, x2);
                return;
            }
            int stringLength = x2.length();
            StringBuilder buf = new StringBuilder((int)((double)x2.length() * 1.1 + 4.0));
            buf.append("_utf8");
            buf.append('\'');
            block9: for (int i2 = 0; i2 < stringLength; ++i2) {
                char c2 = x2.charAt(i2);
                switch (c2) {
                    case '\u0000': {
                        buf.append('\\');
                        buf.append('0');
                        continue block9;
                    }
                    case '\n': {
                        buf.append('\\');
                        buf.append('n');
                        continue block9;
                    }
                    case '\r': {
                        buf.append('\\');
                        buf.append('r');
                        continue block9;
                    }
                    case '\\': {
                        buf.append('\\');
                        buf.append('\\');
                        continue block9;
                    }
                    case '\'': {
                        buf.append('\\');
                        buf.append('\'');
                        continue block9;
                    }
                    case '\"': {
                        if (this.session.getServerSession().useAnsiQuotedIdentifiers()) {
                            buf.append('\\');
                        }
                        buf.append('\"');
                        continue block9;
                    }
                    case '\u001a': {
                        buf.append('\\');
                        buf.append('Z');
                        continue block9;
                    }
                    default: {
                        buf.append(c2);
                    }
                }
            }
            buf.append('\'');
            byte[] parameterAsBytes = this.isLoadDataQuery ? StringUtils.getBytes(buf.toString()) : StringUtils.getBytes(buf.toString(), "UTF-8");
            this.setValue(parameterIndex, parameterAsBytes, MysqlType.VARCHAR);
        }
    }

    @Override
    public synchronized void setNull(int parameterIndex) {
        this.setValue(parameterIndex, "null", MysqlType.NULL);
        ((ClientPreparedQueryBindValue[])this.bindValues)[parameterIndex].setNull(true);
    }

    @Override
    public void setShort(int parameterIndex, short x2) {
        this.setValue(parameterIndex, String.valueOf(x2), MysqlType.SMALLINT);
    }

    @Override
    public void setString(int parameterIndex, String x2) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            int stringLength = x2.length();
            if (this.session.getServerSession().isNoBackslashEscapesSet()) {
                boolean needsHexEscape = this.isEscapeNeededForString(x2, stringLength);
                if (!needsHexEscape) {
                    StringBuilder quotedString = new StringBuilder(x2.length() + 2);
                    quotedString.append('\'');
                    quotedString.append(x2);
                    quotedString.append('\'');
                    byte[] parameterAsBytes = this.isLoadDataQuery ? StringUtils.getBytes(quotedString.toString()) : StringUtils.getBytes(quotedString.toString(), this.charEncoding);
                    this.setValue(parameterIndex, parameterAsBytes, MysqlType.VARCHAR);
                } else {
                    byte[] parameterAsBytes = this.isLoadDataQuery ? StringUtils.getBytes(x2) : StringUtils.getBytes(x2, this.charEncoding);
                    this.setBytes(parameterIndex, parameterAsBytes);
                }
                return;
            }
            String parameterAsString = x2;
            boolean needsQuoted = true;
            if (this.isLoadDataQuery || this.isEscapeNeededForString(x2, stringLength)) {
                needsQuoted = false;
                StringBuilder buf = new StringBuilder((int)((double)x2.length() * 1.1));
                buf.append('\'');
                block10: for (int i2 = 0; i2 < stringLength; ++i2) {
                    char c2 = x2.charAt(i2);
                    switch (c2) {
                        case '\u0000': {
                            buf.append('\\');
                            buf.append('0');
                            continue block10;
                        }
                        case '\n': {
                            buf.append('\\');
                            buf.append('n');
                            continue block10;
                        }
                        case '\r': {
                            buf.append('\\');
                            buf.append('r');
                            continue block10;
                        }
                        case '\\': {
                            buf.append('\\');
                            buf.append('\\');
                            continue block10;
                        }
                        case '\'': {
                            buf.append('\'');
                            buf.append('\'');
                            continue block10;
                        }
                        case '\"': {
                            if (this.session.getServerSession().useAnsiQuotedIdentifiers()) {
                                buf.append('\\');
                            }
                            buf.append('\"');
                            continue block10;
                        }
                        case '\u001a': {
                            buf.append('\\');
                            buf.append('Z');
                            continue block10;
                        }
                        case '\u00a5': 
                        case '\u20a9': {
                            if (this.charsetEncoder != null) {
                                CharBuffer cbuf = CharBuffer.allocate(1);
                                ByteBuffer bbuf = ByteBuffer.allocate(1);
                                cbuf.put(c2);
                                cbuf.position(0);
                                this.charsetEncoder.encode(cbuf, bbuf, true);
                                if (bbuf.get(0) == 92) {
                                    buf.append('\\');
                                }
                            }
                            buf.append(c2);
                            continue block10;
                        }
                        default: {
                            buf.append(c2);
                        }
                    }
                }
                buf.append('\'');
                parameterAsString = buf.toString();
            }
            byte[] parameterAsBytes = this.isLoadDataQuery ? StringUtils.getBytes(parameterAsString) : (needsQuoted ? StringUtils.getBytesWrapped(parameterAsString, '\'', '\'', this.charEncoding) : StringUtils.getBytes(parameterAsString, this.charEncoding));
            this.setValue(parameterIndex, parameterAsBytes, MysqlType.VARCHAR);
        }
    }

    private boolean isEscapeNeededForString(String x2, int stringLength) {
        boolean needsHexEscape = false;
        for (int i2 = 0; i2 < stringLength; ++i2) {
            char c2 = x2.charAt(i2);
            switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': 
                case '\u001a': 
                case '\"': 
                case '\'': 
                case '\\': {
                    needsHexEscape = true;
                }
            }
            if (needsHexEscape) break;
        }
        return needsHexEscape;
    }

    @Override
    public void setTime(int parameterIndex, Time x2, Calendar cal) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            this.tdf = TimeUtil.getSimpleDateFormat(this.tdf, "''HH:mm:ss''", cal, cal != null ? null : this.session.getServerSession().getDefaultTimeZone());
            this.setValue(parameterIndex, this.tdf.format(x2), MysqlType.TIME);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x2) {
        this.setTime(parameterIndex, x2, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2) {
        int fractLen = -1;
        if (!((Boolean)this.sendFractionalSeconds.getValue()).booleanValue() || !this.session.getServerSession().getCapabilities().serverSupportsFracSecs()) {
            fractLen = 0;
        } else if (this.columnDefinition != null && parameterIndex <= this.columnDefinition.getFields().length && parameterIndex >= 0) {
            fractLen = this.columnDefinition.getFields()[parameterIndex].getDecimals();
        }
        this.setTimestamp(parameterIndex, x2, null, fractLen);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) {
        int fractLen = -1;
        if (!((Boolean)this.sendFractionalSeconds.getValue()).booleanValue() || !this.session.getServerSession().getCapabilities().serverSupportsFracSecs()) {
            fractLen = 0;
        } else if (this.columnDefinition != null && parameterIndex <= this.columnDefinition.getFields().length && parameterIndex >= 0 && this.columnDefinition.getFields()[parameterIndex].getDecimals() > 0) {
            fractLen = this.columnDefinition.getFields()[parameterIndex].getDecimals();
        }
        this.setTimestamp(parameterIndex, x2, cal, fractLen);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar targetCalendar, int fractionalLength) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            x2 = (Timestamp)x2.clone();
            if (!this.session.getServerSession().getCapabilities().serverSupportsFracSecs() || !((Boolean)this.sendFractionalSeconds.getValue()).booleanValue() && fractionalLength == 0) {
                x2 = TimeUtil.truncateFractionalSeconds(x2);
            }
            if (fractionalLength < 0) {
                fractionalLength = 6;
            }
            x2 = TimeUtil.adjustTimestampNanosPrecision(x2, fractionalLength, !this.session.getServerSession().isServerTruncatesFracSecs());
            this.tsdf = TimeUtil.getSimpleDateFormat(this.tsdf, "''yyyy-MM-dd HH:mm:ss", targetCalendar, targetCalendar != null ? null : this.session.getServerSession().getDefaultTimeZone());
            StringBuffer buf = new StringBuffer();
            buf.append(this.tsdf.format(x2));
            if (this.session.getServerSession().getCapabilities().serverSupportsFracSecs()) {
                buf.append('.');
                buf.append(TimeUtil.formatNanos(x2.getNanos(), 6));
            }
            buf.append('\'');
            this.setValue(parameterIndex, buf.toString(), MysqlType.TIMESTAMP);
        }
    }
}

