/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.scanner;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.Location;
import org.flywaydb.core.internal.util.scanner.Resource;
import org.flywaydb.core.internal.util.scanner.android.AndroidScanner;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathScanner;
import org.flywaydb.core.internal.util.scanner.filesystem.FileSystemScanner;

public class Scanner {
    private final ClassLoader classLoader;

    public Scanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Resource[] scanForResources(Location location, String prefix, String suffix) {
        try {
            if (location.isFileSystem()) {
                return new FileSystemScanner().scanForResources(location.getPath(), prefix, suffix);
            }
            if (new FeatureDetector(this.classLoader).isAndroidAvailable()) {
                return new AndroidScanner(this.classLoader).scanForResources(location.getPath(), prefix, suffix);
            }
            return new ClassPathScanner(this.classLoader).scanForResources(location.getPath(), prefix, suffix);
        }
        catch (Exception e2) {
            throw new FlywayException("Unable to scan for SQL migrations in location: " + location, e2);
        }
    }

    public Class<?>[] scanForClasses(Location location, Class<?> implementedInterface) throws Exception {
        if (new FeatureDetector(this.classLoader).isAndroidAvailable()) {
            return new AndroidScanner(this.classLoader).scanForClasses(location.getPath(), implementedInterface);
        }
        return new ClassPathScanner(this.classLoader).scanForClasses(location.getPath(), implementedInterface);
    }
}

