/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.proposalpersons;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;
import org.kuali.coeus.dc.proposalpersons.ProposalPersonsDao;

public class ProposalPersonsDaoImpl
implements ProposalPersonsDao {
    public static final String SELECT_PROPOSAL_PERSONS = "select proposal_person_id, person_id, full_name, rolodex_id from proposal_persons";
    public static final String SELECT_NAMES = "select n.first_nm, n.middle_nm, n.last_nm from krim_entity_nm_t as n, krim_prncpl_t as p where p.prncpl_id = ? and p.entity_id = n.entity_id";
    public static final String SELECT_ROLODEX_NAMES = "select first_name, middle_name, last_name, prefix from rolodex where rolodex_id = ?";
    public static final String UPDATE_PROPOSAL_PERSON = "update proposal_persons set full_name = ? where proposal_person_id = ?";
    private static final Logger LOG = Logger.getLogger(ProposalPersonsDaoImpl.class.getName());
    private ConnectionDaoService connectionDaoService;

    @Override
    public void fixFullNames() {
        Connection connection = this.connectionDaoService.getCoeusConnection();
        try (PreparedStatement selectProposalPersons = connection.prepareStatement(SELECT_PROPOSAL_PERSONS);
             PreparedStatement selectNames = connection.prepareStatement(SELECT_NAMES);
             PreparedStatement selectRolodexNames = connection.prepareStatement(SELECT_ROLODEX_NAMES);
             PreparedStatement updateProposalPerson = connection.prepareStatement(UPDATE_PROPOSAL_PERSON);){
            int updated = 0;
            ResultSet results = selectProposalPersons.executeQuery();
            while (results.next()) {
                String oldName = results.getString(3);
                String personId = results.getString(2);
                String rolodexId = results.getString(4);
                String newName = "";
                if (personId != null) {
                    newName = this.getPersonName(selectNames, personId);
                } else if (rolodexId != null) {
                    newName = this.getRolodexName(selectRolodexNames, rolodexId);
                }
                if (newName == null || newName.trim().isEmpty() || newName.equals(oldName)) continue;
                String proposalPersonId = results.getString(1);
                updateProposalPerson.setString(1, newName);
                updateProposalPerson.setString(2, proposalPersonId);
                updateProposalPerson.executeUpdate();
                LOG.info("Updating Proposal Person ID # " + proposalPersonId + " full name from '" + oldName + "' to '" + newName + "'");
                ++updated;
            }
            LOG.info("Proposal persons full name update complete: " + updated + " records updated");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPersonName(PreparedStatement selectNames, String personId) throws SQLException {
        selectNames.setString(1, personId);
        ResultSet names = selectNames.executeQuery();
        names.next();
        return this.getFullName(names.getString(1), names.getString(2), names.getString(3));
    }

    private String getRolodexName(PreparedStatement selectRolodexNames, String rolodexId) throws SQLException {
        selectRolodexNames.setString(1, rolodexId);
        ResultSet names = selectRolodexNames.executeQuery();
        names.next();
        return this.getRolodexFullName(names.getString(1), names.getString(2), names.getString(3), names.getString(4));
    }

    private String getFullName(String firstName, String middleName, String lastName) {
        middleName = middleName != null && !middleName.isEmpty() ? middleName + " " : "";
        return firstName + " " + middleName + lastName.trim();
    }

    private String getRolodexFullName(String firstName, String middleName, String lastName, String prefix) {
        StringBuilder name = new StringBuilder();
        if (lastName != null) {
            name.append(lastName);
            name.append(", ");
        }
        if (prefix != null) {
            name.append(prefix);
            name.append(" ");
        }
        if (firstName != null) {
            name.append(firstName);
            name.append(" ");
        }
        if (middleName != null) {
            name.append(middleName);
        }
        return name.length() > 0 ? name.toString() : null;
    }

    public ConnectionDaoService getConnectionDaoService() {
        return this.connectionDaoService;
    }

    public void setConnectionDaoService(ConnectionDaoService connectionDaoService) {
        this.connectionDaoService = connectionDaoService;
    }
}

