-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

drop PROCEDURE if exists p;

DELIMITER /
CREATE PROCEDURE p()
  BEGIN
    DECLARE DONE INT DEFAULT FALSE;
    DECLARE rateclasscode, rateTypeCode varchar(3);

    DECLARE CUR CURSOR FOR SELECT RATE_CLASS_CODE, RATE_TYPE_CODE FROM RATE_CLASS_BASE_INCLUSION WHERE RATE_TYPE_CODE IS NOT NULL 
    	AND (RATE_CLASS_CODE, RATE_TYPE_CODE) in (select RATE_CLASS_CODE, RATE_TYPE_CODE from RATE_TYPE)
    	AND (RATE_CLASS_CODE, RATE_TYPE_CODE) not in (select RATE_CLASS_CODE, RATE_TYPE_CODE from RATE_CLASS_BASE_EXCLUSION);
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET DONE = TRUE;

    OPEN CUR;

    read_loop: LOOP
      FETCH CUR INTO rateClassCode, rateTypeCode;
      IF DONE THEN
        LEAVE read_loop;
      END IF;

      INSERT INTO SEQ_RATE_CLASS_BASE_EXCL_ID VALUES (null);
      insert into RATE_CLASS_BASE_EXCLUSION (RATE_CLASS_BASE_EXCL_ID, RATE_CLASS_CODE, RATE_TYPE_CODE, RATE_CLASS_CODE_EXCL, RATE_TYPE_CODE_EXCL, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
      	values ((select max(ID) from SEQ_RATE_CLASS_BASE_EXCL_ID), rateClassCode, rateTypeCode, '0', null, NOW(), 'admin', 1, UUID());
    END LOOP;

    CLOSE CUR;
  END
/
DELIMITER ;
CALL p();

drop PROCEDURE if exists p;
