--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2015 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

DELIMITER /

DROP PROCEDURE IF EXISTS FIX_BUDGET_DETAILS_MODULAR_MODULAR_IDC
/

CREATE PROCEDURE FIX_BUDGET_DETAILS_MODULAR_MODULAR_IDC()
BEGIN
  DECLARE NO_MORE_RECORDS BOOLEAN DEFAULT FALSE;

  DECLARE V_BUDGET_ID DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD_NUMBER DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD DECIMAL(3,0);

  DECLARE RECORD_CUR CURSOR FOR
    SELECT BUDGET_ID, BUDGET_PERIOD_NUMBER, BUDGET_PERIOD FROM BUDGET_PERIODS;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_RECORDS = TRUE;

  OPEN RECORD_CUR;

  record_loop: LOOP
    FETCH RECORD_CUR INTO V_BUDGET_ID, V_BUDGET_PERIOD_NUMBER, V_BUDGET_PERIOD;
    IF NO_MORE_RECORDS THEN
      CLOSE RECORD_CUR;
      LEAVE record_loop;
    END IF;

    UPDATE BUDGET_DETAILS
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD
    WHERE BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER;

    UPDATE BUDGET_MODULAR
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD
    WHERE BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER;

    UPDATE BUDGET_MODULAR_IDC
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD
    WHERE BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER;

  END LOOP;

END
/

CALL FIX_BUDGET_DETAILS_MODULAR_MODULAR_IDC
/

DROP PROCEDURE IF EXISTS FIX_DETAILS_CAL_AMOUNTS_PERSONNEL_DETS
/

CREATE PROCEDURE FIX_DETAILS_CAL_AMOUNTS_PERSONNEL_DETS()
BEGIN
  DECLARE NO_MORE_RECORDS BOOLEAN DEFAULT FALSE;

  DECLARE V_BUDGET_ID DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD_NUMBER DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD DECIMAL(3,0);
  DECLARE V_BUDGET_DETAILS_ID DECIMAL(12,0);

  -- budget details was fixed above so we can query it for correct data
  DECLARE RECORD_CUR CURSOR FOR
    SELECT BUDGET_ID, BUDGET_PERIOD_NUMBER, BUDGET_PERIOD, BUDGET_DETAILS_ID FROM BUDGET_DETAILS;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_RECORDS = TRUE;

  OPEN RECORD_CUR;

  record_loop: LOOP
    FETCH RECORD_CUR INTO V_BUDGET_ID, V_BUDGET_PERIOD_NUMBER, V_BUDGET_PERIOD, V_BUDGET_DETAILS_ID;
    IF NO_MORE_RECORDS THEN
      CLOSE RECORD_CUR;
      LEAVE record_loop;
    END IF;

    UPDATE BUDGET_DETAILS_CAL_AMTS
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER
    WHERE BUDGET_DETAILS_ID = V_BUDGET_DETAILS_ID;

    UPDATE BUDGET_PERSONNEL_DETAILS
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER
    WHERE BUDGET_DETAILS_ID = V_BUDGET_DETAILS_ID;

  END LOOP;

END
/

CALL FIX_DETAILS_CAL_AMOUNTS_PERSONNEL_DETS
/

DROP PROCEDURE IF EXISTS FIX_BUDGET_PER_CAL_AMOUNTS_RAB
/

CREATE PROCEDURE FIX_BUDGET_PER_CAL_AMOUNTS_RAB()
BEGIN
  DECLARE NO_MORE_RECORDS BOOLEAN DEFAULT FALSE;

  DECLARE V_BUDGET_ID DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD_NUMBER DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD DECIMAL(3,0);
  DECLARE V_BUDGET_PERSONNEL_DETAILS_ID DECIMAL(12,0);

  -- budget personnel details was fixed above so we can query it for correct data
  DECLARE RECORD_CUR CURSOR FOR
    SELECT BUDGET_ID, BUDGET_PERIOD_NUMBER, BUDGET_PERIOD, BUDGET_PERSONNEL_DETAILS_ID FROM BUDGET_PERSONNEL_DETAILS;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_RECORDS = TRUE;

  OPEN RECORD_CUR;

  record_loop: LOOP
    FETCH RECORD_CUR INTO V_BUDGET_ID, V_BUDGET_PERIOD_NUMBER, V_BUDGET_PERIOD, V_BUDGET_PERSONNEL_DETAILS_ID;
    IF NO_MORE_RECORDS THEN
      CLOSE RECORD_CUR;
      LEAVE record_loop;
    END IF;

    UPDATE BUDGET_PERSONNEL_CAL_AMTS
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER
    WHERE BUDGET_PERSONNEL_DETAILS_ID = V_BUDGET_PERSONNEL_DETAILS_ID;

    UPDATE BUDGET_PER_DET_RATE_AND_BASE
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER
    WHERE BUDGET_PERSONNEL_DETAILS_ID = V_BUDGET_PERSONNEL_DETAILS_ID;

  END LOOP;

END
/

CALL FIX_BUDGET_PER_CAL_AMOUNTS_RAB
/

DELIMITER ;