--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

-- Development Proposal updates --

-- EPS_PROP_EXEMPT_NUMBER --

ALTER TABLE EPS_PROP_EXEMPT_NUMBER 
DROP CONSTRAINT FK_EPS_PROP_EXEMPT_NUMBER_KRA;

ALTER TABLE EPS_PROP_EXEMPT_NUMBER 
DROP CONSTRAINT EPS_PROP_EXEMPT_NUMBERP1;

ALTER TABLE EPS_PROP_EXEMPT_NUMBER 
ADD (PROPOSAL_EXEMPT_NUMBER_ID NUMBER(12, 0) NOT NULL,
	PROPOSAL_SPECIAL_REVIEW_ID NUMBER(12, 0) NOT NULL);


CREATE SEQUENCE SEQ_EPS_PROP_EXEMPT_NUMBER_ID INCREMENT BY 1 START WITH 1;

-- EPS_PROP_SPECIAL_REVIEW --

ALTER TABLE EPS_PROP_SPECIAL_REVIEW 
DROP CONSTRAINT EPS_PROP_SPECIAL_REVIEWP1;

ALTER TABLE EPS_PROP_SPECIAL_REVIEW 
ADD (PROPOSAL_SPECIAL_REVIEW_ID NUMBER(12, 0));

CREATE SEQUENCE SEQ_EPS_PROP_SPECIAL_REVIEW_ID INCREMENT BY 1 START WITH 1;

UPDATE EPS_PROP_SPECIAL_REVIEW 
SET PROPOSAL_SPECIAL_REVIEW_ID = SEQ_EPS_PROP_SPECIAL_REVIEW_ID.NEXTVAL;

UPDATE EPS_PROP_EXEMPT_NUMBER
SET PROPOSAL_EXEMPT_NUMBER_ID = SEQ_EPS_PROP_EXEMPT_NUMBER_ID.NEXTVAL;

UPDATE EPS_PROP_EXEMPT_NUMBER EN
SET (PROPOSAL_SPECIAL_REVIEW_ID) =
(SELECT PROPOSAL_SPECIAL_REVIEW_ID
FROM EPS_PROP_SPECIAL_REVIEW SR 
WHERE SR.PROPOSAL_NUMBER = EN.PROPOSAL_NUMBER
AND SR.SPECIAL_REVIEW_NUMBER = EN.SPECIAL_REVIEW_NUMBER);

ALTER TABLE EPS_PROP_SPECIAL_REVIEW 
MODIFY PROPOSAL_SPECIAL_REVIEW_ID NOT NULL;
	
ALTER TABLE EPS_PROP_SPECIAL_REVIEW
ADD CONSTRAINT EPS_PROP_SPECIAL_REVIEWP1 PRIMARY KEY (PROPOSAL_SPECIAL_REVIEW_ID);

ALTER TABLE EPS_PROP_EXEMPT_NUMBER
ADD CONSTRAINT EPS_PROP_EXEMPT_NUMBERP1 PRIMARY KEY (PROPOSAL_EXEMPT_NUMBER_ID);

ALTER TABLE EPS_PROP_EXEMPT_NUMBER
ADD CONSTRAINT FK_EPS_PROP_SPECIAL_REVIEW FOREIGN KEY (PROPOSAL_SPECIAL_REVIEW_ID)
REFERENCES EPS_PROP_SPECIAL_REVIEW (PROPOSAL_SPECIAL_REVIEW_ID);

ALTER TABLE EPS_PROP_EXEMPT_NUMBER 
DROP COLUMN PROPOSAL_NUMBER;

ALTER TABLE EPS_PROP_EXEMPT_NUMBER 
DROP COLUMN SPECIAL_REVIEW_NUMBER;

