/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.persistence.annotations.Customizer;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.joda.time.base.BaseDateTime;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.budget.framework.core.AbstractBudget;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.common.framework.custom.CustomDataContainer;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.krms.KcKrmsContextBo;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.framework.noo.NoticeOfOpportunity;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.person.PrincipalInvestigatorAware;
import org.kuali.coeus.common.framework.rolodex.PersonRolodex;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.sponsor.Sponsorable;
import org.kuali.coeus.common.framework.type.ActivityType;
import org.kuali.coeus.common.framework.type.DeadlineType;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.common.framework.type.ProposalType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.ynq.YnqGroupName;
import org.kuali.coeus.common.framework.ynq.YnqService;
import org.kuali.coeus.common.proposal.framework.mail.MailBy;
import org.kuali.coeus.common.proposal.framework.mail.MailType;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.impl.abstrct.ProposalAbstract;
import org.kuali.coeus.propdev.impl.attachment.LegacyNarrativeService;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetChangedData;
import org.kuali.coeus.propdev.impl.budget.standalone.ProposalStandaloneBudgetBo;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentService;
import org.kuali.coeus.propdev.impl.editable.ProposalChangedData;
import org.kuali.coeus.propdev.impl.gf.GrantForwardRecord;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyStatusConstants;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHiddenInHierarchyCustomizerValue;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyException;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.keyword.PropScienceKeyword;
import org.kuali.coeus.propdev.impl.location.CongressionalDistrict;
import org.kuali.coeus.propdev.impl.location.ProposalSite;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotification;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonDegree;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiographyService;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormBo;
import org.kuali.coeus.propdev.impl.s2s.S2sAppSubmission;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedForm;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.propdev.impl.s2s.nih.NihSubmissionAgencyDataService;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverride;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewExemption;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.coeus.propdev.impl.state.ProposalState;
import org.kuali.coeus.propdev.impl.ynq.ProposalYnq;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.CompositeDescriptorCustomizer;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.NsfCode;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.DocumentContract;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.jpa.FilterGenerator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.document.DocumentBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

@Entity
@Table(name="EPS_PROPOSAL")
@Customizer(value=DevelopmentProposalCustomizer.class)
public class DevelopmentProposal
extends KcPersistableBusinessObjectBase
implements BudgetParent,
Sponsorable,
KcKrmsContextBo,
CustomDataContainer,
DevelopmentProposalContract,
PrincipalInvestigatorAware {
    private static final long serialVersionUID = -9211313487776934111L;
    private static final Logger LOG = LogManager.getLogger(DevelopmentProposal.class);
    private static final String ATTACHMENTS_COMPLETE = "Complete";
    private static final String ATTACHMENTS_INCOMPLETE = "Inomplete";
    private static final String ATTACHMENTS_NONE = "None";
    private static final String ROLODEX = "rolodex";
    private static final String SELECT = "(select)";
    private static final String SPONSOR = "sponsor";
    private static final String PRIME_SPONSOR = "primeSponsor";
    private static final String PI = "PI";
    private static final String PROPOSAL = "Proposal";
    private static final String PROPOSAL_NUMBER = "PROPOSAL_NUMBER";
    private static final String NARRATIVE_TYPE = "narrativeType";
    private static final String NARRATIVE_TYPE_GROUP = "narrativeTypeGroup";
    @PortableSequenceGenerator(name="SEQ_PROPOSAL_NUMBER_KRA")
    @GeneratedValue(generator="SEQ_PROPOSAL_NUMBER_KRA")
    @Id
    @Column(name="PROPOSAL_NUMBER")
    private String proposalNumber;
    @Column(name="PROPOSAL_TYPE_CODE")
    private String proposalTypeCode;
    @Column(name="CONTINUED_FROM")
    private String continuedFrom;
    @Column(name="SPONSOR_CODE")
    private String sponsorCode;
    @Column(name="ACTIVITY_TYPE_CODE")
    private String activityTypeCode;
    @Column(name="OWNED_BY_UNIT")
    private String ownedByUnitNumber;
    @Column(name="REQUESTED_START_DATE_INITIAL")
    private Date requestedStartDateInitial;
    @Column(name="REQUESTED_END_DATE_INITIAL")
    private Date requestedEndDateInitial;
    @Column(name="TITLE")
    private String title;
    @Column(name="CURRENT_AWARD_NUMBER")
    private String currentAwardNumber;
    @Column(name="DEADLINE_DATE")
    private Date deadlineDate;
    @Column(name="DEADLINE_TIME")
    private String deadlineTime;
    @Column(name="NOTICE_OF_OPPORTUNITY_CODE")
    private String noticeOfOpportunityCode;
    @Column(name="DEADLINE_TYPE")
    private String deadlineType;
    @Column(name="ANTICIPATED_AWARD_TYPE_CODE")
    private Integer anticipatedAwardTypeCode;
    @Column(name="PROGRAM_ANNOUNCEMENT_NUMBER")
    private String programAnnouncementNumber;
    @Column(name="PRIME_SPONSOR_CODE")
    private String primeSponsorCode;
    @Column(name="SPONSOR_PROPOSAL_NUMBER")
    private String sponsorProposalNumber;
    @Column(name="NSF_SEQUENCE_NUMBER")
    private Integer nsfSequenceNumber;
    @Column(name="SUBCONTRACT_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean subcontracts;
    @Column(name="AGENCY_DIVISION_CODE")
    private String agencyDivisionCode;
    @Column(name="AGENCY_PROGRAM_CODE")
    private String agencyProgramCode;
    @Column(name="PROGRAM_ANNOUNCEMENT_TITLE")
    private String programAnnouncementTitle;
    @Column(name="MAIL_BY")
    private String mailBy;
    @Column(name="MAIL_TYPE")
    private String mailType;
    @Column(name="MAIL_ACCOUNT_NUMBER")
    private String mailAccountNumber;
    @Column(name="MAIL_DESCRIPTION")
    private String mailDescription;
    @Column(name="MAILING_ADDRESS_ID")
    private Integer mailingAddressId;
    @Column(name="NUMBER_OF_COPIES")
    private String numberOfCopies;
    @Column(name="STATUS_CODE")
    private String proposalStateTypeCode = "1";
    @Column(name="CREATION_STATUS_CODE")
    private String creationStatusCode;
    @Column(name="SUBMIT_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean submitFlag = Boolean.FALSE;
    @Column(name="IS_HIERARCHY")
    private String hierarchyStatus;
    @Column(name="HIERARCHY_ORIG_CHILD_PROP_NBR")
    private String hierarchyOriginatingChildProposalNumber;
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyParentProposalNumber;
    @Column(name="HIERARCHY_HASH_CODE")
    private Integer hierarchyLastSyncHashCode;
    @Column(name="HIERARCHY_BUDGET_TYPE")
    private String hierarchyBudgetType;
    @Column(name="PROPOSALNUMBER_GG")
    private String proposalNumberForGG;
    @Column(name="OPPORTUNITYID_GG")
    private String opportunityIdForGG;
    @Column(name="AGENCY_ROUTING_IDENTIFIER")
    private String agencyRoutingIdentifier;
    @Column(name="PREV_GG_TRACKID")
    private String prevGrantsGovTrackingID;
    @Column(name="CREATE_TIMESTAMP")
    private Timestamp createTimestamp;
    @Column(name="CREATE_USER")
    private String createUser;
    @Column(name="ASSIGNER_ID")
    private String assignerId;
    @Column(name="APPROVER_ID")
    private String approverId;
    @ManyToOne(targetEntity=DeadlineType.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="DEADLINE_TYPE", referencedColumnName="DEADLINE_TYPE_CODE", insertable=false, updatable=false)
    private DeadlineType deadlineTypeRef;
    @ManyToOne(targetEntity=ProposalType.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_TYPE_CODE", referencedColumnName="PROPOSAL_TYPE_CODE", insertable=false, updatable=false)
    private ProposalType proposalType;
    @ManyToOne(targetEntity=NoticeOfOpportunity.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="NOTICE_OF_OPPORTUNITY_CODE", referencedColumnName="NOTICE_OF_OPPORTUNITY_CODE", insertable=false, updatable=false)
    private NoticeOfOpportunity noticeOfOpportunity;
    @ManyToOne(targetEntity=AwardType.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="ANTICIPATED_AWARD_TYPE_CODE", referencedColumnName="AWARD_TYPE_CODE", insertable=false, updatable=false)
    private AwardType anticipatedAwardType;
    @ManyToOne(targetEntity=MailType.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="MAIL_TYPE", referencedColumnName="MAIL_TYPE", insertable=false, updatable=false)
    private MailType mailTypeRef;
    @ManyToOne(targetEntity=MailBy.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="MAIL_BY", referencedColumnName="MAIL_BY_CODE", insertable=false, updatable=false)
    private MailBy mailByRef;
    @ManyToOne(targetEntity=ProposalState.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="STATUS_CODE", referencedColumnName="STATE_TYPE_CODE", insertable=false, updatable=false)
    private ProposalState proposalState;
    @ManyToOne(targetEntity=Rolodex.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="MAILING_ADDRESS_ID", referencedColumnName="ROLODEX_ID", insertable=false, updatable=false)
    private Rolodex rolodex;
    @ManyToOne(targetEntity=Sponsor.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="SPONSOR_CODE", referencedColumnName="SPONSOR_CODE", insertable=false, updatable=false)
    private Sponsor sponsor;
    @ManyToOne(targetEntity=Unit.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="OWNED_BY_UNIT", referencedColumnName="UNIT_NUMBER", insertable=false, updatable=false)
    private Unit ownedByUnit;
    @ManyToOne(targetEntity=Sponsor.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="PRIME_SPONSOR_CODE", referencedColumnName="SPONSOR_CODE", insertable=false, updatable=false)
    private Sponsor primeSponsor;
    @ManyToOne(targetEntity=ActivityType.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="ACTIVITY_TYPE_CODE", referencedColumnName="ACTIVITY_TYPE_CODE", insertable=false, updatable=false)
    private ActivityType activityType;
    @OneToMany(mappedBy="developmentProposal", orphanRemoval=true, cascade={CascadeType.ALL})
    @OrderBy(value="siteNumber")
    private List<ProposalSite> proposalSites;
    @OneToMany(mappedBy="developmentProposal", orphanRemoval=true, cascade={CascadeType.ALL})
    @FilterGenerator(attributeName="hiddenInHierarchy", attributeResolverClass=ProposalHiddenInHierarchyCustomizerValue.class)
    private List<ProposalSpecialReview> propSpecialReviews;
    @OneToMany(mappedBy="developmentProposal", orphanRemoval=true, cascade={CascadeType.ALL})
    @FilterGenerator(attributeName="hiddenInHierarchy", attributeResolverClass=ProposalHiddenInHierarchyCustomizerValue.class)
    private List<PropScienceKeyword> propScienceKeywords;
    @OneToMany(mappedBy="developmentProposal", orphanRemoval=true, cascade={CascadeType.ALL})
    @OrderBy(value="ordinalPosition")
    @FilterGenerator(attributeName="hiddenInHierarchy", attributeResolverClass=ProposalHiddenInHierarchyCustomizerValue.class)
    private List<ProposalPerson> proposalPersons;
    @OneToMany(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER")
    private List<S2sAppSubmission> s2sAppSubmission;
    @OneToOne(mappedBy="developmentProposal", cascade={CascadeType.ALL})
    private S2sOverride s2sOverride;
    @OneToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER", insertable=false, updatable=false)
    private GrantForwardRecord grantForwardRecord;
    @OneToMany(mappedBy="developmentProposal", cascade={CascadeType.ALL})
    private List<S2sUserAttachedForm> s2sUserAttachedForms;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER")
    @OrderBy(value="sortId")
    private List<ProposalYnq> proposalYnqs;
    @OneToMany(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER")
    @OrderBy(value="columnName DESC, changeNumber DESC")
    private List<ProposalChangedData> proposalChangedDataList;
    @OneToMany(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER")
    @OrderBy(value="columnName DESC, changeNumber DESC")
    private List<BudgetChangedData> budgetChangedDataList;
    @OneToMany(mappedBy="developmentProposal", orphanRemoval=true, cascade={CascadeType.ALL})
    @OrderBy(value="moduleSequenceNumber DESC")
    private List<Narrative> narratives;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER")
    private List<ProposalAbstract> proposalAbstracts;
    @OneToMany(mappedBy="developmentProposal", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Narrative> instituteAttachments;
    @OneToMany(mappedBy="developmentProposal", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<ProposalPersonBiography> propPersonBios;
    @OneToMany(mappedBy="developmentProposal", orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE})
    @OrderBy(value="budgetVersionNumber")
    private List<ProposalDevelopmentBudgetExt> budgets;
    @OneToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="FINAL_BUDGET_ID", referencedColumnName="BUDGET_ID")
    private ProposalDevelopmentBudgetExt finalBudget;
    @OneToOne(cascade={CascadeType.REFRESH, CascadeType.REMOVE})
    @JoinColumn(name="HIERARCHY_LAST_BUDGET_ID", referencedColumnName="BUDGET_ID")
    private ProposalDevelopmentBudgetExt lastSyncedBudget;
    @OneToOne(mappedBy="developmentProposal", orphanRemoval=true, cascade={CascadeType.ALL})
    private S2sOpportunity s2sOpportunity;
    @OneToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="DOCUMENT_NUMBER", referencedColumnName="DOCUMENT_NUMBER")
    private ProposalDevelopmentDocument proposalDocument;
    @ManyToOne(targetEntity=NsfCode.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="NSF_SEQUENCE_NUMBER", referencedColumnName="NSF_SEQUENCE_NUMBER", insertable=false, updatable=false)
    private NsfCode nsfCodeBo;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER")
    @OrderBy(value="id ASC")
    private List<ProposalCfda> proposalCfdas;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER")
    private List<PreproposalFormBo> preproposalForms;
    @Transient
    private List<ProposalDevelopmentNotification> notifications;
    @Transient
    private String newScienceKeywordCode;
    @Transient
    private String newDescription;
    @Transient
    private Integer nextProposalPersonNumber = 1;
    @Transient
    private String budgetStatus;
    @Transient
    private Collection<InvestigatorCreditType> investigatorCreditTypes;
    @Transient
    private List<YnqGroupName> ynqGroupNames;
    @Transient
    private Map<String, List<ProposalChangedData>> proposalChangeHistory;
    @Transient
    private Map<String, List<BudgetChangedData>> budgetChangeHistory;
    @Transient
    private Boolean grantsGovSelectFlag = Boolean.FALSE;
    @Transient
    private String hierarchyStatusName;
    @Transient
    private transient Boolean nihOpportunity;
    @Transient
    private transient boolean nihOpportunityFetched = false;
    @Transient
    private transient ParameterService parameterService;
    @Transient
    private transient ProposalHierarchyService proposalHierarchyService;
    @Transient
    private transient LegacyNarrativeService narrativeService;
    @Transient
    private transient ProposalPersonBiographyService proposalPersonBiographyService;
    @Transient
    private transient SponsorHierarchyService sponsorHierarchyService;
    @Transient
    private transient ProposalDevelopmentService proposalDevelopmentService;
    @Transient
    private transient YnqService ynqService;
    @Transient
    private transient BusinessObjectService businessObjectService;
    @Transient
    private transient DataObjectService dataObjectService;
    @Transient
    private transient NihSubmissionAgencyDataService nihSubmissionAgencyDataService;

    public String getProposalNumberForGG() {
        if (this.s2sOpportunity != null) {
            this.proposalNumberForGG = this.s2sOpportunity.getProposalNumber();
        }
        return this.proposalNumberForGG;
    }

    public String getOpportunityIdForGG() {
        if (this.s2sOpportunity != null) {
            this.opportunityIdForGG = this.s2sOpportunity.getOpportunityId();
        }
        return this.opportunityIdForGG;
    }

    public void setProposalNumberForGG(String proposalNumberForGG) {
        this.proposalNumberForGG = proposalNumberForGG;
    }

    public void setOpportunityIdForGG(String opportunityIdForGG) {
        this.opportunityIdForGG = opportunityIdForGG;
    }

    @Override
    public String getHierarchyStatus() {
        return this.hierarchyStatus;
    }

    public void setHierarchyStatus(String hierarchyStatus) {
        this.hierarchyStatus = hierarchyStatus;
    }

    public String getHierarchyParentProposalNumber() {
        return this.hierarchyParentProposalNumber;
    }

    public void setHierarchyParentProposalNumber(String hierarchyParentProposalNumber) {
        this.hierarchyParentProposalNumber = hierarchyParentProposalNumber;
    }

    public String getHierarchyOriginatingChildProposalNumber() {
        return this.hierarchyOriginatingChildProposalNumber;
    }

    public void setHierarchyOriginatingChildProposalNumber(String hierarchyOriginatingChildProposalNumber) {
        this.hierarchyOriginatingChildProposalNumber = hierarchyOriginatingChildProposalNumber;
    }

    public void setHierarchyLastSyncHashCode(Integer hierarchyLastSyncHashCode) {
        this.hierarchyLastSyncHashCode = hierarchyLastSyncHashCode;
    }

    public Integer getHierarchyLastSyncHashCode() {
        return this.hierarchyLastSyncHashCode;
    }

    public boolean isParent() {
        return HierarchyStatusConstants.Parent.code().equals(this.hierarchyStatus);
    }

    public boolean isChild() {
        return HierarchyStatusConstants.Child.code().equals(this.hierarchyStatus);
    }

    public boolean isInHierarchy() {
        return !HierarchyStatusConstants.None.code().equals(this.hierarchyStatus);
    }

    public String getHierarchyStatusName() {
        this.hierarchyStatusName = HierarchyStatusConstants.None.description();
        for (HierarchyStatusConstants status : HierarchyStatusConstants.values()) {
            if (!status.code().equals(this.getHierarchyStatus())) continue;
            this.hierarchyStatusName = status.description();
        }
        return this.hierarchyStatusName;
    }

    public void setHierarchyStatusName(String hierarchyStatusName) {
        this.hierarchyStatusName = hierarchyStatusName;
    }

    public void setHierarchyBudgetType(String hierarchyBudgetType) {
        this.hierarchyBudgetType = hierarchyBudgetType;
    }

    public boolean isMultiProjectChild() {
        return this.isChild() && this.getS2sOpportunity() != null && this.getS2sOpportunity().isMultiProject();
    }

    public boolean isMultiProjectParent() {
        return this.isParent() && this.getS2sOpportunity() != null && this.getS2sOpportunity().isMultiProject();
    }

    public String getHierarchyBudgetType() {
        return this.hierarchyBudgetType;
    }

    public DevelopmentProposal() {
        this.propScienceKeywords = new ArrayList<PropScienceKeyword>();
        this.newDescription = this.getDefaultNewDescription();
        this.propSpecialReviews = new ArrayList<ProposalSpecialReview>();
        this.proposalPersons = new ArrayList<ProposalPerson>();
        this.narratives = new ArrayList<Narrative>();
        this.proposalAbstracts = new ArrayList<ProposalAbstract>();
        this.instituteAttachments = new ArrayList<Narrative>();
        this.propPersonBios = new ArrayList<ProposalPersonBiography>();
        this.proposalYnqs = new ArrayList<ProposalYnq>();
        this.ynqGroupNames = new ArrayList<YnqGroupName>();
        this.s2sAppSubmission = new ArrayList<S2sAppSubmission>();
        this.proposalChangedDataList = new ArrayList<ProposalChangedData>();
        this.s2sUserAttachedForms = new ArrayList<S2sUserAttachedForm>();
        this.proposalChangeHistory = new TreeMap<String, List<ProposalChangedData>>();
        this.budgetChangedDataList = new ArrayList<BudgetChangedData>();
        this.budgetChangeHistory = new TreeMap<String, List<BudgetChangedData>>();
        this.hierarchyStatus = HierarchyStatusConstants.None.code();
        this.hierarchyStatusName = HierarchyStatusConstants.None.description();
        this.budgets = new ArrayList<ProposalDevelopmentBudgetExt>();
        this.proposalCfdas = new ArrayList<ProposalCfda>();
        this.preproposalForms = new ArrayList<PreproposalFormBo>();
        this.initProposalSites();
    }

    private void initProposalSites() {
        this.proposalSites = new ArrayList<ProposalSite>();
        this.setApplicantOrganization(new ProposalSite());
        this.setPerformingOrganization(new ProposalSite());
    }

    public void initializeOwnedByUnitNumber() {
        List<Unit> userUnits = this.getProposalDevelopmentService().getDefaultModifyProposalUnitsForUser(GlobalVariables.getUserSession().getPrincipalId());
        if (userUnits.size() == 1) {
            this.setOwnedByUnitNumber(userUnits.get(0).getUnitNumber());
            this.getProposalDevelopmentService().initializeUnitOrganizationLocation(this.getProposalDocument());
        }
    }

    public List<ProposalPerson> getProposalPersons() {
        this.evaluateMoveOptions();
        return this.proposalPersons;
    }

    private void evaluateMoveOptions() {
        for (int i = 0; i < this.proposalPersons.size(); ++i) {
            ProposalPerson person = this.proposalPersons.get(i);
            person.setMoveUpAllowed(i > 0 && !person.isPrincipalInvestigator() && !this.proposalPersons.get(i - 1).isPrincipalInvestigator() && !this.proposalPersons.get(i - 1).isMultiplePi());
            person.setMoveDownAllowed(i < this.proposalPersons.size() - 1 && !person.isPrincipalInvestigator());
            if (!person.isMultiplePi()) continue;
            person.setMoveUpAllowed(i > 0 && person.isMultiplePi() == this.proposalPersons.get(i - 1).isMultiplePi());
            person.setMoveDownAllowed(person.isMoveDownAllowed() && person.isMultiplePi() == this.proposalPersons.get(i + 1).isMultiplePi());
        }
    }

    public List<ProposalPerson> getInvestigators() {
        ArrayList<ProposalPerson> investigators = new ArrayList<ProposalPerson>();
        for (ProposalPerson proposalPerson : this.getProposalPersons()) {
            if (!proposalPerson.isInvestigator()) continue;
            investigators.add(proposalPerson);
        }
        return investigators;
    }

    public List<ProposalPerson> getPersonsSelectedForCreditSplit() {
        boolean optIn = this.getParameterService().getParameterValueAsBoolean("KC-PD", "All", "ENABLE_OPT_IN_PERSONNEL_CREDIT_SPLIT_FUNCTIONALITY");
        return this.getProposalPersons().stream().filter(person -> BooleanUtils.isTrue((Boolean)person.getIncludeInCreditAllocation()) && optIn || !optIn && person.isInvestigator()).filter(person -> CollectionUtils.isNotEmpty(person.getUnits())).collect(Collectors.toList());
    }

    public void setProposalPersons(List<ProposalPerson> argProposalPersons) {
        this.proposalPersons = argProposalPersons;
    }

    @Override
    public String getActivityTypeCode() {
        return this.activityTypeCode;
    }

    public void setActivityTypeCode(String activityTypeCode) {
        this.activityTypeCode = activityTypeCode;
    }

    public void setOwnedByUnitNumber(String ownedByUnit) {
        this.ownedByUnitNumber = ownedByUnit;
    }

    public String getOwnedByUnitNumberRestricted() {
        return this.ownedByUnitNumber;
    }

    public void setOwnedByUnitNumberRestricted(String ownedByUnit) {
        this.ownedByUnitNumber = ownedByUnit;
    }

    public String getProposalTypeCode() {
        return this.proposalTypeCode;
    }

    public void setProposalTypeCode(String proposalTypeCode) {
        this.proposalTypeCode = proposalTypeCode;
    }

    public String getContinuedFrom() {
        return this.continuedFrom;
    }

    public void setContinuedFrom(String continuedFrom) {
        this.continuedFrom = continuedFrom;
    }

    @Override
    public Date getRequestedEndDateInitial() {
        return this.requestedEndDateInitial;
    }

    public void setRequestedEndDateInitial(Date requestedEndDateInitial) {
        this.requestedEndDateInitial = requestedEndDateInitial;
    }

    @Override
    public Date getRequestedStartDateInitial() {
        return this.requestedStartDateInitial;
    }

    public void setRequestedStartDateInitial(Date requestedStartDateInitial) {
        this.requestedStartDateInitial = requestedStartDateInitial;
    }

    @Override
    public String getSponsorCode() {
        return this.sponsorCode;
    }

    @Override
    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getCurrentAwardNumber() {
        return this.currentAwardNumber;
    }

    public void setCurrentAwardNumber(String currentAwardNumber) {
        this.currentAwardNumber = currentAwardNumber;
    }

    public String getAgencyDivisionCode() {
        return this.agencyDivisionCode;
    }

    public void setAgencyDivisionCode(String agencyDivisionCode) {
        this.agencyDivisionCode = agencyDivisionCode;
    }

    public String getAgencyProgramCode() {
        return this.agencyProgramCode;
    }

    public void setAgencyProgramCode(String agencyProgramCode) {
        this.agencyProgramCode = agencyProgramCode;
    }

    @Deprecated
    public String getCfdaNumber() {
        return this.findFirstCfda().map(ProposalCfda::getCfdaNumber).orElse(null);
    }

    @Deprecated
    public void setCfdaNumber(String cfdaNumber) {
        if (this.proposalCfdas == null) {
            this.proposalCfdas = new ArrayList<ProposalCfda>();
        }
        if (StringUtils.isBlank((CharSequence)cfdaNumber)) {
            this.proposalCfdas.clear();
        } else {
            ProposalCfda cfda = this.findFirstCfda().orElseGet(ProposalCfda::new);
            this.proposalCfdas.clear();
            cfda.setCfdaNumber(cfdaNumber);
            cfda.setProposalNumber(this.getProposalNumber());
            this.proposalCfdas.add(cfda);
        }
    }

    @Deprecated
    private Optional<ProposalCfda> findFirstCfda() {
        if (this.proposalCfdas != null) {
            return this.proposalCfdas.stream().findFirst();
        }
        return Optional.empty();
    }

    public Date getDeadlineDate() {
        return this.deadlineDate;
    }

    public void setDeadlineDate(Date deadlineDate) {
        this.deadlineDate = deadlineDate;
    }

    public String getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(String deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public String getDeadlineType() {
        return this.deadlineType;
    }

    public void setAnticipatedAwardTypeCode(Integer anticipatedAwardTypeCode) {
        this.anticipatedAwardTypeCode = anticipatedAwardTypeCode;
    }

    public void setAnticipatedAwardType(AwardType anticipatedAwardType) {
        this.anticipatedAwardType = anticipatedAwardType;
    }

    public Integer getAnticipatedAwardTypeCode() {
        return this.anticipatedAwardTypeCode;
    }

    public AwardType getAnticipatedAwardType() {
        return this.anticipatedAwardType;
    }

    public void setDeadlineType(String deadlineType) {
        this.deadlineType = deadlineType;
    }

    public String getNoticeOfOpportunityCode() {
        return this.noticeOfOpportunityCode;
    }

    public void setNoticeOfOpportunityCode(String noticeOfOpportunityCode) {
        this.noticeOfOpportunityCode = noticeOfOpportunityCode;
    }

    public String getNsfCode() {
        if (this.getNsfCodeBo() != null) {
            return this.getNsfCodeBo().getNsfCode();
        }
        return null;
    }

    public Integer getNsfSequenceNumber() {
        return this.nsfSequenceNumber;
    }

    public void setNsfSequenceNumber(Integer nsfSequenceNumber) {
        this.nsfSequenceNumber = nsfSequenceNumber;
    }

    @Override
    public String getPrimeSponsorCode() {
        return this.primeSponsorCode;
    }

    public void setPrimeSponsorCode(String primeSponsorCode) {
        this.primeSponsorCode = primeSponsorCode;
        if (StringUtils.isBlank((CharSequence)primeSponsorCode)) {
            this.primeSponsor = null;
        }
    }

    public String getProgramAnnouncementNumber() {
        return this.programAnnouncementNumber;
    }

    public void setProgramAnnouncementNumber(String programAnnouncementNumber) {
        this.programAnnouncementNumber = programAnnouncementNumber;
    }

    public String getProgramAnnouncementTitle() {
        return this.programAnnouncementTitle;
    }

    public void setProgramAnnouncementTitle(String programAnnouncementTitle) {
        this.programAnnouncementTitle = programAnnouncementTitle;
    }

    public void updateFromS2sOpportunity(S2sOpportunity s2sOpportunity) {
        if (s2sOpportunity != null) {
            String trimmedTitle = StringUtils.substring((String)s2sOpportunity.getOpportunityTitle(), (int)0, (int)119);
            this.setProgramAnnouncementTitle(trimmedTitle);
            this.setProposalCfdas(new ArrayList<ProposalCfda>());
            if (s2sOpportunity.getS2sOpportunityCfdas() != null) {
                this.setProposalCfdas(s2sOpportunity.getS2sOpportunityCfdas().stream().map(cfda -> {
                    cfda.setProposalNumber(this.getProposalNumber());
                    ProposalCfda proposalCfda = new ProposalCfda();
                    proposalCfda.setCfdaNumber(cfda.getCfdaNumber());
                    proposalCfda.setCfdaDescription(cfda.getCfdaDescription());
                    proposalCfda.setProposalNumber(this.getProposalNumber());
                    return proposalCfda;
                }).collect(Collectors.toList()));
            }
            this.setProgramAnnouncementNumber(s2sOpportunity.getOpportunityId());
        }
    }

    public String getSponsorProposalNumber() {
        return this.sponsorProposalNumber;
    }

    public void setSponsorProposalNumber(String sponsorProposalNumber) {
        this.sponsorProposalNumber = sponsorProposalNumber;
    }

    public Boolean getSubcontracts() {
        return this.subcontracts;
    }

    public void setSubcontracts(Boolean subcontracts) {
        this.subcontracts = subcontracts;
    }

    public String getMailBy() {
        return this.mailBy;
    }

    public void setMailBy(String mailBy) {
        this.mailBy = mailBy;
    }

    public String getMailType() {
        return this.mailType;
    }

    public void setMailType(String mailType) {
        this.mailType = mailType;
    }

    public String getMailAccountNumber() {
        return this.mailAccountNumber;
    }

    public void setMailAccountNumber(String mailAccountNumber) {
        this.mailAccountNumber = mailAccountNumber;
    }

    public String getMailDescription() {
        return this.mailDescription;
    }

    public void setMailDescription(String mailDescription) {
        this.mailDescription = mailDescription;
    }

    public Integer getMailingAddressId() {
        return this.mailingAddressId;
    }

    public void setMailingAddressId(Integer mailingAddressId) {
        this.mailingAddressId = mailingAddressId;
    }

    public String getNumberOfCopies() {
        return this.numberOfCopies;
    }

    public void setNumberOfCopies(String numberOfCopies) {
        this.numberOfCopies = numberOfCopies;
    }

    public void setApplicantOrganizationId(String applicantOrganizationId) {
        ProposalSite applicantOrganization = this.getApplicantOrganization();
        applicantOrganization.setOrganizationId(applicantOrganizationId);
        this.setApplicantOrganization(applicantOrganization);
    }

    public void setPerformingOrganizationId(String performingOrganizationId) {
        ProposalSite performingOrganization = this.getPerformingOrganization();
        performingOrganization.setOrganizationId(performingOrganizationId);
        this.setPerformingOrganization(performingOrganization);
    }

    public void setApplicantOrganization(ProposalSite applicantOrganization) {
        this.setProposalSiteForType(applicantOrganization, 1);
    }

    public void setApplicantOrgFromOrganization(Organization organization) {
        if (organization == null) {
            this.setApplicantOrganization(null);
        } else {
            ProposalSite applicantSite = new ProposalSite();
            applicantSite.setOrganization(organization);
            this.setApplicantOrganization(applicantSite);
        }
    }

    public ProposalSite getApplicantOrganization() {
        return this.getProposalSiteForType(1);
    }

    public void setPerformingOrganization(ProposalSite performingOrganization) {
        this.setProposalSiteForType(performingOrganization, 2);
    }

    public void setPerformingOrgFromOrganization(Organization organization) {
        if (organization == null) {
            this.setPerformingOrganization(null);
        } else {
            ProposalSite performingSite = new ProposalSite();
            performingSite.setOrganization(organization);
            this.setPerformingOrganization(performingSite);
        }
    }

    public ProposalSite getPerformingOrganization() {
        return this.getProposalSiteForType(2);
    }

    public void addProposalSite(ProposalSite proposalSite) {
        proposalSite.setDevelopmentProposal(this);
        this.proposalSites.add(proposalSite);
    }

    private void setProposalSiteForType(ProposalSite proposalSite, int locationType) {
        this.deleteAllProposalSitesOfType(locationType);
        proposalSite.setLocationTypeCode(locationType);
        proposalSite.setDevelopmentProposal(this);
        this.addProposalSite(proposalSite);
    }

    private void setProposalSitesForType(List<ProposalSite> proposalSites, int locationType) {
        this.deleteAllProposalSitesOfType(locationType);
        for (ProposalSite proposalSite : proposalSites) {
            proposalSite.setLocationTypeCode(locationType);
            proposalSite.setDevelopmentProposal(this);
        }
        this.proposalSites.addAll(proposalSites);
    }

    private void deleteAllProposalSitesOfType(int locationType) {
        for (int i = this.proposalSites.size() - 1; i >= 0; --i) {
            ProposalSite proposalSite = this.proposalSites.get(i);
            if (proposalSite.getLocationTypeCode() != locationType) continue;
            this.proposalSites.remove(i);
        }
    }

    private ProposalSite getProposalSiteForType(int locationType) {
        List<ProposalSite> matchingSites = this.getProposalSitesForType(locationType);
        if (matchingSites.isEmpty()) {
            return null;
        }
        return matchingSites.get(0);
    }

    private List<ProposalSite> getProposalSitesForType(int locationType) {
        ArrayList<ProposalSite> matchingSites = new ArrayList<ProposalSite>();
        for (ProposalSite proposalSite : this.proposalSites) {
            if (proposalSite.getLocationTypeCode() != locationType) continue;
            matchingSites.add(proposalSite);
        }
        return matchingSites;
    }

    public void setPerformanceSites(List<ProposalSite> performanceSites) {
        this.setProposalSitesForType(performanceSites, 4);
    }

    public List<ProposalSite> getPerformanceSites() {
        return this.getProposalSitesForType(4);
    }

    public void addPerformanceSite(ProposalSite performanceSite) {
        performanceSite.setLocationTypeCode(4);
        this.addProposalSite(performanceSite);
    }

    public void removePerformanceSite(int index) {
        this.removeProposalSiteOfType(4, index);
    }

    public void setOtherOrganizations(List<ProposalSite> otherOrganizations) {
        this.setProposalSitesForType(otherOrganizations, 3);
    }

    public List<ProposalSite> getOtherOrganizations() {
        return this.getProposalSitesForType(3);
    }

    public void addOtherOrganization(ProposalSite otherOrganization) {
        otherOrganization.setLocationTypeCode(3);
        this.addProposalSite(otherOrganization);
    }

    public void removeOtherOrganization(int index) {
        this.removeProposalSiteOfType(3, index);
    }

    private void removeProposalSiteOfType(int locationType, int index) {
        for (ProposalSite proposalSite : this.getProposalSitesForType(locationType)) {
            if (proposalSite.getLocationTypeCode() != locationType || --index >= 0) continue;
            this.proposalSites.remove(proposalSite);
            break;
        }
    }

    public void setProposalSites(List<ProposalSite> proposalSites) {
        this.proposalSites = proposalSites;
    }

    public List<ProposalSite> getProposalSites() {
        return this.proposalSites;
    }

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public void setPropScienceKeywords(List<PropScienceKeyword> propScienceKeywords) {
        if (propScienceKeywords != null) {
            this.propScienceKeywords = propScienceKeywords;
        } else {
            this.propScienceKeywords.clear();
        }
        for (PropScienceKeyword keyword : this.propScienceKeywords) {
            keyword.setDevelopmentProposal(this);
        }
    }

    public List<PropScienceKeyword> getPropScienceKeywords() {
        return this.propScienceKeywords;
    }

    public void addPropScienceKeyword(PropScienceKeyword propScienceKeyword) {
        this.getPropScienceKeywords().add(propScienceKeyword);
    }

    public String getPropScienceKeywordsAsText() {
        if (this.propScienceKeywords != null) {
            return this.propScienceKeywords.stream().map(keyword -> keyword.getScienceKeyword().getDescription()).collect(Collectors.joining(", "));
        }
        return "";
    }

    public String getNewScienceKeywordCode() {
        return this.newScienceKeywordCode;
    }

    public void setNewScienceKeywordCode(String newScienceKeywordCode) {
        this.newScienceKeywordCode = newScienceKeywordCode;
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public void setNewDescription(String newDescription) {
        this.newDescription = newDescription;
    }

    public String getDefaultNewDescription() {
        return SELECT;
    }

    public List<ProposalSpecialReview> getPropSpecialReviews() {
        return this.propSpecialReviews;
    }

    public void setPropSpecialReviews(List<ProposalSpecialReview> propSpecialReviews) {
        this.propSpecialReviews = propSpecialReviews;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        ArrayList<ProposalPersonUnit> units = new ArrayList<ProposalPersonUnit>();
        ArrayList<ProposalPersonDegree> degrees = new ArrayList<ProposalPersonDegree>();
        for (ProposalPerson proposalPerson : this.getProposalPersons()) {
            units.addAll(proposalPerson.getUnits());
            degrees.addAll(proposalPerson.getProposalPersonDegrees());
        }
        managedLists.add(units);
        managedLists.add(degrees);
        managedLists.add(this.getProposalSites());
        ArrayList<CongressionalDistrict> congressionalDistricts = new ArrayList<CongressionalDistrict>();
        for (ProposalSite proposalSite : this.getProposalSites()) {
            congressionalDistricts.addAll(proposalSite.getCongressionalDistricts());
        }
        managedLists.add(congressionalDistricts);
        ArrayList<ProposalSpecialReviewExemption> arrayList = new ArrayList<ProposalSpecialReviewExemption>();
        for (ProposalSpecialReview specialReview : this.getPropSpecialReviews()) {
            arrayList.addAll(specialReview.getSpecialReviewExemptions());
        }
        managedLists.add(arrayList);
        managedLists.add(this.getPropSpecialReviews());
        managedLists.add(this.getProposalPersons());
        managedLists.add(this.getPropScienceKeywords());
        managedLists.add(this.getProposalAbstracts());
        managedLists.add(this.getPropPersonBios());
        managedLists.add(this.getS2sAppSubmission());
        ArrayList<S2sOpportunity> arrayList2 = new ArrayList<S2sOpportunity>();
        S2sOpportunity opportunity = this.getS2sOpportunity();
        if (opportunity != null) {
            arrayList2.add(opportunity);
        }
        if (opportunity != null && opportunity.getS2sOppForms() != null && opportunity.getS2sOppForms().size() > 0) {
            managedLists.add(opportunity.getS2sOppForms());
        } else {
            managedLists.add(new ArrayList());
        }
        managedLists.add(arrayList2);
        managedLists.add(this.getS2sUserAttachedForms());
        managedLists.add(this.getPreproposalForms());
        return managedLists;
    }

    public Sponsor getSponsor() {
        if (DevelopmentProposal.outOfSync(this.sponsorCode, this.sponsor)) {
            this.refreshReferenceObject(SPONSOR);
        }
        return this.sponsor;
    }

    public void setSponsor(Sponsor sponsor) {
        this.sponsor = sponsor;
    }

    public String getSponsorName() {
        if (this.getSponsor() != null) {
            return this.getSponsor().getSponsorName();
        }
        return null;
    }

    public String getOwnedByUnitName() {
        Unit unit = this.getOwnedByUnit();
        return unit != null ? unit.getUnitName() : null;
    }

    public ProposalPerson getPrincipalInvestigator() {
        ProposalPerson principalInvestigator = null;
        for (ProposalPerson person : this.proposalPersons) {
            if (!StringUtils.equals((CharSequence)person.getProposalPersonRoleId(), (CharSequence)PI)) continue;
            principalInvestigator = person;
            break;
        }
        return principalInvestigator;
    }

    @Override
    public String getPrincipalInvestigatorName() {
        ProposalPerson pi = this.getPrincipalInvestigator();
        return pi != null ? pi.getFullName() : null;
    }

    public void setNextProposalPersonNumber(Integer n) {
        this.nextProposalPersonNumber = n;
    }

    public Integer getNextProposalPersonNumber() {
        return this.nextProposalPersonNumber;
    }

    public void addProposalPerson(ProposalPerson p) {
        p.setProposalPersonNumber(this.getProposalDocument().getDocumentNextValue("proposalDevelopment.proposalPerson.proposalPersonNumber"));
        p.setDevelopmentProposal(this);
        this.getProposalPersons().add(p);
    }

    public ProposalPerson getProposalPerson(int index) {
        while (this.getProposalPersons().size() <= index) {
            this.getProposalPersons().add(new ProposalPerson());
        }
        return this.getProposalPersons().get(index);
    }

    public List<Narrative> getNarratives() {
        return this.narratives;
    }

    public void setNarratives(List<Narrative> narratives) {
        this.narratives = narratives;
    }

    public List<Narrative> getMergedNarrativeList() {
        return Stream.concat(this.getNarratives().stream(), this.getInstituteAttachments().stream()).sorted(Comparator.comparing(Narrative::getModuleSequenceNumber).reversed()).collect(Collectors.toList());
    }

    public OptionalInt getNarrativesMinModuleSequenceNumber() {
        if (this.narratives == null || this.narratives.isEmpty()) {
            return OptionalInt.empty();
        }
        return this.narratives.stream().mapToInt(n -> n.getModuleSequenceNumber()).min();
    }

    public OptionalInt getNarrativesMaxModuleSequenceNumber() {
        if (this.narratives == null || this.narratives.isEmpty()) {
            return OptionalInt.empty();
        }
        return this.narratives.stream().mapToInt(n -> n.getModuleSequenceNumber()).max();
    }

    public OptionalInt getMergedNarrativesMaxModuleSequenceNumber() {
        List<Narrative> mergedNarrativeList = this.getMergedNarrativeList();
        if (mergedNarrativeList.isEmpty()) {
            return OptionalInt.empty();
        }
        return mergedNarrativeList.stream().mapToInt(n -> n.getModuleSequenceNumber()).max();
    }

    public List<ProposalAbstract> getProposalAbstracts() {
        return this.proposalAbstracts;
    }

    public void setProposalAbstracts(List<ProposalAbstract> proposalAbstracts) {
        this.proposalAbstracts = proposalAbstracts;
    }

    public List<Narrative> getInstituteAttachments() {
        return this.instituteAttachments;
    }

    public void setInstituteAttachments(List<Narrative> instituteAttachments) {
        this.instituteAttachments = instituteAttachments;
    }

    public List<ProposalPersonBiography> getPropPersonBios() {
        return this.propPersonBios;
    }

    public void setPropPersonBios(List<ProposalPersonBiography> propPersonBios) {
        this.propPersonBios = propPersonBios;
    }

    public Unit getOwnedByUnit() {
        return this.ownedByUnit;
    }

    public void setOwnedByUnit(Unit ownedByUnit) {
        this.ownedByUnit = ownedByUnit;
    }

    public void addProposalPersonBiography(ProposalPersonBiography proposalPersonBiography) {
        this.getProposalPersonBiographyService().addProposalPersonBiography(this.getProposalDocument(), proposalPersonBiography);
    }

    public void removePersonnelAttachmentForDeletedPerson(ProposalPerson proposalPerson) throws Exception {
        this.getProposalPersonBiographyService().removePersonnelAttachmentForDeletedPerson(this.getProposalDocument(), proposalPerson);
    }

    public void deleteProposalPersonBiography(int lineToDelete) {
        this.getProposalPersonBiographyService().deleteProposalPersonBiography(this.getProposalDocument(), lineToDelete);
    }

    public void populatePersonNameForNarrativeUserRights(int lineNumber) {
        if (!this.getNarratives().isEmpty()) {
            Narrative narrative = this.getNarratives().get(lineNumber);
            this.getNarrativeService().populatePersonNameForNarrativeUserRights(this.getProposalDocument(), narrative);
        }
    }

    public void populatePersonNameForInstituteAttachmentUserRights(int lineNumber) {
        if (!this.getInstituteAttachments().isEmpty()) {
            Narrative narrative = this.getInstituteAttachments().get(lineNumber);
            this.getNarrativeService().populatePersonNameForNarrativeUserRights(this.getProposalDocument(), narrative);
        }
    }

    public void populateNarrativeRightsForLoggedinUser() {
        this.getNarrativeService().populateNarrativeRightsForLoggedinUser(this.getProposalDocument());
    }

    public void setInvestigatorCreditTypes(Collection<InvestigatorCreditType> creditTypes) {
        this.investigatorCreditTypes = creditTypes;
    }

    public Collection<InvestigatorCreditType> getInvestigatorCreditTypes() {
        return this.investigatorCreditTypes;
    }

    public List<ProposalYnq> getProposalYnqs() {
        Collections.sort(this.proposalYnqs);
        return this.proposalYnqs;
    }

    public void setProposalYnqs(List<ProposalYnq> proposalYnqs) {
        this.proposalYnqs = proposalYnqs;
    }

    public List<YnqGroupName> getYnqGroupNames() {
        if (this.ynqGroupNames.isEmpty()) {
            this.getYnqService().populateProposalQuestions(this.proposalYnqs, this.ynqGroupNames, this.getProposalDocument());
        }
        Collections.sort(this.ynqGroupNames);
        return this.ynqGroupNames;
    }

    public void setYnqGroupNames(List<YnqGroupName> ynqGroupNames) {
        this.ynqGroupNames = ynqGroupNames;
    }

    public ProposalSpecialReview getPropSpecialReview(int index) {
        while (this.getPropSpecialReviews().size() <= index) {
            this.getPropSpecialReviews().add(new ProposalSpecialReview());
        }
        return this.getPropSpecialReviews().get(index);
    }

    public Narrative getNarrative(int index) {
        while (this.getNarratives().size() <= index) {
            this.getNarratives().add(new Narrative());
        }
        return this.getNarratives().get(index);
    }

    public Narrative getInstituteAttachment(int index) {
        while (this.getInstituteAttachments().size() <= index) {
            this.getInstituteAttachments().add(new Narrative());
        }
        return this.getInstituteAttachments().get(index);
    }

    public ProposalAbstract getProposalAbstract(int index) {
        while (this.getProposalAbstracts().size() <= index) {
            this.getProposalAbstracts().add(new ProposalAbstract());
        }
        return this.getProposalAbstracts().get(index);
    }

    public ProposalPersonBiography getPropPersonBio(int index) {
        while (this.getPropPersonBios().size() <= index) {
            this.getPropPersonBios().add(new ProposalPersonBiography());
        }
        return this.getPropPersonBios().get(index);
    }

    public ProposalPerson getInvestigator(int index) {
        while (this.getInvestigators().size() <= index) {
            this.getInvestigators().add(new ProposalPerson());
        }
        return this.getInvestigators().get(index);
    }

    public ProposalYnq getProposalYnq(int index) {
        while (this.getProposalYnqs().size() <= index) {
            this.getProposalYnqs().add(new ProposalYnq());
        }
        return this.getProposalYnqs().get(index);
    }

    public YnqGroupName getYnqGroupName(int index) {
        while (this.getYnqGroupNames().size() <= index) {
            this.getYnqGroupNames().add(new YnqGroupName());
        }
        return this.getYnqGroupNames().get(index);
    }

    @Override
    public String getBudgetStatus() {
        return this.budgetStatus;
    }

    @Override
    public void setBudgetStatus(String budgetStatus) {
        this.budgetStatus = budgetStatus;
    }

    public String getBudgetStatusDescription() {
        if (this.getFinalBudget() != null && this.getFinalBudget().getBudgetStatusDo() != null) {
            return this.getFinalBudget().getBudgetStatusDo().getDescription();
        }
        if (this.getLatestBudget() != null && this.getLatestBudget().getBudgetStatusDo() != null) {
            return this.getLatestBudget().getBudgetStatusDo().getDescription();
        }
        return "";
    }

    private Optional<String> getFinalBudgetRateClassCodeForProposal(DevelopmentProposal proposal) {
        return Optional.ofNullable(proposal).map(DevelopmentProposal::getFinalBudget).map(Budget::getRateClass).map(RateClass::getCode);
    }

    public Set<String> getBudgetRateClassCodes() {
        ArrayList<DevelopmentProposal> applicableProposals = new ArrayList<DevelopmentProposal>();
        applicableProposals.add(this);
        if (this.isParent()) {
            applicableProposals.addAll(this.getProposalHierarchyService().getHierarchyChildren(this.getProposalNumber()));
        }
        return applicableProposals.stream().map(this::getFinalBudgetRateClassCodeForProposal).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    public List<S2sOppForms> getS2sOppForms() {
        if (this.s2sOpportunity != null) {
            return this.getS2sOpportunity().getS2sOppForms();
        }
        return Collections.emptyList();
    }

    public List<S2sOppForms> getSelectedS2sOppForms() {
        return this.getS2sOppForms().stream().filter(form -> Objects.equals(Boolean.TRUE, form.getSelectToPrint())).collect(Collectors.toList());
    }

    public void setS2sOpportunity(S2sOpportunity s2sOpportunity) {
        this.s2sOpportunity = s2sOpportunity;
    }

    public S2sOpportunity getS2sOpportunity() {
        return this.s2sOpportunity;
    }

    public boolean hasS2sOpportunity() {
        return this.getS2sOpportunity() != null;
    }

    @Override
    public ProposalPerson getProposalEmployee(String personId) {
        for (ProposalPerson proposalPerson : this.getProposalPersons()) {
            if (!personId.equals(proposalPerson.getPersonId())) continue;
            return proposalPerson;
        }
        return null;
    }

    @Override
    public ProposalPerson getProposalNonEmployee(Integer rolodexId) {
        for (ProposalPerson proposalPerson : this.getProposalPersons()) {
            if (!rolodexId.equals(proposalPerson.getRolodexId())) continue;
            return proposalPerson;
        }
        return null;
    }

    @Override
    public ContactRole getProposalEmployeeRole(String personId) {
        ProposalPerson principalInvestigator = this.getPrincipalInvestigator();
        if (principalInvestigator != null && personId.equals(principalInvestigator.getPersonId())) {
            return principalInvestigator.getRole();
        }
        for (ProposalPerson proposalPerson : this.getInvestigators()) {
            if (!personId.equals(proposalPerson.getPersonId())) continue;
            return proposalPerson.getRole();
        }
        for (ProposalPerson proposalPerson : this.getProposalPersons()) {
            if (!personId.equals(proposalPerson.getPersonId())) continue;
            return proposalPerson.getRole();
        }
        return null;
    }

    @Override
    public ContactRole getProposalNonEmployeeRole(Integer rolodexId) {
        ProposalPerson principalInvestigator = this.getPrincipalInvestigator();
        if (principalInvestigator != null && rolodexId.equals(principalInvestigator.getRolodexId())) {
            return principalInvestigator.getRole();
        }
        for (ProposalPerson proposalPerson : this.getInvestigators()) {
            if (!rolodexId.equals(proposalPerson.getRolodexId())) continue;
            return proposalPerson.getRole();
        }
        for (ProposalPerson proposalPerson : this.getProposalPersons()) {
            if (!rolodexId.equals(proposalPerson.getRolodexId())) continue;
            return proposalPerson.getRole();
        }
        return null;
    }

    public String getCreationStatusCode() {
        return this.creationStatusCode;
    }

    public void setCreationStatusCode(String creationStatusCode) {
        this.creationStatusCode = creationStatusCode;
    }

    @Override
    public final ActivityType getActivityType() {
        return this.activityType;
    }

    public final void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public boolean isProposalComplete() {
        String budgetStatusCompleteCode = this.getParameterService().getParameterValueAsString(Budget.class, "budgetStatusCompleteCode");
        return this.getBudgetStatus() != null && budgetStatusCompleteCode != null && this.getBudgetStatus().equals(budgetStatusCompleteCode);
    }

    public boolean isParentProposalComplete() {
        boolean retval = false;
        if (this.isChild()) {
            try {
                DevelopmentProposal parent = this.getProposalHierarchyService().lookupParent(this);
                retval = parent.isProposalComplete();
            }
            catch (ProposalHierarchyException x) {
                throw new IllegalStateException(x);
            }
        }
        return retval;
    }

    public List<S2sAppSubmission> getS2sAppSubmission() {
        return this.s2sAppSubmission;
    }

    public void setS2sAppSubmission(List<S2sAppSubmission> appSubmission) {
        this.s2sAppSubmission = appSubmission;
    }

    public S2sAppSubmission getDisplayedS2sAppSubmission() {
        if (CollectionUtils.isNotEmpty(this.getS2sAppSubmission())) {
            return this.getS2sAppSubmission().get(this.getS2sAppSubmission().size() - 1);
        }
        return null;
    }

    public S2sOverride getS2sOverride() {
        return this.s2sOverride;
    }

    public void setS2sOverride(S2sOverride s2sOverride) {
        this.s2sOverride = s2sOverride;
    }

    public List<ProposalChangedData> getProposalChangedDataList() {
        return this.proposalChangedDataList;
    }

    public void setProposalChangedDataList(List<ProposalChangedData> proposalChangedDataList) {
        this.proposalChangedDataList = proposalChangedDataList;
    }

    public Map<String, List<ProposalChangedData>> getProposalChangeHistory() {
        return this.proposalChangeHistory;
    }

    public void setProposalChangeHistory(Map<String, List<ProposalChangedData>> proposalChangeHistory) {
        this.proposalChangeHistory = proposalChangeHistory;
    }

    public void setSubmitFlag(Boolean submitFlag) {
        this.submitFlag = submitFlag;
    }

    public Boolean getSubmitFlag() {
        return this.submitFlag;
    }

    public Boolean getGrantsGovSelectFlag() {
        return this.grantsGovSelectFlag;
    }

    public void setGrantsGovSelectFlag(Boolean grantsGovSelectFlag) {
        this.grantsGovSelectFlag = grantsGovSelectFlag;
    }

    public String getProposalStateTypeCode() {
        return this.proposalStateTypeCode;
    }

    public void setProposalStateTypeCode(String proposalStateTypeCode) {
        this.proposalStateTypeCode = proposalStateTypeCode;
    }

    public ProposalState getProposalState() {
        return this.proposalState;
    }

    public void setProposalState(ProposalState proposalState) {
        this.proposalState = proposalState;
    }

    public List<ProposalCfda> getProposalCfdas() {
        return this.proposalCfdas;
    }

    public void setProposalCfdas(List<ProposalCfda> proposalCfdas) {
        this.proposalCfdas = proposalCfdas;
    }

    public ProposalDevelopmentDocument getProposalDocument() {
        if (this.proposalDocument == null) {
            this.proposalDocument = new ProposalDevelopmentDocument();
        } else if (this.proposalDocument.getDocumentHeader() != null && this.proposalDocument.getDocumentNumber() != null && !this.proposalDocument.getDocumentHeader().hasWorkflowDocument()) {
            this.proposalDocument.getDocumentHeader().setWorkflowDocument(WorkflowDocumentFactory.loadDocument((String)GlobalVariables.getUserSession().getPrincipalId(), (String)this.proposalDocument.getDocumentNumber()));
        }
        return this.proposalDocument;
    }

    public void setProposalDocument(ProposalDevelopmentDocument proposalDocument) {
        this.proposalDocument = proposalDocument;
    }

    public void updateProposalChangeHistory() {
        this.proposalChangeHistory = new TreeMap<String, List<ProposalChangedData>>();
        if (CollectionUtils.isNotEmpty(this.getProposalChangedDataList())) {
            for (ProposalChangedData proposalChangedData : this.getProposalChangedDataList()) {
                this.proposalChangeHistory.computeIfAbsent(proposalChangedData.getEditableColumn().getColumnLabel(), k -> new ArrayList());
                this.proposalChangeHistory.get(proposalChangedData.getEditableColumn().getColumnLabel()).add(proposalChangedData);
            }
        }
    }

    public void updateBudgetChangeHistory() {
        this.budgetChangeHistory = new TreeMap<String, List<BudgetChangedData>>();
        if (CollectionUtils.isNotEmpty(this.getBudgetChangedDataList())) {
            for (BudgetChangedData budgetChangedData : this.getBudgetChangedDataList()) {
                this.budgetChangeHistory.computeIfAbsent(budgetChangedData.getEditableColumn().getColumnLabel(), k -> new ArrayList());
                this.budgetChangeHistory.get(budgetChangedData.getEditableColumn().getColumnLabel()).add(budgetChangedData);
            }
        }
    }

    public void setProposalType(ProposalType proposalType) {
        this.proposalType = proposalType;
    }

    public ProposalType getProposalType() {
        return this.proposalType;
    }

    public List<PersonRolodex> getPersonRolodexList() {
        ArrayList<PersonRolodex> filtered = new ArrayList<PersonRolodex>();
        for (ProposalPerson person : this.getProposalPersons()) {
            if (!filtered.contains(person)) {
                filtered.add(person);
                continue;
            }
            if (!person.isInvestigator()) continue;
            filtered.remove(person);
            filtered.add(person);
        }
        return filtered;
    }

    @Override
    public Unit getUnit() {
        return this.getOwnedByUnit();
    }

    @Override
    public String getUnitNumber() {
        return this.getOwnedByUnitNumber();
    }

    @Override
    public String getDefaultBudgetStatusParameter() {
        return "budgetStatusIncompleteCode";
    }

    @Override
    public boolean isParentInHierarchyComplete() {
        return this.isParentProposalComplete();
    }

    public NoticeOfOpportunity getNoticeOfOpportunity() {
        return this.noticeOfOpportunity;
    }

    public void setNoticeOfOpportunity(NoticeOfOpportunity noticeOfOpportunity) {
        this.noticeOfOpportunity = noticeOfOpportunity;
    }

    public NsfCode getNsfCodeBo() {
        return this.nsfCodeBo;
    }

    public void setNsfCodeBo(NsfCode nsfCodeBo) {
        this.nsfCodeBo = nsfCodeBo;
    }

    public String getAttachmentsStatus() {
        String statusString = ATTACHMENTS_COMPLETE;
        if (!this.getNarratives().isEmpty()) {
            for (Narrative aNarrative : this.getNarratives()) {
                if (!aNarrative.getNarrativeStatus().getDescription().equals(ATTACHMENTS_INCOMPLETE)) continue;
                statusString = ATTACHMENTS_INCOMPLETE;
            }
        } else {
            statusString = ATTACHMENTS_NONE;
        }
        return statusString;
    }

    public Sponsor getPrimeSponsor() {
        if (DevelopmentProposal.outOfSync(this.primeSponsorCode, this.primeSponsor)) {
            this.refreshReferenceObject(PRIME_SPONSOR);
        }
        return this.primeSponsor;
    }

    private static boolean outOfSync(String code, Sponsor spon) {
        return spon == null && StringUtils.isNotEmpty((CharSequence)code) || spon != null && StringUtils.isNotEmpty((CharSequence)code) && !StringUtils.equals((CharSequence)spon.getSponsorCode(), (CharSequence)code);
    }

    public void setPrimeSponsor(Sponsor primeSponsor) {
        this.primeSponsor = primeSponsor;
    }

    @Override
    public String getParentNumber() {
        return this.getProposalNumber();
    }

    @Override
    public String getParentPIName() {
        String proposalInvestigatorName = null;
        for (ProposalPerson pPerson : this.getProposalPersons()) {
            if (pPerson.getPersonId() == null || !pPerson.getProposalPersonRoleId().equals(PI)) continue;
            proposalInvestigatorName = pPerson.getFullName();
            break;
        }
        return proposalInvestigatorName;
    }

    @Override
    public String getOwnedByUnitNumber() {
        return this.ownedByUnitNumber;
    }

    @Override
    public String getParentTitle() {
        return this.getTitle();
    }

    @Override
    public Integer getParentInvestigatorFlag(String personId, Integer flag) {
        for (ProposalPerson pPerson : this.getProposalPersons()) {
            if ((pPerson.getPersonId() == null || !pPerson.getPersonId().equals(personId)) && (pPerson.getRolodexId() == null || !String.valueOf(pPerson.getRolodexId()).equalsIgnoreCase(personId))) continue;
            flag = 2;
            if (!pPerson.getProposalPersonRoleId().equals(PI)) continue;
            flag = 1;
            break;
        }
        return flag;
    }

    @Override
    public String getParentTypeName() {
        return PROPOSAL;
    }

    public void setBudgetChangeHistory(Map<String, List<BudgetChangedData>> budgetChangeHistory) {
        this.budgetChangeHistory = budgetChangeHistory;
    }

    public Map<String, List<BudgetChangedData>> getBudgetChangeHistory() {
        return this.budgetChangeHistory;
    }

    public void setBudgetChangedDataList(List<BudgetChangedData> budgetChangedDataList) {
        this.budgetChangedDataList = budgetChangedDataList;
    }

    public List<BudgetChangedData> getBudgetChangedDataList() {
        return this.budgetChangedDataList;
    }

    @Override
    public KrmsRulesContext getKrmsRulesContext() {
        return this.getProposalDocument();
    }

    public String getAgencyRoutingIdentifier() {
        return this.agencyRoutingIdentifier;
    }

    public void setAgencyRoutingIdentifier(String agencyRoutingIdentifier) {
        this.agencyRoutingIdentifier = agencyRoutingIdentifier;
    }

    public String getPrevGrantsGovTrackingID() {
        return this.prevGrantsGovTrackingID;
    }

    public void setPrevGrantsGovTrackingID(String prevGrantsGovTrackingID) {
        this.prevGrantsGovTrackingID = prevGrantsGovTrackingID;
    }

    public String getAllUnitNumbers() {
        HashSet<String> unitNumbers = new HashSet<String>();
        unitNumbers.add(this.getOwnedByUnitNumber());
        List<ProposalPerson> proposalPersons = this.getProposalPersons();
        for (ProposalPerson proposalPerson : proposalPersons) {
            List<ProposalPersonUnit> proposalPersonUnits = proposalPerson.getUnits();
            for (ProposalPersonUnit proposalPersonUnit : proposalPersonUnits) {
                unitNumbers.add(proposalPersonUnit.getUnitNumber());
            }
        }
        return StringUtils.join(unitNumbers, (char)',');
    }

    @Override
    public List<? extends DocumentCustomData> getCustomDataList() {
        return this.getDocument().getDocumentCustomData();
    }

    public List<S2sUserAttachedForm> getS2sUserAttachedForms() {
        return this.s2sUserAttachedForms;
    }

    public void setS2sUserAttachedForms(List<S2sUserAttachedForm> s2sUserAttachedForms) {
        this.s2sUserAttachedForms = s2sUserAttachedForms;
    }

    @Override
    public boolean isProposalBudget() {
        return true;
    }

    public BudgetParentDocument<DevelopmentProposal> getDocument() {
        return this.getProposalDocument();
    }

    @Override
    public Budget getNewBudget() {
        return new ProposalDevelopmentBudgetExt();
    }

    @Override
    public Integer getNextBudgetVersionNumber() {
        return this.getDocument().getNextBudgetVersionNumber();
    }

    public List<ProposalDevelopmentBudgetExt> getBudgetVersionOverviews() {
        return this.budgets;
    }

    public void setBudgetVersionOverviews(List<ProposalDevelopmentBudgetExt> budgetVersionOverviews) {
        this.budgets = budgetVersionOverviews;
    }

    public List<ProposalDevelopmentBudgetExt> getBudgets() {
        return this.budgets;
    }

    public void setBudgets(List<ProposalDevelopmentBudgetExt> budgets) {
        this.budgets = budgets;
    }

    public ProposalDevelopmentBudgetExt getLatestBudget() {
        if (this.getBudgets() != null) {
            AbstractBudget latest = null;
            for (ProposalDevelopmentBudgetExt budget : this.getBudgets()) {
                if (latest != null && latest.getBudgetVersionNumber() > budget.getBudgetVersionNumber()) continue;
                latest = budget;
            }
            return latest;
        }
        return null;
    }

    public Optional<ProposalDevelopmentBudgetExt> getActiveBudget() {
        if (this.getFinalBudget() != null) {
            return Optional.of(this.getFinalBudget());
        }
        if (this.getLatestBudget() != null) {
            return Optional.of(this.getLatestBudget());
        }
        return Optional.empty();
    }

    public ProposalDevelopmentBudgetExt getHierarchySummaryBudget() {
        if (this.getLastSyncedBudget() != null) {
            return this.getLastSyncedBudget();
        }
        if (this.getFinalBudget() != null) {
            return this.getFinalBudget();
        }
        if (this.getLatestBudget() != null) {
            return this.getLatestBudget();
        }
        return null;
    }

    public DeadlineType getDeadlineTypeRef() {
        return this.deadlineTypeRef;
    }

    public void setDeadlineTypeRef(DeadlineType deadlineTypeRef) {
        this.deadlineTypeRef = deadlineTypeRef;
    }

    public boolean isSponsorProgramAndDivCodeRequired() {
        boolean success = false;
        Collection sponsorHierarchies = this.getParameterService().getParameterValuesAsString(ProposalDevelopmentDocument.class, "SPONSOR_HIERACHY_REQ_DIV_PROG_CODES");
        for (String sponsorHierarchy : sponsorHierarchies) {
            String[] hierarchyStr = sponsorHierarchy.split(",");
            int level = hierarchyStr.length - 1;
            if (!this.getSponsorHierarchyService().isSponsorInHierarchy(this.getSponsorCode(), hierarchyStr[0], level, hierarchyStr[level])) continue;
            success = true;
            break;
        }
        return success;
    }

    public boolean isNIHSponsor() {
        return this.getSponsorHierarchyService().isSponsorInHierarchy(this.getSponsorCode(), "NIH Multiple PI");
    }

    public Boolean isNihOpportunity() {
        if (!this.nihOpportunityFetched) {
            this.refreshNihOpportunity();
        }
        return this.nihOpportunity;
    }

    public void refreshNihOpportunity() {
        try {
            this.nihOpportunity = this.hasS2sOpportunity() && StringUtils.isNotBlank((CharSequence)this.getS2sOpportunity().getPackageId()) ? Boolean.valueOf(this.getNihSubmissionAgencyDataService().isNIHOpportunity(this.getApplicantOrganization().getOrganization().getDunsNumber(), this.getS2sOpportunity().getPackageId())) : Boolean.valueOf(false);
        }
        catch (S2sCommunicationException e) {
            LOG.error("Failed to check NIH status via NIH SADS service", (Throwable)e);
        }
        finally {
            this.nihOpportunityFetched = true;
        }
    }

    public Timestamp getCreateTimestamp() {
        return Optional.ofNullable(this.createTimestamp).orElse(Optional.ofNullable(this.getProposalDocument()).map(DocumentBase::getDocumentHeader).map(DocumentHeader::getWorkflowDocument).map(DocumentContract::getDateCreated).map(BaseDateTime::getMillis).map(Timestamp::new).orElse(null));
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public ProposalDevelopmentBudgetExt getFinalBudget() {
        return this.finalBudget;
    }

    public void setFinalBudget(ProposalDevelopmentBudgetExt finalBudget) {
        this.finalBudget = finalBudget;
    }

    public ProposalDevelopmentBudgetExt getLastSyncedBudget() {
        return this.lastSyncedBudget;
    }

    public void setLastSyncedBudget(ProposalDevelopmentBudgetExt lastSyncedBudget) {
        this.lastSyncedBudget = lastSyncedBudget;
    }

    public ProposalState getHierarchyAwareProposalStatus() {
        if (this.isChild()) {
            return this.getProposalHierarchyService().getProposalState(this.getHierarchyParentProposalNumber());
        }
        return this.getProposalState();
    }

    public DevelopmentProposal getParent() {
        return this.getProposalHierarchyService().lookupParent(this);
    }

    public LegacyNarrativeService getNarrativeService() {
        if (this.narrativeService == null) {
            this.narrativeService = KcServiceLocator.getService(LegacyNarrativeService.class);
        }
        return this.narrativeService;
    }

    public void setNarrativeService(LegacyNarrativeService narrativeService) {
        this.narrativeService = narrativeService;
    }

    public ProposalPersonBiographyService getProposalPersonBiographyService() {
        if (this.proposalPersonBiographyService == null) {
            this.proposalPersonBiographyService = KcServiceLocator.getService(ProposalPersonBiographyService.class);
        }
        return this.proposalPersonBiographyService;
    }

    public void setProposalPersonBiographyService(ProposalPersonBiographyService proposalPersonBiographyService) {
        this.proposalPersonBiographyService = proposalPersonBiographyService;
    }

    public ProposalDevelopmentService getProposalDevelopmentService() {
        if (this.proposalDevelopmentService == null) {
            this.proposalDevelopmentService = KcServiceLocator.getService(ProposalDevelopmentService.class);
        }
        return this.proposalDevelopmentService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected ProposalHierarchyService getProposalHierarchyService() {
        if (this.proposalHierarchyService == null) {
            this.proposalHierarchyService = KcServiceLocator.getService(ProposalHierarchyService.class);
        }
        return this.proposalHierarchyService;
    }

    protected void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }

    public YnqService getYnqService() {
        if (this.ynqService == null) {
            this.ynqService = KcServiceLocator.getService(YnqService.class);
        }
        return this.ynqService;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        if (this.sponsorHierarchyService == null) {
            this.sponsorHierarchyService = KcServiceLocator.getService(SponsorHierarchyService.class);
        }
        return this.sponsorHierarchyService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public NihSubmissionAgencyDataService getNihSubmissionAgencyDataService() {
        if (this.nihSubmissionAgencyDataService == null) {
            this.nihSubmissionAgencyDataService = KcServiceLocator.getService(NihSubmissionAgencyDataService.class);
        }
        return this.nihSubmissionAgencyDataService;
    }

    public String getAssignerId() {
        return this.assignerId;
    }

    public void setAssignerId(String assignerId) {
        this.assignerId = assignerId;
    }

    public String getApproverId() {
        return this.approverId;
    }

    public void setApproverId(String approverId) {
        this.approverId = approverId;
    }

    public List<ProposalDevelopmentNotification> getNotifications() {
        if (this.notifications == null) {
            Map<String, String> criteria = Collections.singletonMap("OWNING_DOCUMENT_ID_FK", this.getProposalNumber());
            this.notifications = new ArrayList<ProposalDevelopmentNotification>(this.getBusinessObjectService().findMatching(ProposalDevelopmentNotification.class, criteria));
        }
        return this.notifications;
    }

    public void setNotifications(List<ProposalDevelopmentNotification> proposalDevelopmentNotifications) {
        this.notifications = proposalDevelopmentNotifications;
    }

    public void addNotification(ProposalDevelopmentNotification notification) {
        this.getNotifications().add(notification);
    }

    public GrantForwardRecord getGrantForwardRecord() {
        return this.grantForwardRecord;
    }

    public void setGrantForwardRecord(GrantForwardRecord grantForwardRecord) {
        this.grantForwardRecord = grantForwardRecord;
    }

    public List<PreproposalFormBo> getPreproposalForms() {
        return this.preproposalForms;
    }

    public void setPreproposalForms(List<PreproposalFormBo> preproposalForms) {
        this.preproposalForms = preproposalForms;
    }

    public List<ProposalStandaloneBudgetBo> getProposalStandaloneBudgets() {
        return this.getDataObjectService().findMatching(ProposalStandaloneBudgetBo.class, QueryByCriteria.Builder.forAttribute((String)"proposalNumber", (Object)this.getProposalNumber()).build()).getResults();
    }

    public ProposalStandaloneBudgetBo getProposalFinalStandaloneBudget() {
        return this.getProposalStandaloneBudgets().stream().filter(budget -> "finalized".equals(budget.getStatus()) || "submitted".equals(budget.getStatus())).findFirst().orElse(null);
    }

    public MailType getMailTypeRef() {
        return this.mailTypeRef;
    }

    public void setMailTypeRef(MailType mailTypeRef) {
        this.mailTypeRef = mailTypeRef;
    }

    public MailBy getMailByRef() {
        return this.mailByRef;
    }

    public void setMailByRef(MailBy mailByRef) {
        this.mailByRef = mailByRef;
    }

    protected void preRemove() {
        this.getDataObjectService().deleteMatching(ProposalStandaloneBudgetBo.class, QueryByCriteria.Builder.forAttribute((String)"proposalNumber", (Object)this.getProposalNumber()).build());
        super.preRemove();
    }

    public static class DevelopmentProposalCustomizer
    extends CompositeDescriptorCustomizer {
        private static final Collection<DescriptorCustomizer> CUSTOMIZERS;

        @Override
        protected Collection<DescriptorCustomizer> getCustomizers() {
            return CUSTOMIZERS;
        }

        static {
            ArrayList<Object> customizers = new ArrayList<Object>();
            customizers.add(new NarrativeCustomizer());
            customizers.add(new InstituteAttachmentsCustomizer());
            CUSTOMIZERS = Collections.unmodifiableCollection(customizers);
        }
    }

    public static class InstituteAttachmentsCustomizer
    implements DescriptorCustomizer {
        private static final String INSTITUTE_ATTACHMENTS = "instituteAttachments";

        public void customize(ClassDescriptor descriptor) {
            String value = this.getParameterService().getParameterValueAsString("KC-PD", "Document", "instituteNarrativeTypeGroup");
            ForeignReferenceMapping frMapping = (ForeignReferenceMapping)descriptor.getMappingForAttributeName(INSTITUTE_ATTACHMENTS);
            ExpressionBuilder eb = new ExpressionBuilder(Narrative.class);
            Expression fkExp = eb.getField(DevelopmentProposal.PROPOSAL_NUMBER).equal(eb.getParameter(DevelopmentProposal.PROPOSAL_NUMBER));
            frMapping.setSelectionCriteria(fkExp.and(eb.get(DevelopmentProposal.NARRATIVE_TYPE).get(DevelopmentProposal.NARRATIVE_TYPE_GROUP).equal((Object)value)));
        }

        protected ParameterService getParameterService() {
            return KcServiceLocator.getService(ParameterService.class);
        }
    }

    public static class NarrativeCustomizer
    implements DescriptorCustomizer {
        private static final String NARRATIVES = "narratives";

        public void customize(ClassDescriptor descriptor) {
            String value = this.getParameterService().getParameterValueAsString("KC-PD", "Document", "proposalNarrativeTypeGroup");
            ForeignReferenceMapping frMapping = (ForeignReferenceMapping)descriptor.getMappingForAttributeName(NARRATIVES);
            ExpressionBuilder eb = new ExpressionBuilder(Narrative.class);
            Expression fkExp = eb.getField(DevelopmentProposal.PROPOSAL_NUMBER).equal(eb.getParameter(DevelopmentProposal.PROPOSAL_NUMBER));
            frMapping.setSelectionCriteria(fkExp.and(eb.get(DevelopmentProposal.NARRATIVE_TYPE).get(DevelopmentProposal.NARRATIVE_TYPE_GROUP).equal((Object)value)));
        }

        protected ParameterService getParameterService() {
            return KcServiceLocator.getService(ParameterService.class);
        }
    }
}

