/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.question;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireUsage;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sModuleQuestionnaireBean;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sQuestionnaireService;
import org.kuali.coeus.propdev.impl.s2s.question.S2sOppFormQuestionnaire;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalDevelopmentS2sQuestionnaireService")
public class ProposalDevelopmentS2sQuestionnaireServiceImpl
implements ProposalDevelopmentS2sQuestionnaireService {
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentS2sQuestionnaireServiceImpl.class);
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    private QuestionnaireAnswerService questionnaireAnswerService;
    @Autowired
    @Qualifier(value="questionnaireService")
    private QuestionnaireService questionnaireService;

    @Override
    public List<AnswerHeader> getProposalAnswerHeaderForForm(DevelopmentProposal proposal, String oppNameSpace, String formName) {
        return this.getProposalS2sAnswerHeaders(proposal, oppNameSpace, formName);
    }

    @Override
    public List<AnswerHeader> getProposalS2sAnswerHeaders(DevelopmentProposal developmentProposal) {
        return this.getProposalS2sAnswerHeaders(developmentProposal, null, null);
    }

    protected List<AnswerHeader> getProposalS2sAnswerHeaders(DevelopmentProposal developmentProposal, String oppNameSpace, String formName) {
        S2sOpportunity opp = developmentProposal.getS2sOpportunity();
        HashSet<AnswerHeader> results = new HashSet<AnswerHeader>();
        List<AnswerHeader> rawAnswerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(this.getModuleQnBean(developmentProposal));
        if (opp != null) {
            for (AnswerHeader header : rawAnswerHeaders) {
                for (S2sOppForms oppForms : opp.getS2sOppForms()) {
                    if (oppNameSpace != null && !StringUtils.equals((CharSequence)oppForms.getS2sOppFormsId().getOppNameSpace(), (CharSequence)oppNameSpace) || formName != null && !StringUtils.equals((CharSequence)oppForms.getFormName(), (CharSequence)formName) || !(oppForms.getInclude() == null ? Boolean.FALSE : oppForms.getInclude()).booleanValue()) continue;
                    List<QuestionnaireUsage> usages = this.getQuestionnaireUsages(oppForms.getS2sOppFormsId().getOppNameSpace(), oppForms.getFormName(), developmentProposal);
                    for (QuestionnaireUsage usage : usages) {
                        if (!header.getQuestionnaire().getQuestionnaireSeqId().equals(usage.getQuestionnaire().getQuestionnaireSeqId())) continue;
                        results.add(header);
                    }
                }
            }
        }
        return new ArrayList<AnswerHeader>(results);
    }

    @Override
    public List<QuestionnaireUsage> getQuestionnaireUsages(String oppNameSpace, String formName, DevelopmentProposal proposal) {
        HashSet<QuestionnaireUsage> result = new HashSet<QuestionnaireUsage>();
        ModuleQuestionnaireBean questionnaireBean = this.getModuleQnBean(proposal);
        questionnaireBean.setModuleSubItemCode("2");
        List<QuestionnaireUsage> usages = this.getQuestionnaireAnswerService().getPublishedQuestionnaire(questionnaireBean);
        List<S2sOppFormQuestionnaire> s2sOppFormQuestionnaires = this.findOppFormToQuestionnaires(oppNameSpace, formName);
        for (QuestionnaireUsage usage : usages) {
            for (S2sOppFormQuestionnaire oppFormQuestionnaire : s2sOppFormQuestionnaires) {
                if (!oppFormQuestionnaire.getQuestionnaireId().toString().equals(usage.getQuestionnaire().getQuestionnaireSeqId())) continue;
                result.add(usage);
            }
        }
        return new ArrayList<QuestionnaireUsage>(result);
    }

    protected List<S2sOppFormQuestionnaire> findOppFormToQuestionnaires(String oppNameSpace, String formName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Looking up S2sOppFormQuestionnaire for (%s,%s)", oppNameSpace, formName));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oppNameSpace", oppNameSpace);
        params.put("formName", formName);
        List oppFormToQuestionnaires = this.getBusinessObjectService().findMatching(S2sOppFormQuestionnaire.class, params);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Found S2sOppFormQuestionnaire records for (%s,%s)", oppNameSpace, formName));
            for (S2sOppFormQuestionnaire oppFormQuest : oppFormToQuestionnaires) {
                LOG.debug((Object)oppFormQuest);
            }
        }
        return oppFormToQuestionnaires;
    }

    public ModuleQuestionnaireBean getModuleQnBean(DevelopmentProposal proposal) {
        ProposalDevelopmentS2sModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalDevelopmentS2sModuleQuestionnaireBean(proposal);
        return moduleQuestionnaireBean;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public QuestionnaireService getQuestionnaireService() {
        return this.questionnaireService;
    }

    public void setQuestionnaireService(QuestionnaireService questionnaireService) {
        this.questionnaireService = questionnaireService;
    }
}

