/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.ynq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentRule;
import org.kuali.coeus.propdev.impl.ynq.ProposalYnq;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentYnqAuditRule
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private static final String PROPOSAL_QUESTIONS_KEY = "document.developmentProposalList[0].proposalYnq[%d].%s";
    private static final String PROPOSAL_QUESTIONS_PANEL_KEY = "ynqAuditErrors%s";

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        for (int j = 0; j < proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs().size(); ++j) {
            String explanationRequiredFor;
            String dateRequiredFor;
            ProposalYnq proposalYnq = proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs().get(j);
            String groupName = proposalYnq.getYnq().getGroupName();
            String ynqAnswer = proposalYnq.getAnswer();
            HashMap<String, Integer> questionSerials = ProposalDevelopmentDocumentRule.getQuestionSerialNumberBasedOnGroup(proposalDevelopmentDocument);
            if (StringUtils.isBlank((CharSequence)proposalYnq.getAnswer())) {
                valid = false;
                this.getProposalYnqAuditErrorsByGroup(groupName).add(new AuditError(String.format(PROPOSAL_QUESTIONS_KEY, j, "answer"), "error.required.answer", "PropDev-QuestionnairePage." + groupName, new String[]{questionSerials.get(proposalYnq.getQuestionId()).toString(), groupName}));
            }
            if ((dateRequiredFor = proposalYnq.getYnq().getDateRequiredFor()) != null && StringUtils.isNotBlank((CharSequence)ynqAnswer) && dateRequiredFor.contains(ynqAnswer) && proposalYnq.getReviewDate() == null) {
                valid = false;
                this.getProposalYnqAuditErrorsByGroup(groupName).add(new AuditError(String.format(PROPOSAL_QUESTIONS_KEY, j, "reviewDate"), "error.required.for.reviewDate", "PropDev-QuestionnairePage." + groupName, new String[]{questionSerials.get(proposalYnq.getQuestionId()).toString(), groupName}));
            }
            if ((explanationRequiredFor = proposalYnq.getYnq().getExplanationRequiredFor()) == null || !StringUtils.isNotBlank((CharSequence)ynqAnswer) || !explanationRequiredFor.contains(ynqAnswer) || !StringUtils.isBlank((CharSequence)proposalYnq.getExplanation())) continue;
            valid = false;
            this.getProposalYnqAuditErrorsByGroup(groupName).add(new AuditError(String.format(PROPOSAL_QUESTIONS_KEY, j, "explanation"), "error.required.for.explanation", "PropDev-QuestionnairePage." + groupName, new String[]{questionSerials.get(proposalYnq.getQuestionId()).toString(), groupName}));
        }
        return valid;
    }

    private List<AuditError> getProposalYnqAuditErrorsByGroup(String groupName) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String key = String.format(PROPOSAL_QUESTIONS_PANEL_KEY, groupName);
        if (!GlobalVariables.getAuditErrorMap().containsKey(key)) {
            GlobalVariables.getAuditErrorMap().put(key, new AuditCluster(groupName, auditErrors, "Error"));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(key)).getAuditErrorList();
        }
        return auditErrors;
    }
}

