/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting.service;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.AwardReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingPrint;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingPrintingService;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingType;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ReportTrackingPrintingServiceImpl
implements ReportTrackingPrintingService {
    private PrintingService printingService;
    private BusinessObjectService businessObjectService;
    private ReportTrackingPrint reportTrackingPrint;

    @Override
    public AttachmentDataSource printAwardReportTracking(List<Printable> printableArtifactList) throws PrintingException {
        AttachmentDataSource attachmentDataSource = this.getPrintingService().print(printableArtifactList);
        String fileName = "ReportTrackingPrint.pdf";
        attachmentDataSource.setName(URLEncoder.encode(fileName, StandardCharsets.UTF_8));
        attachmentDataSource.setType("application/pdf");
        return attachmentDataSource;
    }

    @Override
    public AwardReportTracking getReportPrintable(ReportTrackingType reportType, ReportTracking detailResult, AwardReportTracking printable) {
        switch (reportType) {
            case AWARD_REPORT_TRACKING: {
                printable = this.getReportTrackingPrint();
                printable.setPrintableBusinessObject(detailResult);
            }
        }
        return printable;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public ReportTrackingPrint getReportTrackingPrint() {
        return this.reportTrackingPrint;
    }

    public void setReportTrackingPrint(ReportTrackingPrint reportTrackingPrint) {
        this.reportTrackingPrint = reportTrackingPrint;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

