/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.service.AwardDirectFandADistributionService;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AwardDirectFandADistributionServiceImpl
implements AwardDirectFandADistributionService {
    @Override
    public List<AwardDirectFandADistribution> generateDefaultAwardDirectFandADistributionPeriods(Award award) {
        return this.buildListBasedOnProjectStartAndEndDates(award);
    }

    protected List<AwardDirectFandADistribution> buildListBasedOnProjectStartAndEndDates(Award award) {
        Date periodEndDate;
        ArrayList<AwardDirectFandADistribution> awardDirectFandADistributions = new ArrayList<AwardDirectFandADistribution>();
        Date projectStartDate = award.getAwardEffectiveDate();
        AwardAmountInfo latestAwardAmountInfo = award.getAwardAmountInfos().get(award.getAwardAmountInfos().size() - 1);
        Date projectEndDate = latestAwardAmountInfo.getFinalExpirationDate();
        Calendar cl = Calendar.getInstance();
        Date periodStartDate = projectStartDate;
        int budgetPeriodNum = 1;
        while (true) {
            cl.setTime(periodStartDate);
            cl.add(1, 1);
            Date nextPeriodStartDate = new Date(cl.getTime().getTime());
            cl.add(5, -1);
            periodEndDate = new Date(cl.getTime().getTime());
            if (periodEndDate.after(projectEndDate) || periodEndDate.equals(projectEndDate)) break;
            awardDirectFandADistributions.add(new AwardDirectFandADistribution(budgetPeriodNum, periodStartDate, periodEndDate));
            periodStartDate = nextPeriodStartDate;
            ++budgetPeriodNum;
        }
        periodEndDate = projectEndDate;
        awardDirectFandADistributions.add(new AwardDirectFandADistribution(budgetPeriodNum, periodStartDate, periodEndDate));
        return awardDirectFandADistributions;
    }
}

