/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.scheduling.seq;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.kuali.coeus.sys.framework.scheduling.seq.ScheduleSequence;
import org.kuali.coeus.sys.framework.scheduling.seq.ScheduleSequenceDecorator;

public class WeekScheduleSequenceDecorator
extends ScheduleSequenceDecorator {
    private Integer frequency;
    private Integer dayCount;

    public WeekScheduleSequenceDecorator(ScheduleSequence scheduleSequence, Integer frequency, Integer dayCount) {
        super(scheduleSequence);
        this.frequency = frequency;
        this.dayCount = dayCount;
    }

    @Override
    public List<Date> executeScheduleSequence(String expression, Date startDate, Date endDate) throws ParseException {
        List<Date> dates = this.scheduleSequence.executeScheduleSequence(expression, startDate, endDate);
        if (this.frequency != 1) {
            ArrayList<Date> filteredDates = new ArrayList<Date>();
            Iterator<Date> it = dates.iterator();
            while (it.hasNext()) {
                int i;
                for (i = 0; i < this.dayCount && it.hasNext(); ++i) {
                    Date dt = it.next();
                    filteredDates.add(dt);
                }
                for (i = 0; i < this.dayCount * (this.frequency - 1) && it.hasNext(); ++i) {
                    it.next();
                }
            }
            dates = filteredDates;
        }
        return dates;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dayCount == null ? 0 : this.dayCount.hashCode());
        result = 31 * result + (this.frequency == null ? 0 : this.frequency.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WeekScheduleSequenceDecorator other = (WeekScheduleSequenceDecorator)obj;
        return Objects.equals(this.dayCount, other.dayCount) && Objects.equals(this.frequency, other.frequency);
    }
}

