/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.standalone;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kuali.coeus.common.budget.api.standalone.StandaloneBudget;
import org.kuali.coeus.propdev.impl.budget.standalone.ProposalStandaloneBudgetBo;
import org.kuali.coeus.propdev.impl.budget.standalone.StandaloneBudgetCacheService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="standaloneBudgetCacheService")
public class StandaloneBudgetCacheServiceImpl
implements StandaloneBudgetCacheService {
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    @Override
    public void updateCache(List<? extends StandaloneBudget> budgets, List<ProposalStandaloneBudgetBo> budgetCache) {
        List<StandaloneBudget> nullSafeBudgets = Optional.ofNullable(budgets).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).toList();
        List<ProposalStandaloneBudgetBo> nullSafeBudgetCache = Optional.ofNullable(budgetCache).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).toList();
        Map<Boolean, List<ProposalStandaloneBudgetBo>> partition = nullSafeBudgetCache.stream().collect(Collectors.partitioningBy(cache -> nullSafeBudgets.stream().anyMatch(budget -> budget.getBudgetId().equals(cache.getBudgetId()))));
        List<ProposalStandaloneBudgetBo> matches = partition.get(Boolean.TRUE);
        List<ProposalStandaloneBudgetBo> notMatches = partition.get(Boolean.FALSE);
        notMatches.forEach(arg_0 -> ((DataObjectService)this.dataObjectService).delete(arg_0));
        nullSafeBudgets.forEach(budget -> this.updateCache((StandaloneBudget)budget, matches.stream().filter(cache -> cache.getBudgetId().equals(budget.getBudgetId())).findFirst()));
    }

    private void updateCache(StandaloneBudget budget, Optional<ProposalStandaloneBudgetBo> budgetCache) {
        if (budgetCache.isPresent()) {
            ProposalStandaloneBudgetBo cache = budgetCache.get();
            if (!Objects.equals(budget.getStatus(), cache.getStatus()) || !Objects.equals(budget.getDescription(), cache.getDescription())) {
                cache.setDescription(budget.getDescription());
                cache.setStatus(budget.getStatus());
                this.dataObjectService.save((Object)cache, new PersistenceOption[]{PersistenceOption.FLUSH});
            }
        } else {
            this.dataObjectService.save((Object)new ProposalStandaloneBudgetBo(budget.getProposalNumber(), budget.getBudgetId(), budget.getDescription(), budget.getStatus()), new PersistenceOption[]{PersistenceOption.FLUSH});
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

