/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.attachment;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.common.framework.version.sequence.associate.SeparateAssociate;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.maintenance.MutableFormFile;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.bo.PersistableAttachment;

public class AttachmentFile
extends SeparateAssociate
implements KcFile,
PersistableAttachment {
    private static final Logger LOG = LogManager.getLogger(AttachmentFile.class);
    public static final int MAX_FILE_NAME_LENGTH = 150;
    public static final int MAX_FILE_TYPE_LENGTH = 250;
    private static final long serialVersionUID = 8999619585664343780L;
    private String name;
    private String type;
    private transient WeakReference<byte[]> fileDataData;
    private byte[] data;
    private String fileDataId;
    private String oldFileDataId;
    private transient KcAttachmentDataDao kcAttachmentDataDao;
    private transient FormFile formFile;

    public AttachmentFile() {
    }

    public AttachmentFile(String name, String type, byte[] data) {
        this.setName(name);
        this.setType(type);
        this.setData(data);
    }

    public static AttachmentFile createFromFormFile(FormFile formFile) {
        if (formFile == null) {
            throw new IllegalArgumentException("the formFile is null");
        }
        String fName = AttachmentFile.removeFrontForLength(formFile.getFileName(), 150);
        String fType = AttachmentFile.removeFrontForLength(formFile.getContentType(), 250);
        try {
            return new AttachmentFile(fName, fType, formFile.getFileData());
        }
        catch (IOException e) {
            throw new CreateException(e);
        }
    }

    static String removeFrontForLength(String aString, int aLength) {
        assert (aString != null) : "aString is null";
        assert (aLength > 0) : "aLength is negative: " + aLength;
        if (aString.length() > aLength) {
            StringBuilder tempString = new StringBuilder(aString);
            tempString.delete(0, tempString.length() - aLength);
            return tempString.toString();
        }
        return aString;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public byte[] getData() {
        if (this.fileDataId != null) {
            byte[] existingData;
            if (this.fileDataData != null && (existingData = (byte[])this.fileDataData.get()) != null) {
                return existingData;
            }
            byte[] newData = this.getKcAttachmentDataDao().getData(this.fileDataId);
            this.fileDataData = new WeakReference<byte[]>(newData);
            return newData;
        }
        return this.data == null ? null : (byte[])this.data.clone();
    }

    public void setData(byte[] data) {
        if (data == null || data.length == 0) {
            this.setFileDataId(null);
        } else {
            this.setFileDataId(this.getKcAttachmentDataDao().saveData(data, null));
        }
        this.fileDataData = new WeakReference<byte[]>(data);
        this.data = null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.getData());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentFile other = (AttachmentFile)obj;
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getType() == null ? other.getType() != null : !this.getType().equals(other.getType()));
    }

    public byte[] getAttachmentContent() {
        return this.getData();
    }

    public void setAttachmentContent(byte[] attachmentContent) {
        this.setData(attachmentContent);
    }

    public String getFileNameForDisplay() {
        if (this.getFormFile() != null && StringUtils.isNotBlank((CharSequence)this.getFormFile().getFileName())) {
            return this.getFormFile().getFileName();
        }
        return this.getFileName();
    }

    public String getFileName() {
        return this.getName();
    }

    public void setFileName(String fileName) {
        this.setName(fileName);
    }

    public String getContentType() {
        return this.getType();
    }

    public void setContentType(String contentType) {
        this.setType(contentType);
    }

    public FormFile getFormFile() {
        if ((this.formFile == null || StringUtils.isBlank((CharSequence)this.formFile.getFileName())) && StringUtils.isNotBlank((CharSequence)this.name)) {
            this.formFile = new MutableFormFile(this.getName(), this.getType(), this.getData());
        }
        return this.formFile;
    }

    public void setFormFile(FormFile formFile) {
        this.formFile = formFile;
        if (!(formFile instanceof MutableFormFile)) {
            this.populateAttachment(this.formFile);
        }
    }

    public void populateAttachment(FormFile formFile) {
        if (formFile == null) {
            return;
        }
        try {
            byte[] newFileData = formFile.getFileData();
            this.setAttachmentContent(newFileData);
            if (newFileData.length > 0) {
                this.setContentType(formFile.getContentType());
                this.setFileName(formFile.getFileName());
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    public String getFileDataId() {
        return this.fileDataId;
    }

    public void setFileDataId(String fileDataId) {
        if (!StringUtils.equals((CharSequence)this.fileDataId, (CharSequence)fileDataId)) {
            this.oldFileDataId = this.fileDataId;
        }
        this.fileDataId = fileDataId;
    }

    public void postRemove() {
        super.postRemove();
        if (this.getFileDataId() != null) {
            this.getKcAttachmentDataDao().removeData(this.getFileDataId());
        }
    }

    public void postUpdate() {
        super.postUpdate();
        if (this.oldFileDataId != null && !StringUtils.equals((CharSequence)this.fileDataId, (CharSequence)this.oldFileDataId)) {
            this.getKcAttachmentDataDao().removeData(this.oldFileDataId);
            this.oldFileDataId = null;
        }
    }

    public KcAttachmentDataDao getKcAttachmentDataDao() {
        if (this.kcAttachmentDataDao == null) {
            this.kcAttachmentDataDao = KcServiceLocator.getService(KcAttachmentDataDao.class);
        }
        return this.kcAttachmentDataDao;
    }

    public void setKcAttachmentDataDao(KcAttachmentDataDao kcAttachmentDao) {
        this.kcAttachmentDataDao = kcAttachmentDao;
    }

    public static class CreateException
    extends RuntimeException {
        private static final long serialVersionUID = -230592614193518930L;

        public CreateException(Throwable t) {
            super(t);
        }
    }
}

