/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.compliance.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewType;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewUsage;
import org.kuali.coeus.sys.framework.keyvalue.FormViewAwareUifKeyValuesFinderBase;
import org.kuali.coeus.sys.framework.keyvalue.PrefixValuesFinder;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.view.JstlFunctions;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class SpecialReviewTypeValuesFinder
extends FormViewAwareUifKeyValuesFinderBase {
    private static final String MODULE_CODE_NAME = "moduleCode";
    private static final String PERMISSION_NAME = "View Active Special Review Types";
    private static final ConcreteKeyValue PREFIX_KEY_VALUE = new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue());
    private transient KeyValuesService keyValuesService;
    private transient BusinessObjectService businessObjectService;
    private transient PermissionService permissionService;

    public List<KeyValue> getKeyValues() {
        List<KeyValue> keyValues = this.filterActiveSpecialReviewUsageTypes(this.createKeyValues());
        keyValues.add(0, (KeyValue)PREFIX_KEY_VALUE);
        return keyValues;
    }

    private List<KeyValue> createKeyValues() {
        boolean isExconProtocolLinkingEnabled = JstlFunctions.isProfileActive("excon");
        return this.getKeyValuesService().findAllOrderBy(SpecialReviewType.class, "sortId", true).stream().filter(specialReviewType -> isExconProtocolLinkingEnabled || !"RESBOOT-1000".equals(specialReviewType.getSpecialReviewTypeCode())).map(specialReviewType -> new ConcreteKeyValue(specialReviewType.getSpecialReviewTypeCode(), specialReviewType.getDescription())).collect(Collectors.toList());
    }

    private List<KeyValue> filterActiveSpecialReviewUsageTypes(List<KeyValue> unfilteredKeyValues) {
        ArrayList<KeyValue> filteredKeyValues = new ArrayList<KeyValue>();
        boolean canViewNonGlobalSpecialReviewTypes = this.getPermissionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", PERMISSION_NAME);
        boolean documentReadOnly = this.isDocumentReadOnly();
        Collection<SpecialReviewUsage> specialReviewUsages = this.getSpecialReviewUsages();
        for (KeyValue item : unfilteredKeyValues) {
            SpecialReviewUsage itemSpecialReviewUsage = null;
            for (SpecialReviewUsage specialReviewUsage : specialReviewUsages) {
                if (!StringUtils.equals((CharSequence)specialReviewUsage.getSpecialReviewTypeCode(), (CharSequence)String.valueOf(item.getKey()))) continue;
                itemSpecialReviewUsage = specialReviewUsage;
                break;
            }
            if (itemSpecialReviewUsage == null) continue;
            if (itemSpecialReviewUsage.isActive() && (itemSpecialReviewUsage.isGlobal() || canViewNonGlobalSpecialReviewTypes)) {
                filteredKeyValues.add(item);
                continue;
            }
            if (!documentReadOnly) continue;
            filteredKeyValues.add(item);
        }
        return filteredKeyValues;
    }

    protected abstract boolean isDocumentReadOnly();

    public abstract String getModuleCode();

    private Collection<SpecialReviewUsage> getSpecialReviewUsages() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_CODE_NAME, this.getModuleCode());
        return this.getBusinessObjectService().findMatching(SpecialReviewUsage.class, fieldValues);
    }

    public KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = KcServiceLocator.getService(KeyValuesService.class);
        }
        return this.keyValuesService;
    }

    public void setKeyValuesService(KeyValuesService keyValuesService) {
        this.keyValuesService = keyValuesService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

