/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.framework.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireUsage;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class QuestionnaireHelperBase
implements Serializable {
    private static final long serialVersionUID = 180986754611233315L;
    protected static final String UPDATE_WITH_NO_ANSWER_COPY = "1";
    private boolean answerQuestionnaire = false;
    private List<AnswerHeader> answerHeaders;
    @Deprecated
    private List<String> headerLabels;
    private transient QuestionnaireAnswerService questionnaireAnswerService;

    public abstract String getModuleCode();

    public abstract ModuleQuestionnaireBean getModuleQnBean();

    @Deprecated
    public void resetHeaderLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (AnswerHeader answerHeader : this.answerHeaders) {
            String label = this.getQuestionnaireLabel(answerHeader.getQuestionnaire().getQuestionnaireUsages(), answerHeader.getModuleSubItemCode());
            labels.add(label);
            answerHeader.setLabel(label);
        }
        this.setHeaderLabels(labels);
    }

    @Deprecated
    protected String getQuestionnaireLabel(List<QuestionnaireUsage> usages, String moduleSubItemCode) {
        if (CollectionUtils.isNotEmpty(usages) && usages.size() > 1) {
            Collections.sort(usages);
        }
        for (QuestionnaireUsage usage : usages) {
            if (!this.getModuleCode().equals(usage.getModuleItemCode()) || !moduleSubItemCode.equals(usage.getModuleSubItemCode())) continue;
            return usage.getQuestionnaireLabel();
        }
        return null;
    }

    public void setQuestionnaireActiveStatuses() {
        for (AnswerHeader answerHeader : this.answerHeaders) {
            answerHeader.setActiveQuestionnaire(this.isQuestionnaireActive(answerHeader));
        }
    }

    protected boolean isQuestionnaireActive(AnswerHeader answerHeader) {
        Integer questionniareSeqId = answerHeader.getQuestionnaire().getQuestionnaireSeqIdAsInteger();
        String coeusModuleCode = answerHeader.getModuleItemCode();
        String coeusSubModuleCode = answerHeader.getModuleSubItemCode();
        return this.getQuestionnaireAnswerService().checkIfQuestionnaireIsActiveForModule(questionniareSeqId, coeusModuleCode, coeusSubModuleCode);
    }

    public void updateQuestionnaireAnswer(int answerHeaderIndex) {
        AnswerHeader answerHeader = this.answerHeaders.get(answerHeaderIndex);
        if (UPDATE_WITH_NO_ANSWER_COPY.equals(answerHeader.getUpdateOption())) {
            this.answerHeaders.remove(answerHeaderIndex);
            this.answerHeaders.add(answerHeaderIndex, this.getQuestionnaireAnswerService().getNewVersionAnswerHeader(this.getModuleQnBean(), answerHeader.getQuestionnaire()));
        } else {
            AnswerHeader newAnswerHeader = this.getQuestionnaireAnswerService().getNewVersionAnswerHeader(this.getModuleQnBean(), answerHeader.getQuestionnaire());
            this.getQuestionnaireAnswerService().copyAnswerToNewVersion(answerHeader, newAnswerHeader);
            this.answerHeaders.remove(answerHeaderIndex);
            this.answerHeaders.add(answerHeaderIndex, newAnswerHeader);
        }
        this.resetHeaderLabels();
    }

    public void preSave() {
        this.getQuestionnaireAnswerService().preSave(this.answerHeaders);
    }

    public void updateChildIndicators() {
        for (AnswerHeader answerHeader : this.answerHeaders) {
            this.getQuestionnaireAnswerService().setupChildAnswerIndicator(answerHeader);
        }
    }

    public void populateAnswers() {
        this.setAnswerHeaders(this.getQuestionnaireAnswerService().getQuestionnaireAnswer(this.getModuleQnBean()));
        this.resetHeaderLabels();
    }

    public boolean isAnswerQuestionnaire() {
        return this.answerQuestionnaire;
    }

    public void setAnswerQuestionnaire(boolean answerQuestionnaire) {
        this.answerQuestionnaire = answerQuestionnaire;
    }

    public List<AnswerHeader> getAnswerHeaders() {
        return this.answerHeaders;
    }

    public void setAnswerHeaders(List<AnswerHeader> answerHeaders) {
        this.answerHeaders = answerHeaders;
    }

    @Deprecated
    public List<String> getHeaderLabels() {
        return this.headerLabels;
    }

    @Deprecated
    public void setHeaderLabels(List<String> headerLabels) {
        this.headerLabels = headerLabels;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        if (this.questionnaireAnswerService == null) {
            this.questionnaireAnswerService = KcServiceLocator.getService(QuestionnaireAnswerService.class);
        }
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KcServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public String getRuleReferenced() {
        return this.getModuleQnBean().getRuleResults();
    }
}

