/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunityLookupKradKnsHelperService;
import org.kuali.coeus.propdev.impl.s2s.S2sSubmissionService;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="s2sOpportunityLookupKradKnsHelperService")
public class S2sOpportunityLookupKradKnsHelperServiceImpl
implements S2sOpportunityLookupKradKnsHelperService {
    private static final Logger LOG = LogManager.getLogger(S2sOpportunityLookupKradKnsHelperServiceImpl.class);
    @Autowired
    @Qualifier(value="s2sSubmissionService")
    private S2sSubmissionService s2sSubmissionService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Override
    public List<S2sOpportunity> performSearch(String providerCode, String cfdaNumber, String competitionId, String opportunityId, String packageId) {
        if (StringUtils.isBlank((CharSequence)providerCode)) {
            this.globalVariableService.getMessageMap().putError("providerCode", "error.s2sopportunity.invalidProvider", new String[0]);
        }
        if (this.globalVariableService.getMessageMap().hasNoErrors()) {
            try {
                return this.getS2sSubmissionService().searchOpportunity(providerCode, cfdaNumber, opportunityId, competitionId, packageId);
            }
            catch (S2sCommunicationException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.getGlobalVariableService().getMessageMap().putError("noField", e.getErrorKey(), new String[]{e.getMessage()});
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    protected S2sSubmissionService getS2sSubmissionService() {
        return this.s2sSubmissionService;
    }

    public void setS2sSubmissionService(S2sSubmissionService s2sSubmissionService) {
        this.s2sSubmissionService = s2sSubmissionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

