/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.resource;

import java.util.Arrays;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component(value="allowListResourceLoader")
public class AllowListResourceLoader
implements ResourceLoader,
ResourceLoaderAware {
    private static final String ALLOW_LIST_RESOURCE_PREFIXES = "allow.list.resource.prefixes";
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Resource getResource(String location) {
        String allowList = this.configurationService.getPropertyValueAsString(ALLOW_LIST_RESOURCE_PREFIXES);
        boolean matches = Arrays.stream(allowList.split(",")).map(String::trim).anyMatch(location::startsWith);
        if (!matches) {
            throw new IllegalArgumentException("location not accessible " + location);
        }
        return this.resourceLoader.getResource(location);
    }

    public ClassLoader getClassLoader() {
        return this.resourceLoader.getClassLoader();
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

