/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.shipment.web.struts.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.mail.KcEmailService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.controller.KcTransactionalDocumentActionBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.excon.project.ExconProjectRestrictedCountry;
import org.kuali.kra.excon.shipment.ExconIntlShipment;
import org.kuali.kra.excon.shipment.document.ExconIntlShipmentDocument;
import org.kuali.kra.excon.shipment.document.ExconIntlShipmentDocumentRule;
import org.kuali.kra.excon.shipment.web.struts.form.ExconIntlShipmentForm;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconIntlShipmentAction
extends KcTransactionalDocumentActionBase {
    private transient AuditHelper auditHelper;
    private transient KcEmailService kcEmailService;
    private transient KcPersonService kcPersonService;
    private transient RoleService roleService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        if (GlobalVariables.getAuditErrorMap().isEmpty()) {
            this.getAuditHelper().auditConditionally((ExconIntlShipmentForm)form);
        }
        return actionForward;
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconIntlShipmentForm exconIntlShipmentForm = (ExconIntlShipmentForm)form;
        ActionForward forward = this.handleDocument(mapping, form, request, response, exconIntlShipmentForm);
        exconIntlShipmentForm.initializeFormOrDocumentBasedOnCommand();
        ExconIntlShipment exconIntlShipment = exconIntlShipmentForm.getExconIntlShipment();
        exconIntlShipmentForm.getExconIntlShipmentDocument().setExconIntlShipment(exconIntlShipment);
        return forward;
    }

    ActionForward handleDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ExconIntlShipmentForm exconIntlShipmentForm) throws Exception {
        ActionForward forward = null;
        String command = exconIntlShipmentForm.getCommand();
        if ("displayActionListInlineView".equals(command)) {
            this.loadDocumentInForm(request, exconIntlShipmentForm);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        return forward;
    }

    protected void loadDocumentInForm(HttpServletRequest request, ExconIntlShipmentForm exconIntlShipmentForm) throws WorkflowException {
        String docIdRequestParameter = request.getParameter("docId");
        ExconIntlShipmentDocument retrievedDocument = (ExconIntlShipmentDocument)this.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
        exconIntlShipmentForm.setDocument(retrievedDocument);
        request.setAttribute("docId", (Object)docIdRequestParameter);
    }

    protected void loadDocument(KualiDocumentFormBase kualiForm) throws WorkflowException {
        super.loadDocument(kualiForm);
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconIntlShipmentForm exconIntlShipmentForm = (ExconIntlShipmentForm)form;
        ExconIntlShipment exconIntlShipment = exconIntlShipmentForm.getExconIntlShipmentDocument().getExconIntlShipment();
        boolean passed = new ExconIntlShipmentDocumentRule().processAddExconProjectBusinessRules(exconIntlShipment);
        if (passed) {
            DocumentHeader docHeader = exconIntlShipmentForm.getExconIntlShipmentDocument().getDocumentHeader();
            if (StringUtils.isEmpty((CharSequence)docHeader.getDocumentDescription())) {
                docHeader.setDocumentDescription("International Shipment Checklist for: " + exconIntlShipment.getApplicantName());
            }
            exconIntlShipmentForm.getExconIntlShipmentBean().performRPS();
            ExconProjectRestrictedCountry restrictedCountry = this.getRestrictedCountry(exconIntlShipment.getCountryCode());
            if (restrictedCountry != null) {
                exconIntlShipment.setSanctionListCode(restrictedCountry.getSanctionListCode());
            }
        }
        ActionForward forward = super.save(mapping, form, request, response);
        if (passed) {
            this.sendShipmentEmail(exconIntlShipment);
        }
        return forward;
    }

    public ExconProjectRestrictedCountry getRestrictedCountry(String countryCode) {
        return (ExconProjectRestrictedCountry)this.getBusinessObjectService().findBySinglePrimaryKey(ExconProjectRestrictedCountry.class, (Object)countryCode);
    }

    public void sendShipmentEmail(ExconIntlShipment exconIntlShipment) {
        String senderEmail = this.getKualiConfigurationService().getPropertyValueAsString("kc.excon.intlship.email");
        String otherRecips = this.getKualiConfigurationService().getPropertyValueAsString("kc.excon.intlship.otherRecips");
        HashSet<String> recipSet = new HashSet<String>();
        recipSet.add(senderEmail);
        HashSet<String> ccSet = new HashSet<String>();
        Collection memberIds = this.getRoleService().getRoleMemberPrincipalIds("KC-EXCON", "Export Control Project Coordinator", new HashMap());
        for (String memberId : memberIds) {
            KcPerson memberPerson = this.getKcPersonService().getKcPersonByPersonId(memberId);
            if (!memberPerson.isActive()) continue;
            ccSet.add(memberPerson.getEmailAddress());
        }
        if (otherRecips != null && otherRecips.contains("@")) {
            StringTokenizer otherTokens = new StringTokenizer(otherRecips, ",");
            while (otherTokens.hasMoreTokens()) {
                ccSet.add(otherTokens.nextToken());
            }
        }
        KcPerson recipPerson = this.getKcPersonService().getKcPersonByPersonId(exconIntlShipment.getApplicantId());
        ccSet.add(recipPerson.getEmailAddress());
        recipPerson = this.getKcPersonService().getKcPersonByPersonId(exconIntlShipment.getSupervisorId());
        ccSet.add(recipPerson.getEmailAddress());
        StringBuilder bodyBuffer = new StringBuilder();
        bodyBuffer.append("<b>Shipment ID: " + exconIntlShipment.getShipmentId() + "</b><p>");
        bodyBuffer.append("Recipient: " + exconIntlShipment.getReceivingParty() + "<br>");
        bodyBuffer.append("Destination Country: " + exconIntlShipment.getCountryName() + "<br>");
        bodyBuffer.append("Shipment Description: " + exconIntlShipment.getShipmentDescription() + "<p>");
        String emailSubj = "Regarding international shipment #" + exconIntlShipment.getShipmentId();
        boolean hasFlags = false;
        Object selfDisclosed = "";
        if (exconIntlShipment.getRestrictedExport().booleanValue()) {
            selfDisclosed = (String)selfDisclosed + " Restricted Export";
        }
        if (exconIntlShipment.getRestrictedCountry().booleanValue()) {
            if (((String)selfDisclosed).length() > 0) {
                selfDisclosed = (String)selfDisclosed + ",";
            }
            selfDisclosed = (String)selfDisclosed + " Restricted Country";
        }
        if (exconIntlShipment.getRestrictedParty().booleanValue()) {
            if (((String)selfDisclosed).length() > 0) {
                selfDisclosed = (String)selfDisclosed + ",";
            }
            selfDisclosed = (String)selfDisclosed + " Restricted Party";
        }
        if (((String)selfDisclosed).length() > 0) {
            bodyBuffer.append("<span style='color:red'>Shipper has self-disclosed the following possible restrictions:" + (String)selfDisclosed + "</span><br>");
            hasFlags = true;
        }
        if (exconIntlShipment.getSanctionListCode() != null) {
            bodyBuffer.append("<span style='color:red'>The destination country is on a restricted list: " + exconIntlShipment.getSanctionListName() + "</span><br>");
            hasFlags = true;
        }
        if (exconIntlShipment.getNumMatches() > 0) {
            bodyBuffer.append("<span style='color:red'>The RPS on the recipient returned " + exconIntlShipment.getNumMatches() + " possible matches</span><br>");
            hasFlags = true;
        }
        if (!hasFlags) {
            bodyBuffer.append("<span style='color:green'>Automated checks on destination country and recipient raised no flags.  Verify that shipment contents conform to shipping restrictions.</span><br>");
            emailSubj = emailSubj + " (No Automated or Self-disclosed Flags)";
        }
        bodyBuffer.append("<hr>Applicant: " + exconIntlShipment.getApplicantName() + "<br>");
        bodyBuffer.append("Supervisor: " + exconIntlShipment.getSupervisorName() + "<br>");
        bodyBuffer.append("Department: " + exconIntlShipment.getUnitNumber() + " (" + exconIntlShipment.getUnitName() + ")<br>");
        String bodyStr = bodyBuffer.toString();
        this.getKcEmailService().sendEmail(senderEmail, recipSet, emailSubj, ccSet, null, bodyStr, true);
        KNSGlobalVariables.getMessageList().add("info.exconIntlShipment.shipmentReview", new String[0]);
    }

    public ActionForward home(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("home");
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = this.save(mapping, form, request, response);
        ExconIntlShipmentForm exconIntlShipmentForm = (ExconIntlShipmentForm)form;
        exconIntlShipmentForm.setAuditActivated(false);
        return super.route(mapping, form, request, response);
    }

    public ActionForward viewRPSResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("rpsViewer");
    }

    protected final boolean applyRules(DocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    public ActionForward sendNotification(ActionMapping mapping, ExconIntlShipmentForm exconIntlShipmentForm, String notificationType, String notificationString) {
        return mapping.findForward("basic");
    }

    protected AuditHelper getAuditHelper() {
        if (this.auditHelper == null) {
            this.auditHelper = KcServiceLocator.getService(AuditHelper.class);
        }
        return this.auditHelper;
    }

    private KcEmailService getKcEmailService() {
        if (this.kcEmailService == null) {
            this.kcEmailService = KcServiceLocator.getService(KcEmailService.class);
        }
        return this.kcEmailService;
    }

    private KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    private RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KcServiceLocator.getService(RoleService.class);
        }
        return this.roleService;
    }
}

