/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.service;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.award.AwardDocumentRule;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncException;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncLog;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncStatus;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelper;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncCreationService;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncHelpersService;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncSelectorService;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncService;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncUtilityService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class AwardSyncServiceImpl
implements AwardSyncService {
    protected static final String VALIDATION_SUCCESS_MESSAGE = "Valid";
    protected static final String VALIDATION_FAILURE_MESSAGE = "Invalid";
    protected static final String SYNC_SAVED_MESSAGE = "Saved";
    protected static final String SYNC_SUCCESS_MESSAGE = "Completed";
    protected static final String SYNC_FAILURE_MESSAGE = "Failed";
    protected static final String CHANGE_LOG_SUCCESS = "Success";
    protected static final String IGNORED_MESSAGE_KEYS = "error.award.person.credit.split.,error.award.person.unit.credit.split.,error.awardProjectPerson.uncertified";
    protected final Logger LOG = LogManager.getLogger(AwardSyncServiceImpl.class);
    private AwardSyncHelpersService awardSyncHelpersService;
    private AwardSyncCreationService awardSyncCreationService;
    private AwardSyncUtilityService awardSyncUtilityService;
    private AwardHierarchyService awardHierarchyService;
    private AwardService awardService;
    private VersionHistoryService versionHistoryService;
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private AwardSyncSelectorService awardSyncSelectorService;
    private TaskExecutor syncExecutor;
    private PersonService personService;
    private KcWorkflowService kraWorkflowService;
    private KcAuthorizationService kraAuthorizationService;

    @Override
    public void validateHierarchyChanges(Award award) {
        this.runSync(award, SyncType.VALIDATE);
    }

    @Override
    public void applyAwardSyncChangesToHierarchy(Award award) {
        this.runSync(award, SyncType.SYNC);
    }

    @Override
    public AwardDocument getAwardLockingHierarchyForSync(AwardDocument awardDocument, String principalId) {
        AwardHierarchy hierarchy = this.getAwardHierarchyService().loadAwardHierarchy(awardDocument.getAward().getAwardNumber());
        if (hierarchy != null) {
            while (hierarchy.getParent() != null) {
                Award parentAward = this.getPendingAward((hierarchy = hierarchy.getParent()).getAwardNumber());
                if (parentAward == null || parentAward.getSyncChanges().isEmpty()) continue;
                try {
                    AwardDocument parentDocument = (AwardDocument)this.getDocumentService().getByDocumentHeaderId(parentAward.getAwardDocument().getDocumentNumber());
                    if (!this.getKraWorkflowService().isEnRoute(parentDocument) || parentDocument.getDocumentHeader().getWorkflowDocument().getRoutedByPrincipalId().equals(principalId)) continue;
                    return parentDocument;
                }
                catch (WorkflowException e) {
                    this.LOG.error("Error loading document to check for award sync lock", (Throwable)e);
                }
            }
        }
        return null;
    }

    protected void runSync(final Award award, final SyncType syncType) {
        long start = System.currentTimeMillis();
        this.LOG.debug("Award Hierarchy Sync Starting");
        UserSession oldSession = this.replaceSessionWithRoutedBy(award);
        try {
            ArrayList<SyncRunnable> runnables = new ArrayList<SyncRunnable>();
            this.runInTransaction(new TransactionRunnable(){

                @Override
                public void run() {
                    AwardSyncServiceImpl.this.clearSyncStatuses(award);
                    AwardSyncServiceImpl.this.setParentAwardStatus(award, true, syncType == SyncType.VALIDATE ? "Validation In Progress" : "Sync Descendants In Progress");
                }
            });
            award.refresh();
            List<AwardSyncChange> changes = award.getSyncChanges();
            for (AwardSyncChange awardSyncChange : changes) {
                awardSyncChange.setXmlExport(this.getAwardSyncCreationService().getXmlExport(awardSyncChange));
            }
            AwardHierarchy hierarchy = this.getAwardHierarchyService().loadAwardHierarchyBranch(award.getAwardNumber());
            for (AwardHierarchy curHierarchy : hierarchy.getChildren()) {
                this.runSyncOnHierarchy(award, curHierarchy, changes, syncType, runnables);
            }
            this.waitTillRunablesFinished(runnables);
            award.refresh();
            if (syncType == SyncType.SYNC) {
                this.sendSyncFYIs(award, this.getAllPrincipalsToNotify(runnables), runnables);
            }
            this.runInTransaction(new TransactionRunnable(){

                @Override
                public void run() {
                    AwardSyncServiceImpl.this.setParentAwardStatus(award, true, syncType == SyncType.VALIDATE ? "Validation Complete" : "Sync Descendants Complete");
                }
            });
            long l = System.currentTimeMillis() - start;
            this.LOG.info("Award Hierarchy Sync Finished : " + l + "ms");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            GlobalVariables.setUserSession((UserSession)oldSession);
        }
    }

    protected void runSyncOnHierarchy(Award parentAward, AwardHierarchy hierarchy, List<AwardSyncChange> changes, SyncType syncType, List<SyncRunnable> runnables) {
        this.runSyncInThread(parentAward, hierarchy, syncType, changes, runnables);
        for (AwardHierarchy curHierarchy : hierarchy.getChildren()) {
            this.runSyncOnHierarchy(parentAward, curHierarchy, changes, syncType, runnables);
        }
    }

    protected void clearSyncStatuses(Award award) {
        ArrayList<AwardSyncLog> oldLogs = new ArrayList<AwardSyncLog>();
        for (AwardSyncStatus status : award.getSyncStatuses()) {
            if (status.getAwardNumber() == null || status.isSyncComplete()) continue;
            status.setStatus(null);
            status.setSyncComplete(false);
            status.setSuccess(false);
            oldLogs.addAll(status.getChangeLogs());
            oldLogs.addAll(status.getValidationLogs());
            status.getChangeLogs().clear();
            status.getValidationLogs().clear();
        }
        this.getBusinessObjectService().delete(oldLogs);
        this.getBusinessObjectService().save(award.getSyncStatuses());
    }

    protected void sendSyncFYIs(Award award, List<String> principalsToNotify, List<SyncRunnable> runnables) throws WorkflowException {
        ArrayList<AdHocRouteRecipient> adHocPersons = new ArrayList<AdHocRouteRecipient>();
        for (String principalId : principalsToNotify) {
            Person person = this.getPersonService().getPerson(principalId);
            if (person == null) continue;
            AdHocRoutePerson adHocPerson = new AdHocRoutePerson();
            adHocPerson.setActionRequested("F");
            adHocPerson.setType(AdHocRoutePerson.PERSON_TYPE);
            adHocPerson.setId(person.getPrincipalName());
            adHocPersons.add((AdHocRouteRecipient)adHocPerson);
        }
        this.sendAdHocRequestsInThread(award.getAwardDocument(), "Sync Descendents FYI", adHocPersons, runnables);
    }

    protected void setParentAwardStatus(Award parentAward, boolean success, String newStatus) {
        AwardSyncStatus status = this.getParentAwardStatus(parentAward);
        if (status != null) {
            status.setStatus(newStatus);
            status.setSuccess(success);
        } else {
            status = new AwardSyncStatus();
            status.setParentAwardId(parentAward.getAwardId());
            status.setStatus(newStatus);
            status.setSuccess(success);
            parentAward.getSyncStatuses().add(status);
        }
        this.getBusinessObjectService().save((PersistableBusinessObject)status);
    }

    protected AwardSyncStatus getParentAwardStatus(Award parentAward) {
        parentAward.refreshReferenceObject("syncStatuses");
        for (AwardSyncStatus status : parentAward.getSyncStatuses()) {
            if (status.getAwardNumber() != null) continue;
            return status;
        }
        return null;
    }

    protected AwardSyncStatus findAwardSyncStatus(Award parentAward, String awardNumber) {
        for (AwardSyncStatus status : parentAward.getSyncStatuses()) {
            if (!StringUtils.equals((CharSequence)awardNumber, (CharSequence)status.getAwardNumber())) continue;
            return status;
        }
        AwardSyncStatus status = new AwardSyncStatus();
        status.setParentAwardId(parentAward.getAwardId());
        status.setAwardNumber(awardNumber);
        return status;
    }

    protected UserSession replaceSessionWithRoutedBy(Award parentAward) {
        String routedByUserId = parentAward.getAwardDocument().getDocumentHeader().getWorkflowDocument().getRoutedByPrincipalId();
        Person person = this.getPersonService().getPerson(routedByUserId);
        UserSession oldSession = GlobalVariables.getUserSession();
        GlobalVariables.setUserSession((UserSession)new UserSession(person.getPrincipalName()));
        return oldSession;
    }

    protected Award checkAwardVersions(String awardNumber, AwardSyncStatus awardStatus, String failureMessage) {
        Award oldAward = this.getPendingAward(awardNumber);
        if (oldAward != null) {
            this.logFailure(awardStatus, failureMessage, "Award has an outstanding pending version.");
            awardStatus.setAwardId(oldAward.getAwardId());
        } else {
            oldAward = this.getActiveAward(awardNumber);
            if (oldAward == null) {
                this.logFailure(awardStatus, failureMessage, "Award does not have an active version.");
            } else {
                awardStatus.setAwardId(oldAward.getAwardId());
            }
        }
        return oldAward;
    }

    protected void runSyncChanges(Award parentAward, AwardHierarchy hierarchy, SyncType syncType, List<AwardSyncChange> changes, List<String> principalsToNotify) {
        long start = System.currentTimeMillis();
        this.LOG.debug("Award Hierarchy Sync Started for " + hierarchy.getAwardNumber());
        boolean result = true;
        UserSession oldSession = null;
        String successMessage = null;
        String failureMessage = null;
        if (syncType == SyncType.VALIDATE) {
            successMessage = VALIDATION_SUCCESS_MESSAGE;
            failureMessage = VALIDATION_FAILURE_MESSAGE;
        } else if (syncType == SyncType.SYNC) {
            successMessage = SYNC_SAVED_MESSAGE;
            failureMessage = SYNC_FAILURE_MESSAGE;
        }
        AwardSyncStatus awardStatus = this.findAwardSyncStatus(parentAward, hierarchy.getAwardNumber());
        try {
            Award oldAward;
            oldSession = this.replaceSessionWithRoutedBy(parentAward);
            if (!awardStatus.isSyncComplete() && (oldAward = this.checkAwardVersions(hierarchy.getAwardNumber(), awardStatus, failureMessage)) != null) {
                if (this.getAwardSyncSelectorService().isAwardInvolvedInSync(oldAward, changes)) {
                    if (!this.hasAwardPermission(awardStatus, oldAward, parentAward.getAwardDocument().getDocumentHeader().getWorkflowDocument().getRoutedByPrincipalId())) {
                        this.logFailure(awardStatus, failureMessage, "Sync submitter does not have modify permission on Award.");
                        return;
                    }
                    Award award = null;
                    AwardDocument awardDocument = syncType == SyncType.SYNC ? this.versionAndPrepareAwardDocument(parentAward, oldAward, awardStatus) : this.loadAwardDocument(oldAward);
                    if (awardDocument == null) {
                        this.logFailure(awardStatus, failureMessage, "Unable to get document.");
                        return;
                    }
                    award = awardDocument.getAward();
                    if (result &= this.applyAndValidateChanges(award, awardStatus, changes)) {
                        this.finalizeAwardStatus(awardDocument, awardStatus, successMessage, syncType, principalsToNotify);
                        this.finalizeAward(awardDocument, awardStatus);
                    } else {
                        awardStatus.setStatus(failureMessage);
                        awardStatus.setSuccess(false);
                    }
                } else {
                    awardStatus.setStatus("No changes");
                    awardStatus.setSuccess(true);
                }
            }
        }
        catch (Exception e) {
            this.LOG.error("Error applying sync", (Throwable)e);
            awardStatus.addValidationLog("Error applying sync. See system log for details.", false, null);
            awardStatus.setStatus(failureMessage);
            awardStatus.setSuccess(false);
            throw new RuntimeException(e);
        }
        finally {
            this.saveInTransaction(awardStatus);
            GlobalVariables.setUserSession((UserSession)oldSession);
            long elapsed = System.currentTimeMillis() - start;
            this.LOG.info("Finished award sync - " + hierarchy.getAwardNumber() + " : " + elapsed + "ms");
        }
    }

    protected boolean applyAndValidateChanges(Award award, AwardSyncStatus awardStatus, List<AwardSyncChange> changes) {
        boolean result = true;
        for (AwardSyncChange change : changes) {
            if (!this.getAwardSyncSelectorService().isChangeApplicableToAward(award, change)) continue;
            result &= this.applyChange(award, change, awardStatus);
        }
        try {
            result &= this.validateModifiedAward(award.getAwardDocument(), awardStatus);
        }
        catch (Exception e) {
            this.LOG.error("Unable to validate award during sync.", (Throwable)e);
            result = false;
            awardStatus.addValidationLog("Validation failed due to unexpected error. See system log for details.", false, null);
        }
        return result;
    }

    protected void finalizeAwardStatus(AwardDocument awardDocument, AwardSyncStatus awardStatus, String successMessage, SyncType syncType, List<String> principalsToNotify) throws WorkflowException {
        if (syncType == SyncType.SYNC) {
            this.getDocumentService().saveDocument((Document)awardDocument);
            principalsToNotify.addAll(this.getNotificationList(awardDocument));
            awardStatus.setSyncComplete(true);
            awardStatus.setAwardId(awardDocument.getAward().getAwardId());
            awardStatus.refreshReferenceObject("award");
        }
        awardStatus.setStatus(successMessage);
        awardStatus.setSuccess(true);
    }

    protected AwardDocument loadAwardDocument(Award award) {
        try {
            AwardDocument awardDocument = (AwardDocument)this.getDocumentService().getByDocumentHeaderId(award.getAwardDocument().getDocumentNumber());
            awardDocument.getAwardList().clear();
            awardDocument.getAwardList().add(award);
            return awardDocument;
        }
        catch (WorkflowException e) {
            this.LOG.error("Unable to load award document.", (Throwable)e);
            return null;
        }
    }

    protected void logFailure(AwardSyncStatus awardStatus, String statusMessage, String logMessage) {
        awardStatus.setStatus(statusMessage);
        awardStatus.setSuccess(false);
        awardStatus.addValidationLog(logMessage, false, null);
    }

    protected boolean hasAwardPermission(AwardSyncStatus awardStatus, Award award, String principalId) {
        return this.getKraAuthorizationService().hasPermission(principalId, award, AwardPermissionConstants.MODIFY_AWARD.getAwardPermission());
    }

    protected boolean validateModifiedAward(AwardDocument award, AwardSyncStatus awardStatus) {
        AwardDocumentRule rule = new AwardDocumentRule();
        boolean result = true;
        if (!rule.processSaveDocument(award)) {
            this.getAwardSyncUtilityService().getLogsFromSaveErrors(awardStatus);
        }
        if (!rule.processRunAuditBusinessRules(award)) {
            this.getAwardSyncUtilityService().getLogsFromAuditErrors(awardStatus);
        }
        CharSequence[] ignoredErrors = IGNORED_MESSAGE_KEYS.split(",");
        for (AwardSyncLog log : awardStatus.getValidationLogs()) {
            if (!StringUtils.startsWithAny((CharSequence)log.getMessageKey(), (CharSequence[])ignoredErrors) && !log.isSuccess()) {
                result = false;
                continue;
            }
            log.setSuccess(true);
        }
        return result;
    }

    protected void applyChange(Award award, AwardSyncHelper syncHelper, AwardSyncChange change) throws Exception {
        if (this.getAwardSyncSelectorService().isChangeApplicableToAward(award, change)) {
            syncHelper.applySyncChange(award, change);
        }
    }

    protected AwardSyncHelper getSyncHelper(String className) {
        return this.getAwardSyncHelpersService().getSyncHelper(className);
    }

    protected Award getActiveAward(String awardNumber) {
        VersionHistory vh = this.getVersionHistoryService().findActiveVersion(Award.class, awardNumber);
        if (vh != null) {
            return (Award)vh.getSequenceOwner();
        }
        return null;
    }

    protected Award getPendingAward(String awardNumber) {
        List<VersionHistory> histories = this.getVersionHistoryService().loadVersionHistory(Award.class, awardNumber);
        for (VersionHistory history : histories) {
            if (history.getStatus() != VersionStatus.PENDING) continue;
            return (Award)history.getSequenceOwner();
        }
        return null;
    }

    protected void waitTillRunablesFinished(List<SyncRunnable> runnables) throws AwardSyncException {
        int numberOfWaits = 0;
        while (!this.areRunnablesFinished(runnables)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (numberOfWaits++ <= 10000) continue;
            throw new AwardSyncException("Runnables have failed to complete in a reasonable amount of time.", false);
        }
    }

    protected List<String> getAllPrincipalsToNotify(List<SyncRunnable> runnables) {
        ArrayList<String> allPrincipalsToNotify = new ArrayList<String>();
        for (SyncRunnable runnable : runnables) {
            if (!(runnable instanceof RunSyncOnAward)) continue;
            for (String principalId : ((RunSyncOnAward)runnable).getPrincipalsToNotify()) {
                if (allPrincipalsToNotify.contains(principalId)) continue;
                allPrincipalsToNotify.add(principalId);
            }
        }
        return allPrincipalsToNotify;
    }

    protected synchronized boolean areRunnablesFinished(List<SyncRunnable> runnables) {
        boolean finished = true;
        ListIterator<SyncRunnable> iter = runnables.listIterator();
        while (iter.hasNext()) {
            SyncRunnable runnable = iter.next();
            if (runnable.getFinished()) continue;
            finished = false;
        }
        return finished;
    }

    protected boolean applyChange(Award award, AwardSyncChange change, AwardSyncStatus awardStatus) {
        boolean result = true;
        try {
            this.applyChange(award, this.getSyncHelper(change.getClassName()), change);
            awardStatus.addChangeLog(change, CHANGE_LOG_SUCCESS, true);
        }
        catch (AwardSyncException e) {
            result &= e.isSuccess();
            awardStatus.addChangeLog(change, e.getStatusMessage(), e.isSuccess());
        }
        catch (Exception e) {
            this.LOG.error("Error applying changes to award " + award.getAwardNumber(), (Throwable)e);
            result = false;
            awardStatus.addChangeLog(change, "Error", false);
        }
        return result;
    }

    protected AwardDocument versionAndPrepareAwardDocument(Award parentAward, Award oldAward, AwardSyncStatus awardStatus) {
        AwardDocument awardDocument = oldAward.getAwardDocument();
        awardDocument.getAwardList().clear();
        awardDocument.getAwardList().add(oldAward);
        AwardDocument newAwardDocument = null;
        try {
            newAwardDocument = this.getAwardService().createNewAwardVersion(awardDocument);
        }
        catch (Exception e) {
            this.LOG.error("Sync Failure while trying to version Award " + oldAward.getAwardNumber(), (Throwable)e);
            awardStatus.setStatus("Failed(Versioning Error)");
            awardStatus.setSuccess(false);
            throw new RuntimeException(e);
        }
        Award award = newAwardDocument.getAward();
        newAwardDocument.getDocumentHeader().setDocumentDescription("Created by Award " + parentAward.getAwardNumber() + " Ver " + parentAward.getSequenceNumber());
        award.setAwardTransactionTypeCode(parentAward.getAwardTransactionTypeCode());
        award.setNoticeDate(parentAward.getNoticeDate());
        award.getAwardCurrentActionComments().setComments("Synchronize Descendants from Award " + parentAward.getAwardNumber());
        return newAwardDocument;
    }

    protected List<String> getNotificationList(AwardDocument awardDocument) throws WorkflowException {
        ArrayList<String> principalsToNotify = new ArrayList<String>();
        Award award = awardDocument.getAward();
        award.setSyncChild(false);
        this.getDocumentService().saveDocument((Document)awardDocument);
        principalsToNotify.addAll(this.getAwardSyncUtilityService().buildListForFYI(awardDocument));
        award.setSyncChild(true);
        this.getDocumentService().saveDocument((Document)awardDocument);
        return principalsToNotify;
    }

    protected void finalizeAward(AwardDocument awardDocument, AwardSyncStatus awardSyncStatus) {
        try {
            if (awardSyncStatus.isSuccess() && awardSyncStatus.isSyncComplete()) {
                awardDocument = (AwardDocument)this.getDocumentService().getByDocumentHeaderId(awardDocument.getDocumentNumber());
                this.getDocumentService().blanketApproveDocument((Document)awardDocument, "Award Hierarchy Sync Routed Document", null);
                awardSyncStatus.setStatus(SYNC_SUCCESS_MESSAGE);
            }
        }
        catch (Exception e) {
            awardSyncStatus.setSyncComplete(false);
            this.logFailure(awardSyncStatus, SYNC_FAILURE_MESSAGE, "Failure occurred while approving document.");
            throw new RuntimeException(e);
        }
    }

    protected void saveInTransaction(final Object object) {
        TransactionTemplate template = new TransactionTemplate((PlatformTransactionManager)KcServiceLocator.getService("transactionManager"));
        template.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        template.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                if (object instanceof PersistableBusinessObject) {
                    AwardSyncServiceImpl.this.getBusinessObjectService().save((PersistableBusinessObject)object);
                } else if (object instanceof List) {
                    AwardSyncServiceImpl.this.getBusinessObjectService().save((List)object);
                }
                return null;
            }
        });
    }

    protected void runInTransaction(final TransactionRunnable runnable) {
        final UserSession session = GlobalVariables.getUserSession();
        this.syncExecutor.execute((Runnable)new SyncRunnable(this){

            @Override
            public void run() {
                GlobalVariables.setUserSession((UserSession)session);
                TransactionTemplate template = new TransactionTemplate((PlatformTransactionManager)KcServiceLocator.getService("transactionManager"));
                template.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
                template.execute(new TransactionCallback(){

                    public Object doInTransaction(TransactionStatus status) {
                        runnable.run();
                        return null;
                    }
                });
            }
        });
    }

    protected void runSyncInThread(Award parentAward, AwardHierarchy hierarchy, SyncType syncType, List<AwardSyncChange> changes, List<SyncRunnable> runnables) {
        RunSyncOnAward newRunnable = new RunSyncOnAward(parentAward, hierarchy, syncType, changes);
        runnables.add(newRunnable);
        this.getSyncExecutor().execute((Runnable)newRunnable);
    }

    protected void sendAdHocRequestsInThread(AwardDocument document, String annotation, List<AdHocRouteRecipient> recipients, List<SyncRunnable> runnables) {
        SendAdHocRequests newRunnable = new SendAdHocRequests(document, annotation, recipients, GlobalVariables.getUserSession());
        runnables.add(newRunnable);
        this.getSyncExecutor().execute((Runnable)newRunnable);
    }

    protected AwardHierarchyService getAwardHierarchyService() {
        return this.awardHierarchyService;
    }

    public void setAwardHierarchyService(AwardHierarchyService awardHierarchyService) {
        this.awardHierarchyService = awardHierarchyService;
    }

    protected AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    protected VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected TaskExecutor getSyncExecutor() {
        return this.syncExecutor;
    }

    public void setSyncExecutor(TaskExecutor syncExecutor) {
        this.syncExecutor = syncExecutor;
    }

    protected AwardSyncSelectorService getAwardSyncSelectorService() {
        return this.awardSyncSelectorService;
    }

    public void setAwardSyncSelectorService(AwardSyncSelectorService awardSyncSelectorService) {
        this.awardSyncSelectorService = awardSyncSelectorService;
    }

    protected PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected KcWorkflowService getKraWorkflowService() {
        return this.kraWorkflowService;
    }

    public void setKraWorkflowService(KcWorkflowService kraWorkflowService) {
        this.kraWorkflowService = kraWorkflowService;
    }

    protected AwardSyncHelpersService getAwardSyncHelpersService() {
        return this.awardSyncHelpersService;
    }

    public void setAwardSyncHelpersService(AwardSyncHelpersService awardSyncHelpersService) {
        this.awardSyncHelpersService = awardSyncHelpersService;
    }

    protected AwardSyncCreationService getAwardSyncCreationService() {
        return this.awardSyncCreationService;
    }

    public void setAwardSyncCreationService(AwardSyncCreationService awardSyncCreationService) {
        this.awardSyncCreationService = awardSyncCreationService;
    }

    protected AwardSyncUtilityService getAwardSyncUtilityService() {
        return this.awardSyncUtilityService;
    }

    public void setAwardSyncUtilityService(AwardSyncUtilityService awardSyncUtilityService) {
        this.awardSyncUtilityService = awardSyncUtilityService;
    }

    protected KcAuthorizationService getKraAuthorizationService() {
        return this.kraAuthorizationService;
    }

    public void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    protected static enum SyncType {
        SYNC,
        VALIDATE;

    }

    protected static abstract class TransactionRunnable {
        protected TransactionRunnable() {
        }

        public abstract void run();
    }

    protected static abstract class SyncRunnable
    implements Runnable {
        protected boolean finished;

        protected SyncRunnable() {
        }

        @Override
        public void run() {
            this.setFinished(true);
        }

        public synchronized boolean getFinished() {
            return this.finished;
        }

        public synchronized void setFinished(boolean finished) {
            this.finished = finished;
        }
    }

    protected class RunSyncOnAward
    extends SyncRunnable {
        protected Award parentAward;
        protected AwardHierarchy hierarchy;
        protected SyncType syncType;
        protected List<AwardSyncChange> changes;
        protected List<String> principalsToNotify = new ArrayList<String>();

        public RunSyncOnAward(Award parentAward, AwardHierarchy hierarchy, SyncType syncType, List<AwardSyncChange> changes) {
            this.parentAward = parentAward;
            this.hierarchy = hierarchy;
            this.syncType = syncType;
            this.changes = changes;
        }

        @Override
        public synchronized void run() {
            try {
                TransactionTemplate template = new TransactionTemplate((PlatformTransactionManager)KcServiceLocator.getService("transactionManager"));
                template.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
                template.execute(new TransactionCallback(){

                    public Object doInTransaction(TransactionStatus status) {
                        AwardSyncServiceImpl.this.runSyncChanges(RunSyncOnAward.this.parentAward, RunSyncOnAward.this.hierarchy, RunSyncOnAward.this.syncType, RunSyncOnAward.this.changes, RunSyncOnAward.this.principalsToNotify);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
            }
            finally {
                super.run();
            }
        }

        public synchronized List<String> getPrincipalsToNotify() {
            return this.principalsToNotify;
        }
    }

    protected class SendAdHocRequests
    extends SyncRunnable {
        protected AwardDocument awardDocument;
        protected String annotation;
        protected List<AdHocRouteRecipient> recipients;
        protected UserSession session;

        public SendAdHocRequests(AwardDocument awardDocument, String annotation, List<AdHocRouteRecipient> recipients, UserSession session) {
            this.awardDocument = awardDocument;
            this.annotation = annotation;
            this.recipients = recipients;
            this.session = session;
        }

        @Override
        public void run() {
            UserSession oldSession = GlobalVariables.getUserSession();
            try {
                GlobalVariables.setUserSession((UserSession)this.session);
                AwardSyncServiceImpl.this.getDocumentService().sendAdHocRequests((Document)this.awardDocument, this.annotation, this.recipients);
            }
            catch (WorkflowException e) {
                AwardSyncServiceImpl.this.LOG.error("Error sending Ad Hoc requests for Award Sync", (Throwable)e);
            }
            finally {
                super.run();
                GlobalVariables.setUserSession((UserSession)oldSession);
            }
        }
    }
}

