/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.struts;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetCommonService;
import org.kuali.coeus.common.budget.framework.core.BudgetForm;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.budget.framework.core.BudgetService;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.impl.struts.BudgetAction;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetForm;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.DocumentService;

public class BudgetVersionsAction
extends BudgetAction {
    private static final Logger LOG = LogManager.getLogger(BudgetVersionsAction.class);
    private static final String CONFIRM_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT = "confirmSynchBudgetRateForBudgetDocument";
    private static final String NO_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT = "noSynchBudgetRateForBudgetDocument";
    public static final String SYNC_QUESTION_ASKED = "syncQuestionAsked";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("rateClassMap", this.getBudgetRatesService().getBudgetRateClassMap("O"));
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        Award budgetParent = awardBudgetDocument.getBudget().getBudgetParent();
        if (!StringUtils.equals((CharSequence)budgetForm.getMethodToCall(), (CharSequence)"save") && budgetForm.isSaveAfterCopy()) {
            List<? extends Budget> budgets = budgetParent.getBudgets();
            Budget copiedBudget = budgets.get(budgets.size() - 1);
            String copiedName = copiedBudget.getName();
            copiedBudget.setName("copied placeholder");
            LOG.debug("validating " + copiedName);
            boolean valid = this.getBudgetService().isBudgetVersionNameValid(budgetParent, copiedName);
            copiedBudget.setName(copiedName);
            budgetForm.setSaveAfterCopy(!valid);
            if (!valid) {
                return mapping.findForward("basic");
            }
        }
        return super.execute(mapping, form, request, response);
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Award award;
        ActionForward forward = super.docHandler(mapping, form, request, response);
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        BudgetParent budgetParent = budget.getBudgetParent();
        AwardBudgetService awardBudgetService = KcServiceLocator.getService(AwardBudgetService.class);
        BudgetRatesService budgetService = KcServiceLocator.getService(BudgetRatesService.class);
        Collection<BudgetRate> savedBudgetRates = budgetService.getSavedBudgetRates(budget);
        Collection<BudgetRate> allPropRates = budgetService.getSavedBudgetRates(budget);
        String questionAsked = request.getParameter(SYNC_QUESTION_ASKED);
        if (this.isAwardBudget(budget) && awardBudgetService.checkRateChange(savedBudgetRates, award = (Award)budget.getBudgetParent().getDocument().getBudgetParent()) && Objects.isNull(questionAsked)) {
            return this.confirm(this.syncAwardBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.synchAwardRates.text"), "confirmSynchAwardRates", "noSynchAwardRates");
        }
        if (budgetService.checkActivityTypeChange(allPropRates, budgetParent.getActivityTypeCode())) {
            budget.setRateClassTypesReloaded(true);
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.synchBudgetRate.text"), CONFIRM_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT, NO_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT);
        }
        if (CollectionUtils.isEmpty(allPropRates)) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.noRatesSynch.text"), CONFIRM_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT, NO_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT);
        }
        return forward;
    }

    public ActionForward addBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        BudgetParentDocument<? extends BudgetParent> parentDocument = budget.getBudgetParent().getDocument();
        this.getBudgetService().addBudgetVersion(parentDocument, budgetForm.getNewBudgetVersionName(), Collections.EMPTY_MAP);
        budgetForm.setNewBudgetVersionName("");
        return mapping.findForward("basic");
    }

    private BudgetParentDocument getBudgetParentDocument(BudgetForm budgetForm) {
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        BudgetParentDocument<Award> parentDocument = awardBudgetDocument.getBudget().getBudgetParent().getDocument();
        return parentDocument;
    }

    private BudgetService getBudgetService() {
        return KcServiceLocator.getService(BudgetService.class);
    }

    public ActionForward openBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetRatesService budgetService = KcServiceLocator.getService(BudgetRatesService.class);
        if (!budgetForm.getEditingMode().containsKey("viewOnly")) {
            this.save(mapping, form, request, response);
        }
        AwardBudgetDocument budgetDoc = budgetForm.getBudgetDocument();
        AwardBudgetExt budget = budgetDoc.getBudget();
        BudgetParentDocument budgetParentDocument = this.getBudgetParentDocument(budgetForm);
        Object budgetParent = budgetParentDocument.getBudgetParent();
        Budget budgetToOpen = budgetParentDocument.getBudgetDocumentVersion(this.getSelectedLine(request));
        DocumentService documentService = KcServiceLocator.getService(DocumentService.class);
        AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)documentService.getByDocumentHeaderId(budgetToOpen.getDocumentNumber());
        AwardBudgetExt budgetOpen = awardBudgetDocument.getBudget();
        String routeHeaderId = awardBudgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        Collection<BudgetRate> allPropRates = budgetService.getSavedBudgetRates(budgetOpen);
        if (this.getBudgetRateService().performSyncFlag(budgetOpen)) {
            budget.setRateClassTypesReloaded(true);
        }
        if (budgetService.checkActivityTypeChange(allPropRates, budgetParent.getActivityTypeCode())) {
            budget.setRateClassTypesReloaded(true);
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.synchBudgetRate.text"), "confirmSynchBudgetRate", "noSynchBudgetRate");
        }
        if (CollectionUtils.isEmpty(allPropRates)) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.noRatesSynch.text"), "confirmSynchBudgetRate", "noSynchBudgetRate");
        }
        String forward = this.buildForwardUrl(routeHeaderId);
        return new ActionForward(forward, true);
    }

    protected StrutsConfirmation syncBudgetRateConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "confirmSynchBudgetRate", message, "");
    }

    public ActionForward confirmSynchBudgetRateForBudgetDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        return this.synchBudgetRate(awardBudgetDocument, true);
    }

    public ActionForward noSynchBudgetRateForBudgetDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        return this.synchBudgetRate(awardBudgetDocument, false);
    }

    protected ActionForward synchBudgetRate(AwardBudgetDocument awardBudgetDocument, boolean confirm) throws Exception {
        AwardBudgetExt budgetOpen = awardBudgetDocument.getBudget();
        String routeHeaderId = awardBudgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        budgetOpen.setActivityTypeCode(awardBudgetDocument.getBudget().getBudgetParent().getDocument().getBudgetParent().getActivityTypeCode());
        budgetOpen.setRateClassTypesReloaded(true);
        String forward = this.buildForwardUrl(routeHeaderId);
        if (confirm) {
            forward = forward.replace("budgetParameters.do?", "budgetParameters.do?syncBudgetRate=Y&");
        }
        return new ActionForward(forward, true);
    }

    public ActionForward confirmSynchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = this.getSelectedBudgetDocument(request, budgetForm);
        return this.synchBudgetRate(awardBudgetDocument, true);
    }

    private AwardBudgetDocument getSelectedBudgetDocument(HttpServletRequest request, BudgetForm budgetForm) throws WorkflowException {
        AwardBudgetDocument budgetDoc = budgetForm.getBudgetDocument();
        BudgetParentDocument<Award> budgetParentDocument = budgetDoc.getBudget().getBudgetParent().getDocument();
        Budget budgetToOpen = budgetParentDocument.getBudgetDocumentVersion(this.getSelectedLine(request));
        DocumentService documentService = KcServiceLocator.getService(DocumentService.class);
        AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)documentService.getByDocumentHeaderId(budgetToOpen.getDocumentNumber());
        return awardBudgetDocument;
    }

    public ActionForward noSynchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = this.getSelectedBudgetDocument(request, budgetForm);
        return this.synchBudgetRate(awardBudgetDocument, false);
    }

    private BudgetRatesService getBudgetRateService() {
        return KcServiceLocator.getService(BudgetRatesService.class);
    }

    public ActionForward copyBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget versionToCopy = this.getSelectedVersion(budgetForm, request);
        BudgetParentDocument<Award> parentDocument = budgetForm.getBudgetDocument().getBudget().getBudgetParent().getDocument();
        Award budgetParent = budgetForm.getBudgetDocument().getBudget().getBudgetParent();
        BudgetCommonService<BudgetParent> budgetService = this.getBudgetCommonService(budgetParent);
        if (!budgetService.validateAddingNewBudget(parentDocument)) {
            return mapping.findForward("basic");
        }
        if (StringUtils.isNotBlank((CharSequence)request.getParameter("questionIndex"))) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("1".equals(buttonClicked)) {
                budgetForm.setSaveAfterCopy(true);
                return this.copyBudgetPeriodOne(mapping, form, request, response);
            }
            if ("0".equals(buttonClicked)) {
                budgetForm.setSaveAfterCopy(true);
                return this.copyBudgetAllPeriods(mapping, form, request, response);
            }
            return mapping.findForward("basic");
        }
        return this.performQuestionWithoutInput(mapping, form, request, response, "copyBudgetQuestion", "A new version of the budget will be created based on version " + versionToCopy.getBudgetVersionNumber() + ".", "copyPeriodsQuestion", budgetForm.getMethodToCall(), "");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        boolean valid = true;
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        BudgetParentDocument<Award> parentDocument = awardBudgetDocument.getBudget().getBudgetParent().getDocument();
        AwardBudgetExt budget = awardBudgetDocument.getBudget();
        if (LOG.isInfoEnabled()) {
            AwardBudgetExt awardBudgetExt;
            Award award = awardBudgetDocument.getCurrentAward();
            StringBuilder financialPostLoggingMessage = new StringBuilder();
            financialPostLoggingMessage.append("In BudgetVersionsAction save method => ");
            financialPostLoggingMessage.append("\n");
            if (award != null) {
                financialPostLoggingMessage.append("Award number => ");
                financialPostLoggingMessage.append(award.getAwardNumber());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Award sequence number => ");
                financialPostLoggingMessage.append(award.getSequenceNumber());
            }
            if ((awardBudgetExt = awardBudgetDocument.getBudget()) != null) {
                financialPostLoggingMessage.append("Budget Timestamp => ");
                financialPostLoggingMessage.append(awardBudgetExt.getUpdateTimestamp());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget User => ");
                financialPostLoggingMessage.append(awardBudgetExt.getUpdateUser());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget status code => ");
                financialPostLoggingMessage.append(awardBudgetExt.getAwardBudgetStatusCode());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget version => ");
                financialPostLoggingMessage.append(awardBudgetExt.getBudgetVersionNumber());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget name => ");
                financialPostLoggingMessage.append(awardBudgetExt.getName());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget document number => ");
                financialPostLoggingMessage.append(awardBudgetExt.getDocumentNumber());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget post status => ");
                financialPostLoggingMessage.append(awardBudgetExt.getPostStatus());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget post detail => ");
                financialPostLoggingMessage.append(awardBudgetExt.getPostDetails());
                financialPostLoggingMessage.append("\n");
            }
            LOG.info((CharSequence)financialPostLoggingMessage);
        }
        if (budgetForm.isSaveAfterCopy()) {
            List<? extends Budget> overviews = parentDocument.getBudgetParent().getBudgets();
            Budget copiedOverview = overviews.get(overviews.size() - 1);
            String copiedName = copiedOverview.getName();
            copiedOverview.setName("copied placeholder");
            LOG.debug("validating " + copiedName);
            valid = this.getBudgetService().isBudgetVersionNameValid(parentDocument.getBudgetParent(), copiedName);
            copiedOverview.setName(copiedName);
            budgetForm.setSaveAfterCopy(!valid);
        }
        ActionForward forward = super.save(mapping, form, request, response);
        return forward;
    }

    public ActionForward copyBudgetPeriodOne(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("copyBudgetQuestion".equals(question)) {
            this.copyBudget(form, request, true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward copyBudgetAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("copyBudgetQuestion".equals(question)) {
            this.copyBudget(form, request, false);
        }
        return mapping.findForward("basic");
    }

    public ActionForward rePostAwardBudgetToFinancials(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        if (LOG.isInfoEnabled()) {
            AwardBudgetExt awardBudgetExt;
            Award award = awardBudgetDocument.getCurrentAward();
            StringBuilder financialPostLoggingMessage = new StringBuilder();
            financialPostLoggingMessage.append("In BudgetVersionsAction rePostAwardBudgetToFinancials method => ");
            financialPostLoggingMessage.append("\n");
            if (award != null) {
                financialPostLoggingMessage.append("Award number => ");
                financialPostLoggingMessage.append(award.getAwardNumber());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Award sequence number => ");
                financialPostLoggingMessage.append(award.getSequenceNumber());
            }
            if ((awardBudgetExt = awardBudgetDocument.getBudget()) != null) {
                financialPostLoggingMessage.append("Budget Timestamp => ");
                financialPostLoggingMessage.append(awardBudgetExt.getUpdateTimestamp());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget User => ");
                financialPostLoggingMessage.append(awardBudgetExt.getUpdateUser());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget status code => ");
                financialPostLoggingMessage.append(awardBudgetExt.getAwardBudgetStatusCode());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget version => ");
                financialPostLoggingMessage.append(awardBudgetExt.getBudgetVersionNumber());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget name => ");
                financialPostLoggingMessage.append(awardBudgetExt.getName());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget document number => ");
                financialPostLoggingMessage.append(awardBudgetExt.getDocumentNumber());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget post status => ");
                financialPostLoggingMessage.append(awardBudgetExt.getPostStatus());
                financialPostLoggingMessage.append("\n");
                financialPostLoggingMessage.append("Budget post detail => ");
                financialPostLoggingMessage.append(awardBudgetExt.getPostDetails());
                financialPostLoggingMessage.append("\n");
            }
            LOG.info((CharSequence)financialPostLoggingMessage);
        }
        this.getAwardBudgetService().postWithFinancialIntegration(awardBudgetDocument);
        Object forwardUrl = this.buildForwardUrl(awardBudgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId());
        forwardUrl = (String)forwardUrl + "&methodToCallAttribute=methodToCall.reload";
        return new ActionForward((String)forwardUrl, true);
    }

    private Budget getSelectedVersion(BudgetForm budgetForm, HttpServletRequest request) {
        return budgetForm.getBudgetDocument().getBudget().getBudgetParent().getBudgets().get(this.getSelectedLine(request));
    }

    private void copyBudget(ActionForm form, HttpServletRequest request, boolean copyPeriodOneOnly) throws WorkflowException {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument budgetDoc = budgetForm.getBudgetDocument();
        BudgetParentDocument<Award> pdDoc = budgetDoc.getBudget().getBudgetParent().getDocument();
        Budget budgetToCopy = this.getSelectedVersion(budgetForm, request);
        this.copyBudget(pdDoc, budgetToCopy, copyPeriodOneOnly);
    }

    public ActionForward rebudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        AwardDocument parentDocument = (AwardDocument)awardBudgetDocument.getBudget().getBudgetParent().getDocument();
        AwardBudgetDocument newBudgetDoc = this.getAwardBudgetService().rebudget(parentDocument, budgetForm.getNewBudgetVersionName());
        if (newBudgetDoc != null) {
            budgetForm.setNewBudgetVersionName("");
        }
        return mapping.findForward("basic");
    }

    private AwardBudgetService getAwardBudgetService() {
        return KcServiceLocator.getService(AwardBudgetService.class);
    }

    private BudgetRatesService getBudgetRatesService() {
        return KcServiceLocator.getService(BudgetRatesService.class);
    }
}

