/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.calculator.AwardBudgetCalculationService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardBudgetCostLimitAuditRule
implements DocumentAuditRule {
    public static final String AWARD_BUDGET_COST_LIMIT_ERROR_KEY = "awardBudgetCostLimitAuditErrors";
    public static final String AWARD_BUDGET_COST_LIMIT_WARNING_KEY = "awardBudgetCostLimitAuditWarnings";
    private BusinessObjectService businessObjectService;
    private AwardBudgetCalculationService awardBudgetCalculationService;
    private AwardBudgetService awardBudgetService;

    public boolean processRunAuditBusinessRules(Document document) {
        AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)document;
        AwardBudgetExt budget = ((AwardBudgetDocument)document).getBudget();
        Award currentAward = this.getAwardBudgetService().getActiveOrNewestAward(((AwardDocument)awardBudgetDocument.getBudget().getBudgetParent().getDocument()).getAward().getAwardNumber());
        boolean valid = true;
        valid &= this.limitsMatch(currentAward.getAwardBudgetLimits(), budget.getAwardBudgetLimits());
        AwardBudgetExt prevBudget = this.loadBudget(budget.getPrevBudget());
        if (prevBudget != null) {
            this.getAwardBudgetCalculationService().calculateBudgetSummaryTotals(prevBudget, true);
        }
        for (AwardBudgetLimit budgetLimit : budget.getAwardBudgetLimits()) {
            if (budgetLimit.getLimitType() == AwardBudgetLimit.LIMIT_TYPE.TOTAL_COST || budgetLimit.getLimit() == null) continue;
            ScaleTwoDecimal total = (ScaleTwoDecimal)ObjectUtils.getPropertyValue((Object)budget, (String)budgetLimit.getLimitType().getBudgetProperty());
            if (prevBudget != null) {
                total = (ScaleTwoDecimal)total.add((AbstractDecimal)((ScaleTwoDecimal)ObjectUtils.getPropertyValue((Object)prevBudget, (String)budgetLimit.getLimitType().getBudgetProperty())));
            }
            if (!total.isGreaterThan((AbstractDecimal)budgetLimit.getLimit())) continue;
            this.getAuditErrors().add(new AuditError("document.budget." + budgetLimit.getLimitType().getBudgetProperty(), "error.budget.cost.limit", "parameters.BudgetPeriodsTotals", new String[]{budgetLimit.getLimitType().getDesc(), budgetLimit.getLimit().toString()}));
            valid = false;
        }
        return valid;
    }

    private AwardBudgetExt loadBudget(AwardBudgetExt budget) {
        AwardBudgetExt retval = null;
        if (budget != null && budget.getBudgetId() != null) {
            retval = (AwardBudgetExt)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetExt.class, (Object)budget.getBudgetId());
        }
        return retval;
    }

    private List<AuditError> getAuditErrors() {
        return this.getAuditProblems(AWARD_BUDGET_COST_LIMIT_ERROR_KEY, "Error");
    }

    private List<AuditError> getAuditWarnings() {
        return this.getAuditProblems(AWARD_BUDGET_COST_LIMIT_WARNING_KEY, "Warnings");
    }

    protected AwardBudgetLimit getBudgetLimit(AwardBudgetLimit.LIMIT_TYPE type, List<AwardBudgetLimit> budgetLimits) {
        for (AwardBudgetLimit limit : budgetLimits) {
            if (limit.getLimitType() != type) continue;
            return limit;
        }
        return new AwardBudgetLimit(type);
    }

    protected boolean limitsMatch(List<AwardBudgetLimit> awardLimits, List<AwardBudgetLimit> budgetLimits) {
        if (awardLimits.size() < budgetLimits.size()) {
            this.getAuditWarnings().add(new AuditError("document.budget.awardBudgetLimits", "error.budget.cost.limits.changed", "parameters.BudgetPeriodsTotals"));
            return true;
        }
        for (AwardBudgetLimit limit : awardLimits) {
            AwardBudgetLimit budgetLimit = this.getBudgetLimit(limit.getLimitType(), budgetLimits);
            if (budgetLimit != null && Objects.equals(limit.getLimit(), budgetLimit.getLimit())) continue;
            this.getAuditWarnings().add(new AuditError("document.budget.awardBudgetLimits", "error.budget.specific.cost.limit.changed", "parameters.BudgetPeriodsTotals", new String[]{budgetLimit.getLimitType().getDesc(), budgetLimit == null || budgetLimit.getLimit() == null ? "N/A" : budgetLimit.getLimit().toString(), limit == null || limit.getLimit() == null ? "N/A" : limit.getLimit().toString()}));
        }
        return true;
    }

    private List<AuditError> getAuditProblems(String auditKey, String problemType) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!GlobalVariables.getAuditErrorMap().containsKey(auditKey)) {
            GlobalVariables.getAuditErrorMap().put(auditKey, new AuditCluster("Award Budget Limits", auditErrors, problemType));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(auditKey)).getAuditErrorList();
        }
        return auditErrors;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected AwardBudgetCalculationService getAwardBudgetCalculationService() {
        if (this.awardBudgetCalculationService == null) {
            this.awardBudgetCalculationService = KcServiceLocator.getService(AwardBudgetCalculationService.class);
        }
        return this.awardBudgetCalculationService;
    }

    public void setAwardBudgetCalculationService(AwardBudgetCalculationService awardBudgetCalculationService) {
        this.awardBudgetCalculationService = awardBudgetCalculationService;
    }

    protected AwardBudgetService getAwardBudgetService() {
        if (this.awardBudgetService == null) {
            this.awardBudgetService = KcServiceLocator.getService(AwardBudgetService.class);
        }
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }
}

