/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.workflow;

import java.util.Arrays;

public enum DocumentType {
    PROPDEV("propdev", "ProposalDevelopmentDocument"),
    IP("ip", "InstitutionalProposalDocument"),
    AWARD("award", "AwardDocument"),
    SUBAWARD("subaward", "SubAwardDocument"),
    NEGOTIATION("negotiation", "NegotiationDocument");

    private final String abbreviation;
    private final String docTypeName;

    private DocumentType(String abbreviation, String docTypeName) {
        this.abbreviation = abbreviation;
        this.docTypeName = docTypeName;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    public static DocumentType fromAbbreviation(String abbr) {
        return Arrays.stream(DocumentType.values()).filter(dt -> dt.abbreviation.equalsIgnoreCase(abbr)).findFirst().orElse(null);
    }
}

