/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministratorType;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.contacts.AwardCentralAdminContact;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardCentralAdminContactAddRuleImpl {
    public static final String AWARD_CENTRAL_ADMIN_CONTACT_LIST_ERROR_KEY = "centralAdminContactsBean.centralAdminContact.unitAdministratorTypeCode";
    public static final String ERROR_AWARD_UNIT_CONTACT_EXISTS = "error.awardCentralAdminUnitContact.person.exists";
    private static final String PERSON_ERROR_KEY = "centralAdminContactsBean.newAwardContact.fullName";
    private BusinessObjectService businessObjectService;

    public boolean processAddAwardCentralAdminUnitContactBusinessRules(Award award, AwardCentralAdminContact newAwardCentralAdminContact) {
        boolean valid = this.checkForSelectedContactAdministratorTypeCode(newAwardCentralAdminContact);
        valid &= this.checkForDuplicatePerson(award, newAwardCentralAdminContact);
        return valid &= this.checkForSelectedPerson(newAwardCentralAdminContact);
    }

    public boolean checkForSelectedContactAdministratorTypeCode(AwardCentralAdminContact newAwardCentralAdminContact) {
        boolean valid;
        boolean bl = valid = newAwardCentralAdminContact.getUnitAdministratorTypeCode() != null;
        if (!valid) {
            GlobalVariables.getMessageMap().putError(AWARD_CENTRAL_ADMIN_CONTACT_LIST_ERROR_KEY, "error.award.contact.person.role.required", new String[0]);
        }
        return valid;
    }

    private boolean checkForSelectedPerson(AwardCentralAdminContact newAwardCentralAdminContact) {
        if (StringUtils.isBlank((CharSequence)newAwardCentralAdminContact.getPersonId()) || StringUtils.isBlank((CharSequence)newAwardCentralAdminContact.getFullName())) {
            GlobalVariables.getMessageMap().putError(PERSON_ERROR_KEY, "error.unitContact.missing.person", new String[0]);
            return false;
        }
        return true;
    }

    boolean checkForDuplicatePerson(Award award, AwardCentralAdminContact newAwardCentralAdminContact) {
        Optional<AwardCentralAdminContact> duplicateAwardCentralAdminContact = award.getAwardCentralAdminContacts().stream().filter(awardCentralAdminContact -> StringUtils.equals((CharSequence)awardCentralAdminContact.getPersonId(), (CharSequence)newAwardCentralAdminContact.getPersonId()) && StringUtils.equals((CharSequence)awardCentralAdminContact.getUnitAdministratorTypeCode(), (CharSequence)newAwardCentralAdminContact.getUnitAdministratorTypeCode())).findAny();
        if (duplicateAwardCentralAdminContact.isPresent()) {
            this.registerError(newAwardCentralAdminContact);
            return false;
        }
        return true;
    }

    private void registerError(AwardCentralAdminContact newAwardCentralAdminContact) {
        GlobalVariables.getMessageMap().putError(PERSON_ERROR_KEY, ERROR_AWARD_UNIT_CONTACT_EXISTS, new String[]{newAwardCentralAdminContact.getFullName(), this.getRoleDescription(newAwardCentralAdminContact)});
    }

    private String getRoleDescription(AwardCentralAdminContact newAwardCentralAdminContact) {
        UnitAdministratorType unitAdministratorType = (UnitAdministratorType)this.getBusinessObjectService().findBySinglePrimaryKey(UnitAdministratorType.class, (Object)newAwardCentralAdminContact.getUnitAdministratorTypeCode());
        return unitAdministratorType != null ? unitAdministratorType.getDescription() : "";
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

