/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.ipreview;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.sequence.owner.SequenceOwner;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.InstitutionalProposalAssociate;
import org.kuali.kra.institutionalproposal.ProposalComment;
import org.kuali.kra.institutionalproposal.ProposalIpReviewJoin;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.ipreview.IntellectualPropertyReviewActivity;
import org.kuali.kra.institutionalproposal.ipreview.IntellectualPropertyReviewRequirementType;
import org.kuali.kra.institutionalproposal.ipreview.IntellectualPropertyReviewResultType;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalVersioningService;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class IntellectualPropertyReview
extends InstitutionalProposalAssociate
implements SequenceOwner<IntellectualPropertyReview> {
    private static final long serialVersionUID = 1L;
    private static final String GENERAL_COMMENT_CODE_PARM_NM = "proposalcommenttype.generalcomment";
    private static final String REVIEWER_COMMENT_CODE_PARM_NM = "proposalcommenttype.reviewercomment";
    private Long ipReviewId;
    private String ipReviewRequirementTypeCode;
    private Date reviewSubmissionDate;
    private Date reviewReceiveDate;
    private String reviewResultCode;
    private String ipReviewer;
    private List<ProposalComment> comments;
    private List<IntellectualPropertyReviewActivity> ipReviewActivities;
    private IntellectualPropertyReviewRequirementType ipReviewRequirementType;
    private IntellectualPropertyReviewResultType reviewResult;
    private String generalComments;
    private String reviewerComments;
    private List<ProposalIpReviewJoin> proposalIpReviewJoins;
    private String ipReviewSequenceStatus;
    private Long proposalIdToLink;
    private transient ParameterService parameterService;
    private transient KcPersonService kcPersonService;
    private transient String generalCommentCode;
    private transient String reviewerCommentCode;

    public IntellectualPropertyReview() {
        this.init();
    }

    protected void init() {
        this.comments = new ArrayList<ProposalComment>();
        this.ipReviewActivities = new ArrayList<IntellectualPropertyReviewActivity>();
        this.proposalIpReviewJoins = new ArrayList<ProposalIpReviewJoin>();
        this.setIpReviewSequenceStatus(VersionStatus.PENDING.toString());
    }

    public Long getIpReviewId() {
        return this.ipReviewId;
    }

    public void setIpReviewId(Long ipReviewId) {
        this.ipReviewId = ipReviewId;
    }

    public String getIpReviewRequirementTypeCode() {
        return this.ipReviewRequirementTypeCode;
    }

    public void setIpReviewRequirementTypeCode(String ipReviewRequirementTypeCode) {
        this.ipReviewRequirementTypeCode = ipReviewRequirementTypeCode;
    }

    public Date getReviewSubmissionDate() {
        return this.reviewSubmissionDate;
    }

    public void setReviewSubmissionDate(Date reviewSubmissionDate) {
        this.reviewSubmissionDate = reviewSubmissionDate;
    }

    public Date getReviewReceiveDate() {
        return this.reviewReceiveDate;
    }

    public void setReviewReceiveDate(Date reviewReceiveDate) {
        this.reviewReceiveDate = reviewReceiveDate;
    }

    public String getReviewResultCode() {
        return this.reviewResultCode;
    }

    public void setReviewResultCode(String reviewResultCode) {
        this.reviewResultCode = reviewResultCode;
    }

    public String getIpReviewer() {
        return this.ipReviewer;
    }

    public void setIpReviewer(String ipReviewer) {
        this.ipReviewer = ipReviewer;
    }

    public List<ProposalComment> getComments() {
        return this.comments;
    }

    public void setComments(List<ProposalComment> comments) {
        this.comments = comments;
    }

    public String getGeneralComments() {
        return this.generalComments;
    }

    public void setGeneralComments(String generalComments) {
        this.generalComments = generalComments;
    }

    public String getReviewerComments() {
        return this.reviewerComments;
    }

    public void setReviewerComments(String reviewerComments) {
        this.reviewerComments = reviewerComments;
    }

    public List<IntellectualPropertyReviewActivity> getIpReviewActivities() {
        return this.ipReviewActivities;
    }

    public void setIpReviewActivities(List<IntellectualPropertyReviewActivity> ipReviewActivities) {
        this.ipReviewActivities = ipReviewActivities;
    }

    public KcPerson getPerson() {
        if (this.ipReviewer != null) {
            return this.getKcPersonService().getKcPersonByPersonId(this.ipReviewer);
        }
        return new KcPerson();
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public IntellectualPropertyReviewRequirementType getIpReviewRequirementType() {
        return this.ipReviewRequirementType;
    }

    public void setIpReviewRequirementType(IntellectualPropertyReviewRequirementType ipReviewRequirementType) {
        this.ipReviewRequirementType = ipReviewRequirementType;
    }

    public IntellectualPropertyReviewResultType getReviewResult() {
        return this.reviewResult;
    }

    public void setReviewResult(IntellectualPropertyReviewResultType reviewResult) {
        this.reviewResult = reviewResult;
    }

    public List<ProposalIpReviewJoin> getProposalIpReviewJoins() {
        return this.proposalIpReviewJoins;
    }

    public void setProposalIpReviewJoins(List<ProposalIpReviewJoin> proposalIpReviewJoins) {
        this.proposalIpReviewJoins = proposalIpReviewJoins;
    }

    public String getIpReviewSequenceStatus() {
        return this.ipReviewSequenceStatus;
    }

    public void setIpReviewSequenceStatus(String ipReviewSequenceStatus) {
        this.ipReviewSequenceStatus = ipReviewSequenceStatus;
    }

    public Long getProposalIdToLink() {
        return this.proposalIdToLink;
    }

    public void setProposalIdToLink(Long proposalIdToLink) {
        this.proposalIdToLink = proposalIdToLink;
    }

    public ProposalIpReviewJoin getProposalIpReviewJoin() {
        if (!this.proposalIpReviewJoins.isEmpty()) {
            return this.proposalIpReviewJoins.get(0);
        }
        return null;
    }

    public void setProposalIpReviewJoin(ProposalIpReviewJoin proposalIpReviewJoin) {
        this.proposalIpReviewJoins.add(0, proposalIpReviewJoin);
    }

    public String getLeadUnitNumber() {
        if (!ObjectUtils.isNull((Object)this.getProposalIpReviewJoin())) {
            return this.getProposalIpReviewJoin().getInstitutionalProposal().getUnitNumber();
        }
        return "";
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        this.setIpReviewSequenceStatus(VersionStatus.ACTIVE.toString());
        this.archiveCurrentActiveIpReview();
        this.transformDataBeforePersistence();
        this.getBusinessObjectService().save(this.getComments());
    }

    @Override
    protected void preUpdate() {
        super.preUpdate();
        this.transformDataBeforePersistence();
        this.getBusinessObjectService().save(this.getComments());
    }

    protected void postLoad() {
        super.postLoad();
        this.loadProposalComments();
        this.transformDataAfterLookup();
    }

    @Override
    protected void postPersist() {
        super.postPersist();
        if (ObjectUtils.isNotNull((Object)this.getProposalIdToLink())) {
            this.updateProposalIpReviewJoin();
        }
    }

    protected void updateProposalIpReviewJoin() {
        ProposalIpReviewJoin proposalIpReviewJoin = this.getProposalIpReviewJoin();
        if (ObjectUtils.isNull((Object)proposalIpReviewJoin)) {
            proposalIpReviewJoin = new ProposalIpReviewJoin();
        } else if (ObjectUtils.isNotNull((Object)proposalIpReviewJoin.getProposalIpReviewJoinId())) {
            proposalIpReviewJoin.setProposalIpReviewJoinId(null);
        }
        proposalIpReviewJoin.setIpReviewId(this.getIpReviewId());
        proposalIpReviewJoin.setProposalId(this.getProposalIdToLink());
        this.getBusinessObjectService().save((PersistableBusinessObject)proposalIpReviewJoin);
        this.setProposalIpReviewJoin(proposalIpReviewJoin);
    }

    protected void archiveCurrentActiveIpReview() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("proposalNumber", this.getProposalNumber());
        criteria.put("ipReviewSequenceStatus", VersionStatus.ACTIVE.toString());
        ArrayList results = new ArrayList(this.getBusinessObjectService().findMatching(IntellectualPropertyReview.class, criteria));
        if (!results.isEmpty()) {
            IntellectualPropertyReview ipReviewToArchive = (IntellectualPropertyReview)results.get(0);
            ipReviewToArchive.setIpReviewSequenceStatus(VersionStatus.ARCHIVED.toString());
            this.getBusinessObjectService().save((PersistableBusinessObject)ipReviewToArchive);
        }
    }

    protected void transformDataBeforePersistence() {
        if (this.getProposalIdToLink() != null) {
            this.loadProposalComments();
            if (this.getGeneralComments() != null) {
                this.addOrModifyComments(this.getGeneralCommentCode(), this.getGeneralComments());
            }
            if (this.getReviewerComments() != null) {
                this.addOrModifyComments(this.getReviewerCommentCode(), this.getReviewerComments());
            }
        }
        this.setReferenceFields();
    }

    protected void transformDataAfterLookup() {
        ProposalComment reviewerCommentFromList;
        ProposalComment generalCommentFromList = this.getCommentFromList(this.getGeneralCommentCode());
        if (generalCommentFromList != null) {
            this.setGeneralComments(generalCommentFromList.getComments());
        }
        if ((reviewerCommentFromList = this.getCommentFromList(this.getReviewerCommentCode())) != null) {
            this.setReviewerComments(reviewerCommentFromList.getComments());
        }
    }

    protected void setReferenceFields() {
        for (IntellectualPropertyReviewActivity ipReviewActivity : this.ipReviewActivities) {
            ipReviewActivity.setIpReviewId(this.getIpReviewId());
            ipReviewActivity.setProposalNumber(this.getProposalNumber());
            ipReviewActivity.setSequenceNumber(this.getSequenceNumber());
        }
    }

    private void addOrModifyComments(String commentTypeCode, String comment) {
        ProposalComment commentFromList = this.getCommentFromList(commentTypeCode);
        if (commentFromList != null) {
            commentFromList.setComments(comment);
        } else {
            ProposalComment proposalComment = new ProposalComment();
            proposalComment.setCommentTypeCode(commentTypeCode);
            proposalComment.setProposalId(this.getProposalIdToLink());
            proposalComment.setProposalNumber(this.getProposalNumber());
            proposalComment.setSequenceNumber(this.getSequenceNumber());
            proposalComment.setComments(comment);
            this.comments.add(proposalComment);
        }
    }

    private ProposalComment getCommentFromList(String commentTypeCode) {
        for (ProposalComment proposalComment : this.getComments()) {
            if (!proposalComment.getCommentTypeCode().equals(commentTypeCode)) continue;
            return proposalComment;
        }
        return null;
    }

    private void loadProposalComments() {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        if (!this.getProposalIpReviewJoins().isEmpty() && ObjectUtils.isNotNull((Object)this.getProposalIpReviewJoin().getProposalId())) {
            fieldValues.put("proposalId", this.getProposalIpReviewJoin().getProposalId());
            this.setComments(new ArrayList<ProposalComment>(this.getBusinessObjectService().findMatching(ProposalComment.class, fieldValues)));
        } else if (this.getProposalIdToLink() != null) {
            fieldValues.put("proposalId", this.getProposalIdToLink());
            this.setComments(new ArrayList<ProposalComment>(this.getBusinessObjectService().findMatching(ProposalComment.class, fieldValues)));
        }
    }

    String getGeneralCommentCode() {
        if (this.generalCommentCode == null) {
            this.generalCommentCode = this.getParameterService().getParameterValueAsString(InstitutionalProposalDocument.class, GENERAL_COMMENT_CODE_PARM_NM);
        }
        return this.generalCommentCode;
    }

    String getReviewerCommentCode() {
        if (this.reviewerCommentCode == null) {
            this.reviewerCommentCode = this.getParameterService().getParameterValueAsString(InstitutionalProposalDocument.class, REVIEWER_COMMENT_CODE_PARM_NM);
        }
        return this.reviewerCommentCode;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }

    BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    InstitutionalProposalVersioningService getInstitutionalProposalVersioningService() {
        return KcServiceLocator.getService(InstitutionalProposalVersioningService.class);
    }

    @Override
    public Integer getOwnerSequenceNumber() {
        return null;
    }

    @Override
    public void incrementSequenceNumber() {
        this.setSequenceNumber(this.getSequenceNumber() + 1);
    }

    @Override
    public IntellectualPropertyReview getSequenceOwner() {
        return this;
    }

    @Override
    public void setSequenceOwner(IntellectualPropertyReview newlyVersionedOwner) {
    }

    @Override
    public void resetPersistenceState() {
        this.ipReviewId = null;
    }

    @Override
    public String getVersionNameField() {
        return "proposalNumber";
    }

    @Override
    public String getVersionNameFieldValue() {
        return this.getProposalNumber();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + (this.generalComments == null ? 0 : this.generalComments.hashCode());
        result = 31 * result + (this.ipReviewActivities == null ? 0 : this.ipReviewActivities.hashCode());
        result = 31 * result + (this.ipReviewRequirementTypeCode == null ? 0 : this.ipReviewRequirementTypeCode.hashCode());
        result = 31 * result + (this.ipReviewer == null ? 0 : this.ipReviewer.hashCode());
        result = 31 * result + (this.ipReviewId == null ? 0 : this.ipReviewId.hashCode());
        result = 31 * result + (this.reviewReceiveDate == null ? 0 : this.reviewReceiveDate.hashCode());
        result = 31 * result + (this.reviewResultCode == null ? 0 : this.reviewResultCode.hashCode());
        result = 31 * result + (this.reviewSubmissionDate == null ? 0 : this.reviewSubmissionDate.hashCode());
        result = 31 * result + (this.reviewerComments == null ? 0 : this.reviewerComments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntellectualPropertyReview other = (IntellectualPropertyReview)obj;
        if (this.comments == null ? other.comments != null : !this.comments.equals(other.comments)) {
            return false;
        }
        if (this.generalComments == null ? other.generalComments != null : !this.generalComments.equals(other.generalComments)) {
            return false;
        }
        if (this.ipReviewActivities == null ? other.ipReviewActivities != null : !this.ipReviewActivities.equals(other.ipReviewActivities)) {
            return false;
        }
        if (this.ipReviewRequirementTypeCode == null ? other.ipReviewRequirementTypeCode != null : !this.ipReviewRequirementTypeCode.equals(other.ipReviewRequirementTypeCode)) {
            return false;
        }
        if (this.ipReviewer == null ? other.ipReviewer != null : !this.ipReviewer.equals(other.ipReviewer)) {
            return false;
        }
        if (this.ipReviewId == null ? other.ipReviewId != null : !this.ipReviewId.equals(other.ipReviewId)) {
            return false;
        }
        if (this.reviewReceiveDate == null ? other.reviewReceiveDate != null : !this.reviewReceiveDate.equals(other.reviewReceiveDate)) {
            return false;
        }
        if (this.reviewResultCode == null ? other.reviewResultCode != null : !this.reviewResultCode.equals(other.reviewResultCode)) {
            return false;
        }
        if (this.reviewSubmissionDate == null ? other.reviewSubmissionDate != null : !this.reviewSubmissionDate.equals(other.reviewSubmissionDate)) {
            return false;
        }
        return !(this.reviewerComments == null ? other.reviewerComments != null : !this.reviewerComments.equals(other.reviewerComments));
    }
}

