/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.citi;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.kuali.coeus.common.framework.person.citi.CitiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v1/citi"})
@RestController(value="citiController")
public class CitiController
extends org.kuali.coeus.sys.framework.controller.rest.RestController {
    @Autowired
    @Qualifier(value="citiService")
    private CitiService citiService;

    @PostMapping(value={"/start-job"}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public ResponseEntity<String> processCiti(@RequestParam(value="startDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime startDate, @RequestParam(value="endDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime endDate) {
        if (!this.validDates(startDate, endDate)) {
            return this.badRequest("startDate and endDate must be valid timestamps of the format YYYY-MM-ddTHH:mm:ss and can only span 1 year");
        }
        if (this.citiService.isRunning()) {
            return this.badRequest("Unable to start citi job because one is already running");
        }
        try (ExecutorService executorService = Executors.newSingleThreadExecutor();){
            executorService.execute(() -> this.citiService.loadAndProcess(startDate, endDate));
        }
        return ResponseEntity.ok().body((Object)String.format("Started citi job with startDate: %s, endDate: %s", startDate, endDate));
    }

    @GetMapping(value={"/status"}, produces={"text/plain"})
    public String getStatus() {
        return this.citiService.status();
    }

    private ResponseEntity<String> badRequest(String errorMessage) {
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)errorMessage);
    }

    private boolean validDates(LocalDateTime startDate, LocalDateTime endDate) {
        if (startDate != null) {
            LocalDateTime end = Optional.ofNullable(endDate).orElse(LocalDateTime.now());
            return startDate.isBefore(end) && ChronoUnit.DAYS.between(startDate, end) < 366L;
        }
        return true;
    }

    public CitiService getCitiService() {
        return this.citiService;
    }

    public void setCitiService(CitiService citiService) {
        this.citiService = citiService;
    }
}

