/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.nonpersonnel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BudgetJustificationWrapper
implements Serializable {
    private String justificationText;
    private String lastUpdateTime;
    private String lastUpdateUser;
    private static final Logger LOG = LogManager.getLogger(BudgetJustificationWrapper.class);

    public BudgetJustificationWrapper(String budgetJustificationAsXML) {
        this.parse(budgetJustificationAsXML);
    }

    public BudgetJustificationWrapper(Date lastUpdateTime, String lastUpdateUser, String justificationText) {
        this.justificationText = justificationText;
        this.lastUpdateUser = lastUpdateUser;
        this.setLastUpdateTime(lastUpdateTime);
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public String getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getJustificationText() {
        return this.justificationText;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser;
    }

    public void setLastUpdateTime(String lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        this.lastUpdateTime = formatter.format(lastUpdateTime);
    }

    public void setJustificationText(String justificationText) {
        this.justificationText = justificationText;
    }

    public String toString() {
        String string;
        DocumentBuilderFactory docFactory = SafeXmlUtils.safeDocumentBuilderFactory();
        StringWriter out = new StringWriter();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element rootElement = document.createElement("budgetJustification");
            rootElement.setAttribute("lastUpdateBy", this.lastUpdateUser);
            rootElement.setAttribute("lastUpdateOn", this.lastUpdateTime);
            document.appendChild(rootElement);
            CDATASection cdata = document.createCDATASection(this.justificationText == null ? "" : this.justificationText);
            rootElement.appendChild(cdata);
            Transformer tf = SafeXmlUtils.safeTransformerFactory().newTransformer();
            tf.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            tf.setOutputProperty("indent", "no");
            tf.transform(new DOMSource(document), new StreamResult(out));
            string = ((Object)out).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)out).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException | TransformerException e) {
                throw new RuntimeException(e);
            }
        }
        ((Writer)out).close();
        return string;
    }

    private void parse(String budgetJustificationAsXML) {
        if (budgetJustificationAsXML == null || budgetJustificationAsXML.trim().length() == 0) {
            return;
        }
        DocumentBuilderFactory dbf = SafeXmlUtils.safeDocumentBuilderFactory();
        try (ByteArrayInputStream is = new ByteArrayInputStream(budgetJustificationAsXML.getBytes(StandardCharsets.UTF_8));){
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new InputSource(is));
            Element node = document.getDocumentElement();
            this.lastUpdateUser = node.getAttribute("lastUpdateBy");
            this.lastUpdateTime = node.getAttribute("lastUpdateOn");
            this.justificationText = node.getTextContent();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.warn("Unable to parse budget justification XML.", (Throwable)e);
        }
    }
}

