/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.pdf.forms;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.pdf.forms.PdfForms;
import org.kuali.coeus.common.framework.pdf.forms.PdfFormsService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="pdfFormsService")
public class PdfFormsServiceImpl
implements PdfFormsService {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public List<PdfForms> activeByModuleCode(String moduleCode) {
        if (StringUtils.isBlank((CharSequence)moduleCode)) {
            throw new IllegalArgumentException("moduleCode is blank");
        }
        return this.getBusinessObjectService().findMatching(PdfForms.class, Map.of("active", true, "moduleCode", moduleCode));
    }

    @Override
    public PdfForms byId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id is null");
        }
        return (PdfForms)this.getBusinessObjectService().findBySinglePrimaryKey(PdfForms.class, (Object)id);
    }

    @Override
    public Set<String> systemDefaults() {
        return PdfForms.SYSTEM_DEFAULTS_PREFIXES;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

